import AbstractControl from "../../../common/component/control/AbstractControl";
import DomElement from "../../../common/dom/element/DomElement";
import OperationDispatcher from "../../../common/operation/OperationDispatcher";
import WfDefines from "../../../design/bpm/base/WfDefines";


export default class YigoGrid extends AbstractControl<DomElement> {

    private grid: any;

    public $el: any;

    private operationDispatcher?: OperationDispatcher;

    private form: any;

    constructor(grid: any, el: HTMLElement, operationDispatcher?: OperationDispatcher) {
        super(new DomElement(el));
        this.grid = grid;
        this.$el = $(el);
        this.operationDispatcher = operationDispatcher;
        this.form = this.operationDispatcher?.getForm();
    }

    async init(): Promise<void> {
        var width = WfDefines.USER_PROPERTY_WIDTH - 15;
        await this.clearRows();
        await this.grid.setEnable(true);
        if (this.grid) {
            this.grid.el && this.grid.el.setGridWidth(width);
            var height = this.grid.height ? this.grid.height : 0;
            height = (height < 60 ? 60: height);
            this.setGridHeight(height);
        }
    }

    setGridHeight(height: number): void {
        this.grid.el && this.grid.el.setGridHeight(height);
    }

    async clearRows(): Promise<void> {
        if (this.grid) {
            var dataModel = this.grid.dataModel;
            if (!dataModel || !dataModel.data) {
                return;
            }
            await this.deleteAllRows();
            if (this.grid.el && this.grid.el[0]) {
                this.grid.dataModel.data.length = 0;
                this.grid.hideCount = 0;
                this.grid.rowIDMask = 0;
                this.grid.rowIDMap = {};

                this.grid.el[0].cleanSelection();
                this.grid.el[0].p.editCells = [];
                this.grid.el[0].p.records = 0;
                this.grid.el[0].p.page = 1;
                this.grid.el[0].p.lastpage = 1;
                this.grid.el[0].p.reccount = 0;
                this.grid.el[0].grid.bDiv.scrollTop = 0;
                this.grid.el[0].grid.bDiv.scrollLeft = 0;
            }
        }
    }

    private async deleteAllRows(): Promise<void> {
        var count = this.grid.getRowCount();
        for (var i = 0; i<count; i++) {
            await this.grid.deleteRowAt(0, false);
        }
    }

    setCellEnable(rowIndex: number, colIndex: number, enable: boolean): void {
        this.grid.setCellEnable(rowIndex, colIndex, enable);
    }

    async setValueAt(rowIndex: number, colIndex: number, value: any): Promise<void> {
        await this.grid.setValueAt(rowIndex, colIndex, value);
    }

    async insertRow(rowIndex: number) : Promise<number> {
        var row = await this.grid.insertRow(rowIndex, true);
        return row;
    }



   /* appendEmptyRow(rowIndex: number) : number {
        return this.grid.appendEmptyRow(rowIndex);
    }*/

    setValue(value: any): void {
    }

    getValue(): any {
        return undefined;
    }

    getShowText(): any {
        return undefined;
    }
}