
import AbstractControl from "../../../common/component/control/AbstractControl";
import DomElement from "../../../common/dom/element/DomElement";
import SizeInfo from "../../../common/struct/SizeInfo";
import FormOperationExecutor from "../form/FormOperationExecutor";

export default class YigoControl extends AbstractControl<DomElement> {

    private component: YIUI.Component;

    constructor(component: YIUI.Component, optExecutor?: FormOperationExecutor) {
        super(new DomElement(component.getEl().getElm()));
        this.component = component;
    }

    getShowText(): any {
        return this.component.getShowText();
    }

    getValue(): any {
        return this.component.getValue();
    }

    setHeight(height: SizeInfo) {
        super.setHeight(height);
        this.component.setHeight(height.getValue());
    }

    setWidth(width: SizeInfo) {
        super.setWidth(width);
        this.component.setWidth(width.getValue());
    }
}