import AbstractControl from "../../../common/component/control/AbstractControl";
import DomElement from "../../../common/dom/element/DomElement";
import FormOperationExecutor from "../form/FormOperationExecutor";

export default class YigoCodeDict extends AbstractControl<DomElement> {

    private dict: any;

    private optExecutor: FormOperationExecutor;

    constructor(dict: any, el: HTMLElement, optExecutor: FormOperationExecutor) {
        super(new DomElement(el));
        this.dict = dict;
        this.optExecutor = optExecutor;
    }

    async setValue(value: any): Promise<void> {
        if (!value) return;
        var id = await this.optExecutor.queryDictID(this.dict.itemKey, value);
        this.dict.setValue(id);
    }

    async getValue(): Promise<any> {
        if (!this.dict.getValue() || this.dict.getValue() <= 0) return '';
        return await this.optExecutor.eval(`GetDictValue('${this.dict.itemKey}', ${this.dict.getValue()}, 'Code')`);
    }

    getShowText(): any {
        return this.dict.getShowText();
    }
}