// Type definitions for Yigo
// TypeScript Version: 3.0
/// <reference types="mina" />

//export = YIUI;
//export as namespace YIUI;

interface JQueryStatic {
    toJSON(content: any): any;
}

declare namespace ERPDESIGNER {
    var selectedComponentKey: any;
    namespace UI {
        //var isDesignMode: boolean;
        function getActiveERPForm(): YIUI.UIForm;
        function doUICommands(form: any, uiCommand: any): void;
    }
    namespace Service {
        function saveFileContent(webMapPath: string, content: any, key: string): any;
    }
}

declare namespace Svr {
    export class Request {
        constructor(form?: any);
        getData(params: any): any;
    }
}

declare namespace YIUI {
    var isDesignMode: boolean;
    var webRoot: string;

    var YesCustomBuilder: any;

    var WebPlugin: any;

    namespace ControlType {
        var COMBOBOX: number;
        var LABEL: number;
        var LISTVIEW: number;
        var GRID: number;
        var SEPARATOR: number;
        var CUSTOM: number;
    }

    namespace FuncMap {
        function get(): any;
    }

    namespace BuilderMap {
        function getInstance(): any;
    }

    export class ViewContext {
        constructor(form: any)
    }
    
    export class YesBaseComponent {
        value: any;
        el: any;
        owner: any; // Component | Control;
        constructor(options: any);
    }

    namespace FormTarget {
        export var SELF: number;
        export var STR_SELF: string;
        export var NEWTAB:number; 
        export var STR_NEWTAB: string;
        export var MODAL:number;
        export var STR_MODAL: string;
        export var STACK: number;
    }
    
    export interface UIForm {
        ruleLocator: any;
        checkview: any;
        entryPath: string;
        target: any;
        popHeight: any;
        dialog: any;
        getRoot(): Component;
        getFormKey(): string;
        getGrid(key: string): any;
        getGridArray(): Grid[];
        getComponent(key: string): any;
        getComponentList(): Component[];
        setComponentValue(key: string, value: any, fireEvent: boolean): void;
        eval(exp: string, ctx: any, para: any): Promise<any>;
        asyncEval(exp: string, ctx: any, para: any): Promise<any>;
        getCellLocation(cellKey: string): CellLocation;
        getParentForm(): UIForm | undefined;
        getDocument(): any;
        getSubDetail(key: string): string[];
    }

    namespace DataUtil {
        function toJSONDoc(doc: any): any;
    }

    namespace I18N {
        function getString(key: string, defaultValue: string): string;
    }

    namespace FormStack {
        var formList: UIForm[];
        function getForm(ofFormID: string): UIForm;
        function getActiveForm(): UIForm;
    }

    namespace GridUtil {
        function isEmptyRow(rowData: GridRowData): boolean;
    }

    export interface Grid {
        key: string,
        tableKey: string
    }

    export class ShowGridData {
        constructor(form: any, grid: any);
        load(b: boolean): void;
    }

    export class GridRowBuilder {
        constructor(form: any, grid: any);
        build(): void;
    }

    export class DictService {
        constructor(form: any);
        locate(itemKey: string, field: string, value: any, filter: any, root: any, statMask: number): any;
    }

    namespace Panel {
        //var GridLayoutPanel:any;
        export class GridLayoutPanel extends Panel {
            widths: [];
            minWidths: [];
            heights: [];
            rowGap: number;
            columnGap: number;
            oddColumnColor: string
            forceLayout: boolean;
        }
    }

    export class Panel extends Component {
        //el: JQuery;
        items: Component[];
        metaObj: any;
        layout: any
        customLayoutRender: any;
        //extraLayout: IExtraLayout;
        getWidth(): number;
        getHeight(): number;
        getMetaObj(): any;
    }

    export interface IExtraLayout {
        type: 'Collapsible' | 'Property';
        groupCollection: IGroupItem[]
    }

    export interface IGroupItem {
        key: string;                // 分组标志
        caption: string;            // 分组标题
        expanded?: boolean;   // 是否默认展开分组,默认为true
        startRow: number;           // 纵向起始位置，GridLayout中的 y        
        endRow?: number;            // 纵向结束位置，GridLayout中的 y
        startCol?: number;
        endCol?: number;
        handle?: IGroupControl;
    }
    
    export interface IGroupControl extends ILocation {
        type: 'SubAdd' | 'Switch' | 'UpDown' | 'Custom';           // Custom|Switch|UpDown|SubAdd
        expandStyleClass?: string;
        collapseStyleClass?: string;
        format?: IFormat;
    }

    export interface IFormat {
        foreColor?: string;
        font?: IFont;
    }

    export interface IFont {
        name?: string;
        bold?: boolean;
        italic?: boolean;
        size?: number;
        underline?: boolean;
        underlineColor?: string
    }
    
    export interface ILocation {
        x:number, y:number, xSpan: number, ySpan: number
    }

    export enum CONTROLTYPE {
        COMBOBOX = 204,
        LABEL = 209,
        LISTVIEW = 216,
        GRID = 217,
        SEPARATOR = 231,
        CUSTOM = 10000
    }

    export enum PageLoadType {
        NONE = 0,
        STR_NONE = "NONE",
        UI =1,
        STR_UI = "UI",
        DB =2,
        STR_DB = "DB"
    }

    export enum RowType {
        FIXED = 0,
        FIXED_STRING = "Fixed",
        GROUP = 1,
        GROUP_STRING = "Group",
        DETAIL = 2,
        DETAIL_STRING = "Detail",
        GROUPTAIL = 3,
        GROUPTAIL_STRING = "GroupTail"
    }

    /** form操作状态 */
    export enum Form_OperationState {
        Default = 0,
        New =  1,
        Edit =  2,
        Delete =  3
    }

    /** form界面状态 */
    export enum FormUIStatusMask {
        ENABLE =  0x0001,
        VISIBLE =  0x0002,
        OPERATION =  0x0004,
        CHECKRULE =  0x0008
    }

    /** 系统字段*/
    export enum SystemField {
        /** 对象的ID */
        OID_SYS_KEY = "OID",
        /** 主数据对象的ID */
        SOID_SYS_KEY = "SOID",
        /** 父对象的ID */
        POID_SYS_KEY = "POID",
        /** 对象的版本 */
        VERID_SYS_KEY = "VERID",
        /** 对象的明细控制版本 */
        DVERID_SYS_KEY = "DVERID",
        /** 编号*/
        NO_SYS_KEY = "NO",
        /** 状态*/
        STATUS_SYS_KEY = "Status",
        /** 已映射的数量 */
        MAPCOUNT_SYS_KEY = "MapCount",
        /** 选择字段 */
        SELECT_FIELD_KEY = "SelectField",
        /** 序号字段*/
        SEQUENCE_FIELD_KEY = "Sequence",
        /** 附件路径*/
        PATH = "Path",
        /** 附件名称*/
        NAME = "Name",
        /** 附件上传时间*/
        UPLOAD_TIME = "UploadTime",
        /** 附件上传者*/
        UPLOAD_OPERATOR = "UploadOperator"
    }

    export class ErrorInfo {
        error: boolean;
        errorMsg: string;
    }

    export class Component {

        ofFormID: any;
        
        key: string;

        meta: any;

        caption: string;

        type: number;

        tagName: string;

        editable: boolean;
        /**
         * 是否可用
         */
        enable: boolean;
    
        /**
         * Boolean。
         * 是否可见
         */
        visible: boolean;

        x: number;
        y: number;
        rowspan: number;
        colspan: number;
    
        /**
         * Number、百分比、auto。
         * 组件的宽度、高度。
         * Number: 像素值，固定大小；
         * 百分比: 相对于父组件的宽度、高度；
         * auto: 自适应大小。
         */
        width: number;
        height: number;
    
        format: any;
  
        listeners: any;
    
        /** 触发事件
         *  在组件作为TabPanel面板的子项时，如果子项被选中，触发该事件。
         *  */
        active: any;
    
        /** 伙伴组件的标识 */
        buddyKey: string;
    
        /** 是否是伙伴组件*/
        buddy: boolean;
    
        /** 是否是继承组件*/
        extend: boolean;
    
        /**是否在初始化值以后重新加载不清除,默认是可以清除*/
        clearable: boolean;
    
        needRender: boolean;

        rendered: boolean;

        errorInfo: ErrorInfo;

        ownerCt: any;

        parentGridKey: string;

        isDestroyed: boolean;

        //@ts-ignore
        getEl(): JQuery | any;

        //@ts-ignore
        doRender($container: JQuery): void;

        setHeight (height: number): void;

        getHeight(): number;

        setWidth (width: number): void;

        getWidth(): number;

        getShowText(): string;
        
        getValue(): any;

        isRequired(): boolean;

        accept(fn: any): void;

        getSubComponents(): Component[];

        doLayout(width: number | string, height: number | string): void;

        calcAutoHeight(): number;
    }

    class Control extends Component {
        value: any;
        backupValue: string;
        text: string;
        checkRule: string;
        trigger: string;
        initValue: boolean;
        isNull(): boolean;
        commitValue(): void;
        rollbackValue(): void;
        setValue(value: any, commit: boolean, fireEvent: boolean, ignoreChanged: boolean, editing: boolean): void;
        setControlValue(value: any): void;
        getValue(): any;
        getOldValue(): any;
        setText(text: string): void;
        getText(): string;
    }

    namespace Control {

        export class Grid extends Control {
            constructor(meta: any)
            setEnable(enable: boolean): void;
            setColumnVisible(index: number, visible: boolean, refreshGrid: boolean): void;
            setValueByKey(rowIndex: number, cellKey: string, newValue: any, commitValue: boolean, fireEvent: boolean): void;
            setCellBackColor(rowIndex: number, colIndex: number, color: string): void; 
            setCellForeColor(rowIndex: number, colIndex: number, color: string): void; 
            setFocusCell(rowIndex: number, colIndex: number): void; 
            setCaptionAt(rowIndex: number, colIndex: number, caption: string): void; 
            setValueAt(rowIndex: number, colIndex: number, newValue: any, commitValue: boolean, fireEvent: boolean, ignoreChanged: boolean, cellData: any, editOpt: any): void;
            getCellEditOpt(rowIndex: number, colIndex: number): MetaGridCell; 
            getMetaCellByColumnKey(columnKey: string): any; 
            getValueByKey(rowIndex: number, cellKey: string): any;
            getValueAt(rowIndex: number, colIndex: number): any
            insertRow(rowIndex: number, fireEvent: boolean): number;
            addGridRow(rowIndex: number, metaRow: any, bookmarkRow: any, groupLevel: number, fireEvent: boolean, treeInfo: any): number;
            refreshIndex(index: number): void;
            appendAutoRowAndGroup(): void;
            appendEmptyRow(rowIndex: number): number;
            appendEmptyGroup(): void;
            removeAutoRowAndGroup(): void;
            deleteRowAt( rowIndex: number, fireEvent: boolean, isLastDelete: boolean): void;
            deleteRow(rowIndex: number, fireEvent: boolean): boolean;
            hasColumnExpand(): boolean;
            getRowIndexByID(rowID: any): number;
            getRowDataAt(rowIndex: number): GridRowData;

            getCellDataAt(rowIndex: number, colIndex: number): any;
            setColumnEnable(colIndex: number, enable: boolean): void;
            getColumnAt(colIndex: number): ColumnInfo;
            getMetaColumnAt(colIndex: number): any;
            setCellEnable(rowIndex: number, colIndex: number, enable: boolean): void;
            // 设置单元格必填
            setCellRequired(rowIndex: number, colIndex: number, isRequired: boolean): void;
            // 设置单元格错误
            setCellError(rowIndex: number, colIndex: number, error: any, errorMsg: any): void;
            // 设置行背景色
            setRowBackColor(rowIndex: number, backColor: string): void;
            // 设置行错误
            setRowError(rowIndex: number,error: any,errorMsg: any, errorSource: any): void;
            // 设置行可见
            setRowVisible(rowIndex: number, visible: boolean): void;
            // 刷新行序号
            refreshRowNo(): void;
            // 重新render!!
            refreshGrid(): void;
            // 界面列排序后，刷新sequence字典值
            refreshSeqence(): void;
           
            load(construct: any): void;

            loadSubDetail(): void;
        
            reset(): void;

            refreshOpt(): void;

            clearGridData(): void;
        
            clearAllRows(fireEvent: boolean): void;

            getPageInfo(): PageInfo;
        
            getRowCount(): number;
            /**
             * 获取表格某个字段的值的集合
             */
            getFieldArray(form: any, colKey: string, condition: any): any;
        
            /**
             * 判断值是否为空值. null,'',undefined,0都是空值,下拉框只要选择了,就不是空值,没选''或者null
             */
            isNullValue (value:any): boolean;
        
            checkEquals (o1: any,o2: any): boolean;
        
            // 非拓展使用
            setColumnCaption(cellKey: string, caption: string): void;
        
            getColumnCount(): number;
            // 设置表格焦点行(触发事件,如行点击等)
            setFocusRowIndex (rowIndex: number, focus: boolean): void;

            getFocusRowIndex(): number;

            getFocusColIndex(): number;
            // 设置表格焦点(触发事件,如行点击等)
            focus(): void;
            // 向焦点策略请求下一个焦点
            requestNextFocus(): void;
            isActivity(): boolean;
            getLastEmptyRowIndex():number;
        
            // 获取明细行之前隐藏的行数量,用来计算行序号
            getHideRowCount(): number;

            getMetaObj(): any;
        
            // 是否需要检查全选状态
            needCheckSelect:true;

            refreshSelectAll(): void;

            ofFormID: any;

            variantName?: string;

            variant: any;

            searchview: any;

            showRowHead: boolean;

            dataModel: GridDataModel;

            gridHandler: GridHandler;
            
            impl: any;

            tableKey: string;

            needReloadVariant: boolean;

            hasTree: boolean;
        }
    }

    class MetaGridCell {
        key: string;
        caption: String;
        accessControl: boolean;
        defaultValue: string;
        enable: string;
        tableKey: string;
        valueChanged: string;
        cellType: string;
        columnKey: string;
    }

    class GridRowData {
        key: string;
        rowType: RowType;
        cellKeys: string[];
        metaRowIndex: number;
        areaIndex: number;
        isDetail: boolean;
        isFix: boolean;
        rowID: string;
        data: [];
        visible: boolean;
        error: any;
        backColor: string;
        metaBackColor: string;
        metaVisible: string;
        rowHeight: number;
        bkmkRow: any;
        isUIProcessed: boolean;
    }

    class GridHandler {
        doGoToPage(grid: YIUI.Control.Grid, pageIndex: number, needShow: boolean): Promise<void> ;
    }

    class PageInfo {
        currentPage: number;
        curPageIndex: number;
        totalRowCount: number;
        pageLoadType: number;
        pageRowCount: number;
        pageIndicatorCount: number;
    }

    class GridDataModel {
        columns: ColumnInfo[];
        colModel: GridColumnModel;
    }

    class GridColumnModel {
        columns: ColumnInfo[];
    }

    class ColumnInfo {
        columnType: string;
        formulaCaption: string;
        hidden: boolean;
        index: number;
        key: string;
        expandColumnKey: string;
        label: string; //3.1.6及以下版本的caption
        caption: string; //3.3及以上版本的caption
        name: string;
        parentKey: string;
        sortable: boolean;
        visible: boolean;
        width: string | number;
        widthOrg: number;
        captionOrg?: string;
        hiddenWithoutVariant?: boolean; // 未应用变式时的可见性
    }

    export function extend(base: Object, ext: Object): any;

    export function reg(key: string, control: any): void;

    /** VNode */
    export function h(p: string): any;

    export var toVNode: (p: any) => any;

    class YElement {
        constructor(vnode: any);
        
        getYelementData(): any;

        $click(handler: Function): void;

        $appendTo(container: YElement): YElement;
 
        $append(child: YElement | YElement[]): YElement;

        $appendTo(container: YElement): YElement;

        $prependTo(container: YElement): YElement;

        $insertBefore(elm: YElement): YElement;

        $insertAfter(elm: YElement): any;

        $remove(): YElement;

        $empty(): YElement;

        getElm(): HTMLElement;

        getHook(hookName: string): any;

        setHook(hookName: string, hookFun: Function): void;

        getComputedStyle(): any;

        $addClass(cssClass: string): YElement;

        $removeClass(cssClass?: string): YElement;

        hasClass(cssClass: string): boolean;

        $toggleClass(cssClass: string): YElement;

        $addStyle(name: string, value: string): YElement;

        getStyle(name: string): any;

        $appendStyles(styles: Map<string, string>):YElement;
        
        $setVKey(value: any): YElement;

        getVKey(): any;

        $setAttr(name: string, value?: string | number | boolean | null): YElement;

        getAttr(name: string): any;

        $setProp(name: string, value?: any): YElement;

        getProp(name: string): any;

        $setDataSet(name: string, value?: string): YElement;

        getDataSet(name: string): any;

        $setAttachData(name: string, value?: any):YElement;

        getAttachData(name: string): any;

        $setInputValue(value: string | number): YElement;

        getInputValue(): string;

        $setInnerText(innerText: string): YElement;

        getInnerText(): string;

        $addListener(eventName: string, handler: Function): YElement;

        $removeListener(eventName?: string, handler?: Function): YElement;

        $mousedown(handler: Function): YElement;

        $mouseup(handler: Function): YElement;

        $mousemove(handler: Function): YElement;

        $mouseleave(handler: Function): YElement;

        $click(handler: Function): YElement;

        $scroll(handler: Function): YElement;

        $dblclick(handler: Function): YElement;

        $keydown(handler: Function): YElement;

        $keyup(handler: Function): YElement;

        $show(displayVal?: string): YElement;

        $hide(): YElement;

        $slideInit(options?: { speed?: number | string, timeCurve?: string, delay?: number }): YElement;

        $slideUp(): YElement;

        $slideDown(): YElement;

        isShow(): boolean;

        isHide(): boolean;

        getWidth(): string | number;

        $setWidth(w: string | number): YElement;

        getHeight(): string | number;

        $setHeight(h: string | number): YElement;

        $callSync(name: string, data?: any): YElement;

        $call(name: string, data?: any): YElement;

        $focus(): YElement;

        $blur(): YElement;

        $parents(callback: (parent: YElement) => boolean): YElement;

        $parentsAll(callback: (parent: YElement) => boolean, level?: number): YElement[];

        $parent(): YIUI.YElement | undefined;

        $next(): YElement | undefined;

        $prev(): YElement | undefined;
        
        index(): number;

        $find(callback: (parent: YElement) => boolean, level?: number): YElement[];

        $findByTagName(tag: string, level?: number): YElement[];

        $findByClassName(className: string, level?: number): YElement[];

        $findById(id: string, level?: number): YElement | null;

        $clone(): YElement;

        // A、B 兄弟节点交换位置
        $switchWith(elm: YElement): YElement;

        // A节点替换成B节点(A将不存在)
        $replaceWith(elm: YElement): YElement;

        // 第一个子节点
        childNode(): YElement | null;

        // 最后一个子节点
        lastNode(): YElement | null;

        getChildElms(includeStr?: boolean): (YElement | string)[];

        addPostpatchHook(callback: any): void;

        //pagination(options?: object): PageModel | undefined;
    }

    namespace YElement {
        export function buildFromVNode(node: any): any;
    }
}

declare class CellLocation{
    key: string;
    column: number;
    columns: [];
    row: number;
    rows: [];
    tableKey: string;
    columnKey: string;
    expand: boolean;
}

declare namespace View {
    namespace FuncMap {
        function put(funName: string, fun: (name: string, cxt: Object, args: []) => any): void;
    }

    export class Context {
        constructor(form: any);
    }
}

declare namespace DataDef {
    export var R_New: number;
    export var R_Modified: number;
    export var R_Deleted: number;

    export var D_Normal: number;
    export var D_New: number;
    export var D_Modified: number;
    export var D_Deleted: number;

    export var D_Obj: number;
    export var D_ObjDtl: number;

    export class Row {
        bkmk: number;
        state: number;
        orgVals: any;
        vals: [];
    }

    export class DataTable {
        allRows: Row[];
        clone(): DataTable;
        getCol(index: number): any;
        getColByKey(colKey:string): any;
        getColumnCount(): number;
        addRow(): number;
        insert(rowIndex: number, needDefValue: boolean): number;
        size(): number;
        setPos(pos: number): void;
        getPos(): number;
        getState(): number;
        setState(state: number): void;
        setByBkmk(bkmk: number): void;
        getByBkmk(): number;
        setParentBkmk(pbkmk: number): void;
        getParentBkmk(): number;
        beforeFirst(): void;
        afterLast(): void;
        next(): boolean;
        previous(): boolean;
        first(): boolean;
        last(): boolean;
        getRowCount(): number;
        isBeforeFirst(): boolean;
        isAfterLast(): boolean;
        isFirst(): boolean;
        isLast(): boolean;
        isValid(): boolean;
        get(index: number): any;
        createOriginData(vals: any): any;
        setObject(row: number, index: number, val: any): void;
        set(index: number,val: any, changeState: number): void;
        indexByKey(key: string): number;
        getByKey(key: string): any;
        setByKey(key: string, val: any, changeState: boolean): void;
        setNew(): void;
        setShowDelete(showDel: boolean): void;
        clear(): void;
        delAll(): void;
        delRow(index: number): void;
        batchUpdate(): void;
        setFilterEval(filterEval: any): void;
        getFilterEval(): any;
        filter(): void;
        clearFilter(): void;
        setSort(columnKey: string, ascending: boolean): void;
        setSortCriteria(sc: any): void;
        clearCriteria(): void;
        sort(): void;
    }
}
