import { AreaDesignerOption, DesignerOption } from './yiui/design/interfaces/Options';
//import './css/property.css';
import IDesigner from './yiui/design/interfaces/IDesigner';
import BPMNWorkSpace from './design/bpm/BPMNWorkSpace';
import FormOperationExecutor from './yiui/design/form/FormOperationExecutor';
import { EDesignMode } from './common/enum/Enums';
import I18N from './design/bpm/base/I18N';
import CodeMirrorLoader from './design/plugin/loader/CodeMirrorLoader';
import WebPluginXResourceLoader from './design/plugin/loader/WebPluginXResourceLoader';
import YigoPropertyLayoutRender from './yiui/web/ui/layout/YigoPropertyLayoutRender';
import YigoDesignFuns from './yiui/design/funs/YigoDesignFuns';
import YigoCollapsibleLayoutRender from './yiui/web/ui/layout/YigoCollapsibleLayoutRender';
import AreaWorkBench from './yiui/design/grouparea/AreaWorkBench';
import YigoWebFuns from './yiui/web/funs/YigoWebFuns';
import XmlEntityUtil from './common/xml/util/XmlEntityUtil';
import IXmlEntity from './common/xml/IXmlEntity';
import ActionNames from './common/event/ActionNames';
import XmlEntity from './common/xml/XmlEntity';
import IWorkSpace from './common/workspace/IWorkSpace';
import PrintWorkSpace from './design/print/PrintWorkSpace';
import PrintConstants from './common/GlobalSetting';
import ExcelWorkSpace from "./design/excel/ExcelWorkSpace";
import DataMigrationWorkSpace from "./design/datamigration/DataMigrationWorkSpace";
import GridSettingVariant from './yiui/web/variant/GridSettingVariant';
import ContentSearchBox from './common/component/control/ContentSearchBox';
import PopupSearchView from './yiui/web/ui/view/PopupGridSearchView';
import YIUIResourceLoader from './yiui/plugin/loader/YIUIResourceLoader';
import DataMapWorkSpace from "./design/datamap/DataMapWorkSpace";
import ComponentLocator from './yiui/web/ui/view/locator/ComponentRuleLocator';
import FormUtils from './yiui/web/ui/util/FormUtils';
import VNodeXElement from './common/dom/xelement/vnode/VNodeXElement';
import DomElement from './common/dom/element/DomElement';
import ComponentUtils from './yiui/web/ui/util/ComponentUtils';
import GridTreeMenuView from './yiui/web/ui/view/GridTreeMenuView';

declare global {
    interface Window {
        DesignEnv: any;
    }
}

// 加载设计器相关的css、js
new WebPluginXResourceLoader();
// 加载codemirror相关的css、js
new CodeMirrorLoader();
// 加载yigo相关css
new YIUIResourceLoader();

export default (function webpluginx(): IDesigner {
    const webpluginx = <IDesigner> function(): void {};
    ComponentUtils.installCustomBuiler();
    new YigoDesignFuns();
    if (YIUI.WebPlugin && YIUI.WebPlugin.YigoWebFuns) {
        new YigoWebFuns();
    }

    I18N.register("RunDictFormula('C_FALSE')", "否");
    I18N.register("RunDictFormula('C_TRUE')", "是");

    // 获取每毫米的像素值
    function getOneMmsPx() {
        let div = document.createElement("div");
        div.style.width = "1mm";
        document.body.appendChild(div);
        setTimeout( () =>{
            let mm1 = div.getBoundingClientRect();
            document.body.removeChild(div);
            PrintConstants.initMMPX(mm1.width);
        },500)
    }
    getOneMmsPx();
    webpluginx.showGridTreeMenu = function(grid: YIUI.Control.Grid, parent: HTMLElement) {
        if ( grid.getEl() && grid.hasTree) {
            if (GridTreeMenuView.getInstance().isShowing(grid)) {
                GridTreeMenuView.getInstance().hide();
            } else {
                let height = 70;
                GridTreeMenuView.getInstance().show(grid, 0, parent.clientHeight - height, 120, height, parent);
            }
        }
    }

    webpluginx.hideGridTreeMenu = function() {
        GridTreeMenuView.getInstance().hide();
    }

    webpluginx.installComponentLocator = function(form: YIUI.UIForm) {
        if (form.getRoot().getEl() && !form.ruleLocator) {
            form.ruleLocator = new ComponentLocator(form);
            form.ruleLocator.updateState();
        }
    }

    webpluginx.openAreaSpace = function(options: AreaDesignerOption) {
        var activeForm = ERPDESIGNER.UI.getActiveERPForm();
        var comp = activeForm.getComponent(options.panelKey);
        if (!comp) return;
        var gridPanel = <YIUI.Panel.GridLayoutPanel> comp;
        var areaSpace  = new AreaWorkBench(gridPanel);
        var formExecutor = new FormOperationExecutor(options.form, EDesignMode.Dev);
        formExecutor.setEditable(true);
        areaSpace.setOperationExecutor(formExecutor);

        var parent = options.parentEl;
        parent.appendChild(areaSpace.getEl());
        areaSpace.doLayout(new DomElement(parent).getEl());
        areaSpace.doSelectRoot();
        return {
            workspace: areaSpace,
            setHeight: function(height: number) {
                areaSpace.updateLayout();
            },
            setWidth: function(width: number) {
                areaSpace.updateLayout();
            },
            setVisible: function(bVisible: boolean) {},

            setEnable: function(bEnable: boolean) {},

            setValue: function(value: any): void {
                return areaSpace.load(value);
            },
            getValue: function(): string {
                return areaSpace.toXml(false);
            }
        };
    }

    webpluginx.renderPropertyPanel = function (parent: HTMLElement, panel: YIUI.Panel) {
        if (!panel.customLayoutRender) {
            panel.customLayoutRender = new YigoPropertyLayoutRender(panel);
        }
        (<YigoPropertyLayoutRender> panel.customLayoutRender).doRender(parent);
    }

    webpluginx.renderCollapsiblePanel = function (panel: YIUI.Panel) {
        if (!panel.getEl()) return;  // 3.1.6 BaseComponent.js中存在 checkNeedRender，只有当前活动面板才会真正渲染
        if (!panel.customLayoutRender) {
            panel.customLayoutRender = new YigoCollapsibleLayoutRender(panel);
        }
        (<YigoCollapsibleLayoutRender> panel.customLayoutRender).doRender();
    }

    webpluginx.loadGridSettingVariant = async function(grid:YIUI.Control.Grid) {
        !grid.variant && installGridSettingVariant(grid);
        await (<GridSettingVariant> grid.variant).loadGridSettingVariant(false);
    }

    webpluginx.saveGridSettingVariant = async function(grid:YIUI.Control.Grid) {
        !grid.variant && installGridSettingVariant(grid);
       await (<GridSettingVariant> grid.variant).saveGridSettingVariant();
    }

    var installGridSettingVariant = function(grid:YIUI.Control.Grid) {
        var variant = GridSettingVariant.newInstance(grid);
        grid.variant = variant;
    }

    webpluginx.installGridSearchPlugin = function(grid: YIUI.Control.Grid) {
        var $gridContent = grid.getEl().closest('.ui-ygrid');
        if ($gridContent.length > 0) {
            var searchBox = new ContentSearchBox();
            var popSearchView = new PopupSearchView(searchBox, grid);
            popSearchView.addClass("ui-ygrid-searchpopview");
            $(popSearchView.getEl()).appendTo($gridContent);
            grid.searchview = popSearchView;
        }
    }

    webpluginx.clearSearchStyle = function(grid:YIUI.Control.Grid) {
        var $el = grid.getEl();
        if ($el) {
            $('tr', $el).removeClass('find-row-style');
            $('td', $el).removeClass('find-cell-style find-focusCell-style');
        }
    }

    webpluginx.formatXml = function(content: string) {
        var xmlEntity = XmlEntity.parse(content);
        return xmlEntity.getXml(false);
    }

    webpluginx.locateComponent = async function(compKey: string, form: YIUI.UIForm) {
        await FormUtils.locateHeadComponent(compKey, form);
    }

    webpluginx.locateGridCell = async function(gridKey: string, row: number, col: number, form: YIUI.UIForm) {
        await FormUtils.locateGridCell(gridKey, row, col, form);
    }

    webpluginx.locateGridRow = async function(gridKey: string, row: number, form: YIUI.UIForm) {
        await FormUtils.locateGridRow(gridKey, row, form);
    }

    webpluginx.openWorkSpace = function(options: DesignerOption) {
        var mode: EDesignMode = options.mode;
        if (window.YIUI && YIUI.isDesignMode) mode = EDesignMode.Local;
        var workSpace: IWorkSpace;
        if (options.type == 'bpmn') {
            workSpace = new BPMNWorkSpace(mode);
        } else if (options.type == 'print') {
            workSpace = new PrintWorkSpace(mode);
        } else if (options.type == 'excel') {
            workSpace = new ExcelWorkSpace(mode);
        } else if (options.type == 'datamigration') {
            //@ts-ignore
            workSpace = new DataMigrationWorkSpace(mode, options.form.WebMapPath);
        } else if (options.type == 'datamap') {
            //@ts-ignore
            workSpace = new DataMapWorkSpace(mode, options.form.WebMapPath);
        } else {
            workSpace = new BPMNWorkSpace(mode);
        }

        // 载入时调用的公式需要获取workspace
        options.component && (options.component.custom = {workspace: workSpace});
        workSpace.doLayout(options.parentEl);

        var form = options.form;
        if (form) {
            var formExecutor = new FormOperationExecutor(form, mode);
            workSpace.setOperationExecutor(formExecutor);
            workSpace.setEditable(options.enable);
        }
        workSpace.load(options.xml);

        var prepareXmlChangeListener = function(xmlEntity: IXmlEntity) {
            xmlEntity.addEventListener({notifyEvent: (cmd, paras) => {
                    if (cmd != ActionNames.model_node_update_select && cmd !=  ActionNames.model_node_update_multi_select) {
                        var xml = workSpace.toXml(true);
                        options.component && options.component._setValue(xml, true, false);
                    }
                }});
        };
        prepareXmlChangeListener(workSpace.getXmlEntity());

        return {
            workspace: workSpace,
            setHeight: function(height: number) {
                workSpace.updateLayout();
            },
            setWidth: function(width: number) {
                workSpace.updateLayout();
            },

            setVisible: function(bVisible: boolean) {
                workSpace.setDisplay(bVisible);
            },

            setEnable: function(bEnable: boolean) {
                workSpace.setEditable(bEnable);
                workSpace.updateLayout();
                bEnable && XmlEntityUtil.refreshSelection(workSpace.getXmlEntity());
            },

            setValue: function(value: any): void {
                workSpace.load(value);
                value && prepareXmlChangeListener(workSpace.getXmlEntity());

            }
        };
    }

    FormUtils.installCustomRelayoutListener();
    return webpluginx;
})();


