import { AbstractEmbedView } from "./AbstractEmbedView";
import BaseConstants from './../../../../base/BaseConstants';
import ITagNode from "../../../../../common/xml/node/ITagNode";
import PrintTableLayout from "../PrintTableLayout";
import JComponent from "../../../../../common/component/JComponent";
import PrintEmbedLayout from "./PrintEmbedLayout";
import {EHAlign, EVAlign} from "../../../../../common/enum/Enums";
import PrintConstants from "../../../base/PrintConstants";
import Span from "../../../../../common/component/control/Span";
import SizeInfo from "../../../../../common/struct/SizeInfo";

export class TextEmbedView extends AbstractEmbedView  {
    private tagEmbed: ITagNode;


   /* private tDisplay: TDisplay;

    private tFont: TFont;

    private tBorder: TBorder;*/


    constructor(tagNode: ITagNode){
        super(tagNode);
        let text  =  new Span("");
        text.setText(this.getText());
        text.addClass("embed-text")
        this.appendChild(text);
        this.tagEmbed = tagNode;
        this.updateView();
    }
    updateView(): void {
        let node = this.tagEmbed;
        this.setHeight(SizeInfo.valueOfPX(node.getAttributeValueInt(BaseConstants.ATTR_Height,0)));
        this.setWidth(SizeInfo.valueOfPX(node.getAttributeValueInt(BaseConstants.ATTR_Width,0)));
        this.addClass("print-embed-comp");
        this.setStyle('left', (node.getAttributeValueInt(BaseConstants.ATTR_X,0)).toString()+"px");
        this.setStyle('top', (node.getAttributeValueInt(BaseConstants.ATTR_Y,0)).toString()+"px");

        // ... 设置字体样式等 todo
    }

    getText(): string {
        return this.getTagNode().getAttributeValue(BaseConstants.ATTR_Caption);
    }

    appendChild(any: any) {
        this.getEl().appendChild(any.getEl());
    }
}





class TDisplay {

    private tagDisplay!: ITagNode;

    init(tagDisplay: ITagNode) {
        this.tagDisplay = tagDisplay;
    }

    getHAlign(): string {
        if (!this.tagDisplay) return EHAlign.Center;
        return this.tagDisplay.getAttributeValue(PrintConstants.ATTR_HAlign, EHAlign.Center);
    }

    getVAlign(): string {
        if (!this.tagDisplay) return EVAlign.Center;
        return this.tagDisplay.getAttributeValue(PrintConstants.ATTR_VAlign, EVAlign.Center);
    }

    getBackColor(): string {
        if (!this.tagDisplay) return "";
        return this.tagDisplay.getAttributeValue(BaseConstants.ATTR_BackColor, "");
    }

    getForeColor(): string {
        if (!this.tagDisplay) return "";
        return this.tagDisplay.getAttributeValue(BaseConstants.ATTR_ForeColor, "");
    }
}