import AbstractDomElement from "../../../../common/dom/AbstractDomElement";
import DomElement from "../../../../common/dom/element/DomElement";
import SpanElement from "../../../../common/dom/element/SpanElement";
import {EHAlign, EUnderLineStyle, EVAlign} from "../../../../common/enum/Enums";
import ITagNode from "../../../../common/xml/node/ITagNode";
import BaseConstants from "../../../base/BaseConstants";
import PRINT from "../../base/PRINT";
import PrintConstants from "../../base/PrintConstants";
import IPrintElementView from "./IPrintElementView";

export class CellView extends SpanElement implements IPrintElementView {

    private tagCell: ITagNode;

    private tDisplay: TDisplay;

    private tFont: TFont;

    private tBorder: TBorder;
    private colindex: number;
    private rowindex: number;

    private imageDomElement?: DomElement;

    constructor(tagCell: ITagNode, rowindex: number, colindex: number) {
        super();
        var span = new DomElement(this.getEl());
        span.setAttr("rowindex", String(rowindex));
        span.setAttr("colindex", String(colindex));
        this.tagCell = tagCell;
        this.tDisplay = new TDisplay();
        this.tFont = new TFont();
        this.tBorder = new TBorder();
        this.rowindex = rowindex;
        this.colindex = colindex;
        this.prepareTDisplay();
    }

    getRowIndex(): number {
        return this.rowindex;
    }

    getColIndex(): number {
        return this.colindex;
    }

    getDomElement(): AbstractDomElement {
        return this;
    }

    findChildNode(tagNode: ITagNode): IPrintElementView | null {
        return null;
    }

    isEmbed(): boolean {
        return false;
    }

    containPoint(x: number, y: number): boolean {
        return false;
    }

    getTagNode(): ITagNode {
        return this.tagCell;
    }

    prepareTDisplay() {
        var tagDisplay = this.tagCell.getChild(BaseConstants.NODE_Display);
        tagDisplay && this.tDisplay.init(tagDisplay);

        var tagFont = tagDisplay ? tagDisplay.getChild(BaseConstants.NODE_Font) : undefined;
        tagFont && this.tFont.init(tagFont);

        var tagBorder = tagDisplay ? tagDisplay.getChild(BaseConstants.NODE_Border) : undefined;
        tagBorder && this.tBorder.init(tagBorder);
    }

    /**
     * 更新单元格内容，并设置样式
     */
    updateView(): void {
        this.prepareTDisplay();
        this.setText(this.getCaption());

        var containerEl = this.parentEl();
        if (containerEl) {//td
            var container = new DomElement(containerEl);
            if(this.tagCell.isSelected()){
                var image = new DomElement(new Image(16, 16));
                image.setAttr("src", PRINT.PREFIX + "/css/img/ExcelSelect.png");
                image.setAttr("rowindex", String(this.rowindex));
                image.setAttr("colindex", String(this.colindex));
                image.addClass("selected-td-img");
                container.addChild(image);
                this.imageDomElement = image;
                container.addClass('selected')
            } else{
                container.removeClass('selected');
            }
            let rowNode = this.getTagNode().getParent();
            var rowBackColor =  rowNode!.getAttributeValue(BaseConstants.ATTR_BackColor, "");
            var  backColor = this.tDisplay.getBackColor();
            if (backColor.length >0){
                container.setStyle('background-color', backColor);
            }else {
                container.setStyle('background-color', rowBackColor);
            }

            var foreColor = this.tDisplay.getForeColor();
            this.setStyle('color', foreColor);

            var hAlign = this.tDisplay.getHAlign();
            var vAlign = this.tDisplay.getVAlign();
            switch (hAlign) {
                case EHAlign.Left:
                    container.setStyle('text-align', 'left');
                    break;
                case EHAlign.Center:
                    container.setStyle('text-align', 'center');
                    break;
                case EHAlign.Right:
                    container.setStyle('text-align', 'right');
                    break;
            }
            switch (vAlign) {
                case EVAlign.Top:
                    container.setStyle('vertical-align', 'top');
                    break;
                case EVAlign.Center:
                    container.setStyle('vertical-align', 'middle');
                    break;
                case EVAlign.Bottom:
                    container.setStyle('vertical-align', 'bottom');
                    break;
            }
            var bottomColor = this.tBorder.getBottomColor();
            var leftColor = this.tBorder.getLeftColor();
            var rightColor = this.tBorder.getRightColor();
            var topColor = this.tBorder.getTopColor();

            //0xcccc33ff
            if (bottomColor.length > 7) {
                container.setStyle('border-bottom-color', "#" + bottomColor.substring(2));
                container.setStyle('border-right-color', "#" + rightColor.substring(2));
                container.setStyle('border-left-color', "#" + leftColor.substring(2));
                container.setStyle('border-top-color', "#" + topColor.substring(2));
            } else {
                container.setStyle('border-bottom-color', bottomColor);
                container.setStyle('border-right-color', rightColor);
                container.setStyle('border-left-color', leftColor);
                container.setStyle('border-top-color', topColor);
            }

            let bottomStyle = this.tBorder.getBottomStyle();
            switch (bottomStyle) {
                case "0":
                    //无线
                    container.setStyle('border-bottom-style', "dotted");
                    container.setStyle('border-bottom-color', "#E0E0E0");
                    container.setStyle('border-bottom-width', 'thin');
                    break;
                case "1":
                    //"solid"//实线
                    container.setStyle('border-bottom-style', "solid");
                    container.setStyle('border-bottom-width', 'thin');
                    break;
                case "2":
                    //"dotted"//点状
                    container.setStyle('border-bottom-style', "dotted");
                    container.setStyle('border-bottom-width', 'thin');
                    break;
                case "3":
                    //"solid"//加粗实线
                    container.setStyle('border-bottom-width', 'medium');
                    container.setStyle('border-bottom-style', "solid");
                    break;
                default:
                    container.setStyle('border-bottom-style', "none");
                    break;
            }

            var leftStyle = this.tBorder.getLeftStyle();
            switch (leftStyle) {
                case "0":
                    container.setStyle('border-left-style', "dotted");
                    container.setStyle('border-left-color', "#E0E0E0");
                    container.setStyle('border-left-width', 'thin');
                    break;
                case "1":
                    //"solid"//实线
                    container.setStyle('border-left-style', "solid");

                    container.setStyle('border-left-width', 'thin');
                    break;
                case "2":
                    //"dotted"//点状
                    container.setStyle('border-left-style', "dotted");

                    container.setStyle('border-left-width', 'thin');
                    break;
                case "3":
                    //"solid"//加粗实线
                    container.setStyle('border-left-width', 'medium');
                    container.setStyle('border-left-style', "solid");
                    break;
                default:
                    container.setStyle('border-left-style', "none");
                    break;
            }
            var rightStyle = this.tBorder.getRightStyle();
            switch (rightStyle) {
                case "0":
                    container.setStyle('border-right-style', "dotted");
                    container.setStyle('border-right-color', "#E0E0E0");
                    container.setStyle('border-right-width', 'thin');
                    break;
                case "1":
                    //"solid"//实线
                    container.setStyle('border-right-style', "solid");

                    container.setStyle('border-right-width', 'thin');
                    break;
                case "2":
                    //"dotted"//点状
                    container.setStyle('border-right-style', "dotted");

                    container.setStyle('border-right-width', 'thin');
                    break;
                case "3":
                    //"solid"//加粗实线
                    container.setStyle('border-right-width', 'medium');
                    container.setStyle('border-right-style', "solid");
                    break;
                default:
                    container.setStyle('border-right-style', "none");
                    break;
            }
            var topStyle = this.tBorder.getTopStyle();
            switch (topStyle) {
                case "0":
                    container.setStyle('border-top-style', "dotted");
                    container.setStyle('border-top-color', "#E0E0E0");

                    container.setStyle('border-top-width', 'thin');
                    break;
                case "1":
                    //"solid"//实线
                    container.setStyle('border-top-style', "solid");

                    container.setStyle('border-top-width', 'thin');
                    break;
                case "2":
                    //"dotted"//点状
                    container.setStyle('border-top-style', "dotted");

                    container.setStyle('border-top-width', 'thin');
                    break;
                case "3":
                    //"solid"//加粗实线
                    container.setStyle('border-top-width', 'medium');
                    container.setStyle('border-top-style', "solid");
                    break;
                default:
                    container.setStyle('border-top-style', "none");
                    break;
            }

            container.setAttr('colspan', this.getMergedColumnSpan());
            container.setAttr('rowspan', this.getMergedRowSpan());
            if (!this.getMergedHead() && this.isMerged()) {
                container.addClass("divisioncell");
            } else {
                container.removeClass("divisioncell");
            }
            container.setAttr("colindex", String(this.colindex));
            container.setAttr("rowindex", String(this.rowindex));
        }
        this.setStyle('font-family', this.tFont.getName());
        this.setStyle('font-weight', this.tFont.isBold() ? 'bold' : '');
        this.setStyle('font-style', this.tFont.isItalic() ? 'italic' : '');
        this.setStyle('font-size', this.tFont.getSize() + 'px');
        if (this.tFont.getUnderLine() == "None") {
            this.setStyle('text-decoration', "none");
            this.setStyle('border-bottom', "");
        } else if (this.tFont.getUnderLine() == "SolidNormal") {
            this.setStyle('text-decoration-line', "underline");
            this.setStyle('border-bottom', "");
            this.setStyle('text-decoration-style', "solid");
        } else if (this.tFont.getUnderLine() == "Dashed") {
            this.setStyle('border-bottom', "");
            this.setStyle('text-decoration-line', "underline");
            this.setStyle('text-decoration-style', "dashed");
        } else if (this.tFont.getUnderLine() == "SolidBold") {
            this.setStyle('text-decoration-line', "underline");
            this.setStyle('text-decoration-style', "solid");
            this.setStyle('border-bottom', "1px solid");
        }
    }

    getCaption(): string {
        var value = "";
        var child = this.tagCell.getChild("CellText");
        if (child){
            value = child.getCDATAValue();
            if (value == ""){
                value = this.tagCell.getAttributeValue(BaseConstants.ATTR_Caption);
            }
        } else {
            value = this.tagCell.getAttributeValue(BaseConstants.ATTR_Caption);
        }

        return value
    }

    getColumnExpand(): string {
        return this.tagCell.getAttributeValue(BaseConstants.ATTR_COLUMEXPAND);
    }

    getGroupType(): string {
        return this.tagCell.getAttributeValue(BaseConstants.ATTR_COLUMTYPE);
    }

    getKey(): string {
        return this.tagCell.getAttributeValue(BaseConstants.ATTR_Key);
    }

    getMergedColumnSpan(): string {
        return this.tagCell.getAttributeValue(BaseConstants.ATTR_ColSpan);
    }

    getMergedRowSpan(): string {
        return this.tagCell.getAttributeValue(BaseConstants.ATTR_RowSpan);
    }

    getMergedHead(): boolean {
        return this.tagCell.getAttributeValueBoolean(BaseConstants.ATTR_Merged_Head, false);
    }

    isMerged(): boolean {
        return this.tagCell.getAttributeValueBoolean(BaseConstants.ATTR_ISMERGED, false);
    }
}

class TDisplay {

    private tagDisplay!: ITagNode;

    init(tagDisplay: ITagNode) {
        this.tagDisplay = tagDisplay;
    }

    getHAlign(): string {
        if (!this.tagDisplay) return EHAlign.Center;
        return this.tagDisplay.getAttributeValue(PrintConstants.ATTR_HAlign, EHAlign.Center);
    }

    getVAlign(): string {
        if (!this.tagDisplay) return EVAlign.Center;
        return this.tagDisplay.getAttributeValue(PrintConstants.ATTR_VAlign, EVAlign.Center);
    }

    getBackColor(): string {
        if (!this.tagDisplay) return "";
        return this.tagDisplay.getAttributeValue(BaseConstants.ATTR_BackColor, "");
    }

    getForeColor(): string {
        if (!this.tagDisplay) return "";
        return this.tagDisplay.getAttributeValue(BaseConstants.ATTR_ForeColor, "");
    }
}

class TFont {

    private tagFont!: ITagNode;

    init(tagFont: ITagNode) {
        this.tagFont = tagFont;
    }

    getName(): string {
        if (!this.tagFont) return PRINT.D_FONT_NAME;
        return this.tagFont.getAttributeValue(BaseConstants.ATTR_Name, PRINT.D_FONT_NAME);
    }

    getSize(): number {
        if (!this.tagFont) return PRINT.D_FONT_SIZE;
        return this.tagFont.getAttributeValueInt(BaseConstants.ATTR_FONT_Size, PRINT.D_FONT_SIZE);
    }

    isBold(): boolean {
        if (!this.tagFont) return false;
        return this.tagFont.getAttributeValueBoolean(BaseConstants.ATTR_FONT_Bold, false);
    }

    isItalic(): boolean {
        if (!this.tagFont) return false;
        return this.tagFont.getAttributeValueBoolean(BaseConstants.ATTR_FONT_Italic, false);
    }

    getUnderLine(): string {
        if (!this.tagFont) return EUnderLineStyle.None;
        return this.tagFont.getAttributeValue(BaseConstants.ATTR_FONT_Underline, EUnderLineStyle.None);
    }

    /*
        private String name = "";
        private int size = -1;
        private boolean bold = false;
        private boolean italic = false;
        private int underlineStyle = ReportUnderLineStyle.None;
         */
    /*  var foreColor = tagFormat.getAttributeValue(AreaConstants.ATTR_ForeColor);
     this.textSpan.setStyle('color', foreColor ? foreColor : '');
     var tagFont = tagFormat.getChild(AreaConstants.NODE_Font);
     if (tagFont) {
         var fontName = tagFont.getAttributeValue(AreaConstants.ATTR_FONT_Name);
         this.textSpan.setStyle('font-family', fontName ? fontName : '');

         var isBold = tagFont.getAttributeValueBoolean(AreaConstants.ATTR_FONT_Bold, false);
         this.textSpan.setStyle('font-weight', isBold ? 'bold' : '');

         var isItalic = tagFont.getAttributeValueBoolean(AreaConstants.ATTR_FONT_Italic, false);
         this.textSpan.setStyle('font-font-style', isItalic ? 'italic' : '');

         var size = tagFont.getAttributeValue(AreaConstants.ATTR_FONT_Size);
         this.textSpan.setStyle('font-size', size ? size + 'px' : ''); */
}

class TBorder {
    private tagBorder!: ITagNode;

    init(tagBorder: ITagNode) {
        this.tagBorder = tagBorder;
    }

    getLeftColor(): string {
        if (!this.tagBorder) return ""
        return this.tagBorder.getAttributeValue(BaseConstants.ATTR_LEFTCOLOR, "");
    }

    getBottomColor(): string {
        if (!this.tagBorder) return ""
        return this.tagBorder.getAttributeValue(BaseConstants.ATTR_BOTTOMCOLOR, "");
    }

    getRightColor(): string {
        if (!this.tagBorder) return ""
        return this.tagBorder.getAttributeValue(BaseConstants.ATTR_RIGHTCOLOR, "");
    }

    getTopColor(): string {
        if (!this.tagBorder) return ""
        return this.tagBorder.getAttributeValue(BaseConstants.ATTR_TDPCOLOR, "");
    }

    getBottomStyle(): string {
        if (!this.tagBorder) return "0"
        return this.tagBorder.getAttributeValue(BaseConstants.ATTR_BOTTOMSTYLE, "0");
    }

    getTopStyle(): string {
        if (!this.tagBorder) return "0"
        return this.tagBorder.getAttributeValue(BaseConstants.ATTR_TOPSTYLE, "0");
    }

    getRightStyle(): string {
        if (!this.tagBorder) return "0"
        return this.tagBorder.getAttributeValue(BaseConstants.ATTR_RIGHTSTYLE, "0");
    }

    getLeftStyle(): string {
        if (!this.tagBorder) return "0"
        return this.tagBorder.getAttributeValue(BaseConstants.ATTR_LEFTSTYLE, "0");
    }


}

class TCellText {
    private tagCellText!: ITagNode;

    init(tagCellText: ITagNode) {
        this.tagCellText = tagCellText;
    }

    getLeftColor(): string {
        if (!this.tagCellText) return ""
        return this.tagCellText.getAttributeValue(BaseConstants.ATTR_LEFTCOLOR, "");
    }
}

class TFormat {
    private tagFormat!: ITagNode;

    init(tagFormat: ITagNode) {
        this.tagFormat = tagFormat;
    }

    getDataType(): string {
        return this.tagFormat.getAttributeValue(BaseConstants.ATTR_DATATYPE);
    }

    getFormatString(): string {
        return this.tagFormat.getAttributeValue(BaseConstants.ATTR_FORMATSTRING);
    }
}

class TColumnExpand {
    private tagColumnExpand!: ITagNode;

    init(tagColumnExpand: ITagNode) {
        this.tagColumnExpand = tagColumnExpand;
    }

    getLeftColor(): string {
        if (!this.tagColumnExpand) return ""
        return this.tagColumnExpand.getAttributeValue(BaseConstants.ATTR_LEFTCOLOR, "");
    }
}

//ColumnExpand
/**
 *  <Display HAlign="Right" VAlign="Top">
 <Cell Caption="公式定义">
 <Display HAlign="Left">
 <Font Bold="true" Name="SimSun" Size="14"/>
 <Border BottomColor="#000000" BottomStyle="1" LeftColor="#000000" LeftStyle="1" RightColor="#000000" RightStyle="1" TopColor="#000000" TopStyle="1"/>
 </Display>
 </Cell>
 */