import PopupPanel from "../../../common/component/container/panel/PopupPanel";
import JComponent from "../../../common/component/JComponent";
import SideToolbox from "../../../common/component/toolbox/SideToolbox";
import ToolFontItem from "../../../common/component/toolbox/ToolFontItem";
import Events from "../../../common/event/Events";
import I18N from "../../bpm/base/I18N";
import SVG from "../../bpm/base/SVG";
import WfConstants from "../../bpm/base/WfConstants";
import PrintGraphicView from "./PrintGraphicView";

export default class PrintToolbox extends SideToolbox {

    private graphicView!: PrintGraphicView;

    private subToolboxTask: SideToolbox;

    private subToolboxGateway: SideToolbox;

    private popup: PopupPanel;
    
    constructor() {
        super();
        this.popup = new PopupPanel();
        this.getDomElement().addChild(this.popup);

        this.subToolboxTask = this.createSubTask();
        this.subToolboxGateway = this.createSubGateway();
        this.init();
    }

    bindGraphicView(graphicView: PrintGraphicView): void {
        this.graphicView = graphicView;
        this.graphicView.addEventListener(Events.Click, () => this.hideToolboxPopPanel(), true);
    }

    private init(): void {
        var item = this.addFontItem("hand", {cls: ['entry', 'iconfont', 'icon-bpmn-normal']});
        item.setTitle(I18N.getString(WfConstants.NODE_Hand));
        item.addEventListener(Events.MouseDown, () =>  this.graphicView.getOptStateDelegate().reset(), true);

        this.addSeparator();

        item = this.addFontItem(WfConstants.NODE_Event_Begin, {cls: ['entry', 'bpmn-icon-start-event-none']});
        item.setTitle(I18N.getString(WfConstants.NODE_Event_Begin));
        this.initNormalNodeEvent(item, false);
        
        item = this.addFontItem(WfConstants.NODE_Gateway, {cls: ['entry', 'bpmn-icon-gateway-none']});
        item.setTitle(I18N.getString(WfConstants.NODE_Gateway));
        var top = this.getPos(item);
        this.initSubGatewayMouseEvent(item, top);

        item = this.addFontItem(WfConstants.NODE_Task, {cls: ['entry', 'bpmn-icon-task']});
        item.setTitle(I18N.getString(WfConstants.NODE_Task));
        top = this.getPos(item);
        this.initSubTaskMouseEvent(item, top);

        item = this.addFontItem(WfConstants.NODE_SubProcess, {cls: ['entry', 'bpmn-icon-subprocess-collapsed']});
        item.setTitle(I18N.getString(WfConstants.NODE_SubProcess));
        this.initNormalNodeEvent(item, false);

    }

    private initSubGatewayMouseEvent(item: ToolFontItem, top: number): void {
        item.addEventListener(Events.MouseOver, (event: any) => {
            if (!this.graphicView.isEditable()) return;
            event = event || window.event;
            this.hideToolboxPopPanel();
            this.popup.setContent(this.subToolboxGateway.getDomElement());
            this.popup.show(48, top - 80, 48, this.subToolboxGateway.getPreHeight(), this.getDomElement().getEl());
        }, true);
    }

    private initSubTaskMouseEvent(item: ToolFontItem, top: number): void {
        item.addEventListener(Events.MouseOver, (event: any) => {
            if (!this.graphicView.isEditable()) return;
            this.hideToolboxPopPanel();
            this.popup.setContent(this.subToolboxTask.getDomElement());
            this.popup.show(48, top - 100, 48, this.subToolboxTask.getPreHeight(), this.getDomElement().getEl());
        }, true);
    }

    private initNewLinkEvent(item: ToolFontItem): void {
        var self = this;
        item.addEventListener(Events.MouseDown, (event: any) => {
            if (!this.graphicView.isEditable()) return;
            event = event || window.event;
            var id = event.target.id;
        }, true);
        item.addEventListener(Events.MouseOver, () => this.hideToolboxPopPanel(), true);
    }

    private initNormalNodeEvent(item: JComponent<any>, bSub: boolean): void {
        item.addEventListener(Events.MouseDown, (event: any) => {
            if (!this.graphicView.isEditable()) return;
            event = event || window.event;
            var id = item.getKey();
        }, true);
        if (!bSub) {
            item.addEventListener(Events.MouseOver, () => this.hideToolboxPopPanel(), true);
        }
    }

    public hideToolboxPopPanel(): void {
        this.popup.hide();
    }

    private createSubGateway(): SideToolbox {
        var sideToolbox = new SideToolbox();
        var subitem = sideToolbox.addSvgItem(WfConstants.NODE_Gateway_GateWay, SVG.get(WfConstants.NODE_Gateway_GateWay), {cls: ['entry']});
        subitem.setTitle(I18N.getString(WfConstants.NODE_Gateway_GateWay));
        this.initNormalNodeEvent(subitem, true);

        subitem = sideToolbox.addSvgItem(WfConstants.NODE_Gateway_Join, SVG.get(WfConstants.NODE_Gateway_Join), {cls: ['entry']});
        subitem.setTitle(I18N.getString(WfConstants.NODE_Gateway_Join));
        this.initNormalNodeEvent(subitem, true);
        return sideToolbox;
    }

    private createSubTask(): SideToolbox {
        var sideToolbox = new SideToolbox();
        var subitem = sideToolbox.addFontItem(WfConstants.NODE_Task_Audit, {cls: ['entry', 'iconfont', 'icon-bpmn-audit']});
        subitem.setTitle(I18N.getString(WfConstants.NODE_Task_Audit));
        this.initNormalNodeEvent(subitem, true);

        subitem = sideToolbox.addFontItem(WfConstants.NODE_Task_MultiAudit, {cls: ['entry', 'iconfont', 'icon-bpmn-multiaudit']});
        subitem.setTitle(I18N.getString(WfConstants.NODE_Task_MultiAudit));
        this.initNormalNodeEvent(subitem, true);
        return sideToolbox
    }
}