import Toolbar from "../../../common/component/toolbar/Toolbar";
import SizeInfo from "../../../common/struct/SizeInfo";
import H5GridPanel from "../../../common/component/container/panel/H5GridPanel";
import JComponent from "../../../common/component/JComponent";
import GridLayoutItem from "../../../common/component/container/panel/layout/item/GridLayoutItem";
import IEventListener from "../../../common/listener/IEventListener";
import Paras from "../../../common/struct/Paras";
import ActionNames from "../../../common/event/ActionNames";
import AbstractControl from "../../../common/component/control/AbstractControl";
import PRINT from "../base/PRINT";
import PrintButtonBox from "./PrintButtonBox";

export default class PrintToolbar extends H5GridPanel implements IEventListener {
    private toolbarList: Map<string, any>

    constructor() {
        super();
        this.addClass("bpm-toolbar")
        this.toolbarList = new Map();
    }

    addItems(key: string, component: JComponent<any>): void {
        this.toolbarList.set(key, component);
    }

    addComponent(component: JComponent<any>, x: number = 0, y: number = 0, xSpan: number = 1, ySpan: number = 1): GridLayoutItem {
        var gridLayoutItem = super.addComponent(component, x, y, xSpan, ySpan);
        this.addItems(component.getKey(), component);
        return gridLayoutItem;
    }

    getToolBarItems(): Map<string, any> {
        return this.toolbarList;
    }


    notifyEvent(cmd: string, paras: Paras): void {
        if (ActionNames.model_node_update_select == cmd) {
            this.updateToobar(this, paras);
        } else if (ActionNames.model_node_update == cmd) {
            this.updateToobar(this, paras);
        }
    }

    updateToobar(printToolbar: PrintToolbar, paras: Paras) {

        //   this.updateToobar(this.getToolBar(),paras);
        var toolBarItems = printToolbar.getToolBarItems();
        var element = paras.getElement();
        /*if (element.tagName == "Grid") {
            return;
        } else if (element.tagName == "Section") {
            var colType: AbstractControl<any> = toolBarItems.get("colType");
            colType.setValue(element.getAttributeValue("Type"))

        } else if (element.tagName == "Row") {
            var rowType: AbstractControl<any> = toolBarItems.get("rowType");
            rowType.setValue(element.getAttributeValue("Type"))
        } else*/
        if (element && element.tagName == "Cell") {
            var rowType: AbstractControl<any> = toolBarItems.get("rowType");
            var colType: AbstractControl<any> = toolBarItems.get("colType");
            var row = element.getParent();
            if (!row) {
                return;
            }
            var section = row.getParent().getParent();
            let type = section.getAttributeValue("Type");
            if (type !="Table"){
                rowType.getEl().setAttribute("disabled","true");
            }else {
                rowType.getEl().removeAttribute("disabled");
            }
            rowType.setValue(row.getAttributeValue("Type"))
            colType.setValue(section.getAttributeValue("Type"))
            var display = element.getChild("Display");
            var font;
            var border;
            var encodingType: AbstractControl<any> = toolBarItems.get("EncodingType");
            var errorCorrectionLevel: AbstractControl<any> = toolBarItems.get("ErrorCorrectionLevel");
            var backColor: AbstractControl<any> = toolBarItems.get("BackColor");
            var foreColor: AbstractControl<any> = toolBarItems.get("ForeColor");
            //var hAlign: AbstractControl<any> = toolBarItems.get("HAlign");
            var left_align: AbstractControl<any> = toolBarItems.get("left_align");
            var center_align: AbstractControl<any> = toolBarItems.get("center_align");
            var right_align: AbstractControl<any> = toolBarItems.get("right_align");
            var top_align: AbstractControl<any> = toolBarItems.get("top_align");
            var vcenter_align: AbstractControl<any> = toolBarItems.get("vcenter_align");
            var bottom_align: AbstractControl<any> = toolBarItems.get("bottom_align");
            //var vAlign: AbstractControl<any> = toolBarItems.get("VAlign");
            var margin: AbstractControl<any> = toolBarItems.get("Margin");
            var showType: AbstractControl<any> = toolBarItems.get("ShowType");
            if (display) {
                font = display.getChild("Font");
                border = display.getChild("Border");
                encodingType.setValue(display.getAttributeValue("EncodingType","UTF-8"));
                errorCorrectionLevel.setValue(display.getAttributeValue("ErrorCorrectionLevel","L"));
                backColor.setValue(display.getAttributeValue("BackColor"));
                foreColor.setValue(display.getAttributeValue("ForeColor"));
                margin.setValue(display.getAttributeValue("Margin","0"));
                showType.setValue(display.getAttributeValue("ShowType","TEXT"));
                var hAlign = display.getAttributeValue("HAlign");
                var vAlign = display.getAttributeValue("VAlign");
                switch (vAlign) {
                    case "Top":
                        top_align.setValue("true");

                        vcenter_align.setValue("false");

                        bottom_align.setValue("false");

                        break;
                    case "Bottom":
                        top_align.setValue("false");
                        vcenter_align.setValue("false");
                        bottom_align.setValue("true");
                        break;
                    default:
                        top_align.setValue("false");
                        vcenter_align.setValue("true");
                        bottom_align.setValue("false");
                        break;
                }
                switch (hAlign) {
                    case "Left":
                        left_align.setValue("true");
                        center_align.setValue("false");
                        right_align.setValue("false");
                        break;
                    case "Right":
                        left_align.setValue("false");
                        center_align.setValue("false");
                        right_align.setValue("true");
                        break;
                    default:
                        left_align.setValue("false");

                        center_align.setValue("true");


                        right_align.setValue("false");
                        break;
                }
            } else {
                encodingType.setValue("UTF-8");
                showType.setValue("TEXT");
                errorCorrectionLevel.setValue("L");
                margin.setValue("0");
                backColor.setValue("");
                foreColor.setValue("");
                left_align.setValue("false");
                center_align.setValue("true");
                right_align.setValue("false");
                top_align.setValue("false");
                vcenter_align.setValue("true");
                bottom_align.setValue("false");

            }
            //字体
            var name: AbstractControl<any> = toolBarItems.get("Name");
            //字体大小
            var size: AbstractControl<any> = toolBarItems.get("Size");
            var underLine: AbstractControl<any> = toolBarItems.get("UnderLine");
            var bold: AbstractControl<any> = toolBarItems.get("Bold");
            var italic: AbstractControl<any> = toolBarItems.get("Italic");
            if (font) {
                size.setValue(font.getAttributeValue("Size"));
                name.setValue(font.getAttributeValue("Name"));
                //underLine.setValue(font.getAttributeValue("UnderLine") != "" ? font.getAttributeValue("UnderLine")
                // : "SolidNormal");

                bold.setValue(font.getAttributeValue("Bold"));
                italic.setValue(font.getAttributeValue("Italic"));
            } else {
                size.setValue("");
                name.setValue("");
                //underLine.setValue("SolidNormal");
                bold.setValue("false");
                italic.setValue("false");
            }
         /*   // var borderColor: AbstractControl<any> = toolBarItems.get("BorderColor");//边框颜色
            var border_style: PrintButtonBox = toolBarItems.get("border_style");//边框模式
            var images1 = ['url("' + PRINT.PREFIX + '/css/img/border_none.png") center no-repeat',
                'url("' + PRINT.PREFIX + '/css/img/border_style1.png") center no-repeat',
                'url("' + PRINT.PREFIX + '/css/img/border_style_dashed.png") center no-repeat',
                'url("' + PRINT.PREFIX + '/css/img/border_style_medium.png") center no-repeat']
            border_style.buttonText.setStyle("background", images1[Number(border_style.buttonText.getValue())]);

            var borderStyle: PrintButtonBox = toolBarItems.get("BorderStyle");//边框类型
            var images = [
                'url("' + PRINT.PREFIX + '/css/img/cell_full_border.png") center no-repeat',
                'url("' + PRINT.PREFIX + '/css/img/cell_no_border.png") center no-repeat',
                'url("' + PRINT.PREFIX + '/css/img/cell_full_out_border.png") center no-repeat',
                'url("' + PRINT.PREFIX + '/css/img/cell_left_out_border.png") center no-repeat',
                'url("' + PRINT.PREFIX + '/css/img/cell_right_out_border.png") center no-repeat',
                'url("' + PRINT.PREFIX + '/css/img/cell_top_out_border.png") center no-repeat',
                'url("' + PRINT.PREFIX + '/css/img/cell_bottom_out_border.png") center no-repeat',
                'url("' + PRINT.PREFIX + '/css/img/cell_left_border.png") center no-repeat',
                'url("' + PRINT.PREFIX + '/css/img/cell_right_border.png") center no-repeat',
                'url("' + PRINT.PREFIX + '/css/img/cell_top_border.png") center no-repeat',
                'url("' + PRINT.PREFIX + '/css/img/cell_bottom_border.png") center no-repeat'
            ];
            borderStyle.buttonText.setStyle("background", images[Number(borderStyle.buttonText.getValue())]);*/
            //
            // if (border) {
            //     //borderColor.setValue(border.getAttributeValue("BottomColor"));
            //     //borderStyle.setValue(border.getAttributeValue("BottomStyle"));
            //     borderColor.setValue("");
            //     borderStyle.setValue("");
            // } else {
            //     borderColor.setValue("");
            //     borderStyle.setValue("");
            // }
        } else {
            return;
        }


        /*toolBarItems.forEach(function (value, key, map) {
            if (key != "ToolBar") {
                var print: AbstractControl<any> = toolBarItems.get("Name");
                print.setValue("3");
            }
        })*/
        /* for (let i = 1; i < layout.getLayoutItems().length; i++) {
             var layoutItem: GridLayoutItem = layout.getLayoutItem(i);
             var node: H5HFlexPanel = layoutItem.getNode();
             var h5FlexLayout = node.getLayout();

         }*/

    }
}