import ButtonElement from "../../../common/dom/element/ButtonElement";
import AbstractControl from "../../../common/component/control/AbstractControl";
import SizeInfo from "../../../common/struct/SizeInfo";
import Button from "../../../common/component/control/Button";
import AbstractDomElement from "../../../common/dom/AbstractDomElement";
import PRINT from "../base/PRINT";


export default class PrintButtonBox extends AbstractControl<ButtonElement> {

    public buttonText: Button;

    public button: Button;
    public buttonContainer: ButtonContainer

    constructor(key: string, buttonContainerItems: string[],width:SizeInfo,height:SizeInfo) {
        super(new ButtonElement(""));
        this.buttonText = new Button("");
        this.button = new Button("");
        this.button.setStyle("background", 'url("'+PRINT.PREFIX+'/css/img/drop_down.png") center no-repeat');
        this.button.setStyle(" background-size", '100%');
        this.buttonText.setStyle("border-right", 'solid 1px #DDD');
        this.setStyle("border", 'solid 1px #DDD');
        this.setStyle("margin-left", "4px");
        this.setStyle("border-radius", "3px");
        this.setStyle("margin-top", "2px");
        this.getDomElement().addChild(this.buttonText.getDomElement());
        this.getDomElement().addChild(this.button.getDomElement());
        this.buttonContainer = new ButtonContainer(buttonContainerItems,width.toString(),height.toString());
        this.setKey(key);
        var self = this;
        this.button.addEventListener("click", function (event: any) {
            event = event || window.event;
            if (self.getDomElement().getChildCount()>2){
                self.getDomElement().removeChild(self.buttonContainer);
            }else {
                self.getDomElement().addChild(self.buttonContainer);
                self.buttonContainer.getEl().focus();
            }
           // var {offsetBodyLeft, offsetBodyTop} = DomUtil.offsetBodyPosition(self.button.getEl());
          //  console.log(offsetBodyLeft + ":" + offsetBodyTop);
        }, true);
        this.buttonContainer.addEventListener("mousedown", (e: any) => {
            var el = e.target;
            if (el.classList.contains('property-Container-item')) {
                var item: ContainerItem = <ContainerItem> self.buttonContainer.findElement(el);
                self.setValue(item.getEl().getAttribute("value"));
                self.getDomElement().removeChild(self.buttonContainer);
                this.fnOnValueChange && this.fnOnValueChange(this);
            }
        }, true);
        this.buttonContainer.addEventListener("blur", (e: any) => {
            var el = e.target;
            setTimeout(function (){
                self.getDomElement().removeChild(self.buttonContainer);
            },1)
        }, true);
    }

    setOnButtonClick(fn: Function): void {
        this.button.addEventListener("click", fn, true);
    }

    setValue(value: any): void {
        super.setValue(value);
        this.buttonText.setValue(value);
        /*  switch (value) {
              case "0":
                  case "1":
                  case "2":
                  case "3":
                  break;
              case "4":
                  this.setStyle("background",'url("./css/img/drop_down.png") center no-repeat')
                  break;
              case "5":
                  break;
              case "6":
                  break;

          }*/

    }

    getValue(): any {
        this.buttonText.getValue();
    }

    setShowText(text: string): void {
        this.buttonText.setValue(text);
    }

    getShowText(): string {
        return this.buttonText.getValue();
    }

    setText(text: string): void {
        this.buttonText.setValue(text);
    }

    setHeight(height: SizeInfo) {
        this.setStyle("height", height.toString());
        this.buttonText.setHeight(height);
        this.button.setHeight(height);
    }

    setWidth(width: SizeInfo) {
        var w = width.getValue();
        this.setStyle("width", width.toString());
        this.buttonText.setWidth(SizeInfo.valueOfPX(w - 24));
        this.button.setWidth(SizeInfo.valueOfPX(24));
    }

}

class ContainerItem extends AbstractDomElement {
    private background: string;

    constructor(background: string) {
        super();
        this.background = background;
        this.addClass('property-Container-item');
        this.setStyle('background', background);
        this.setStyle('width', '70px');
        this.setStyle('height', '20px');
        this.setStyle('margin', '2px');
        this.setStyle('cursor', 'pointer');
        this.setStyle('border-width', '1px');
    }

    public getContainer(): string {
        return this.background;
    }
}

class ButtonContainer extends AbstractDomElement {
    private buttonContainerItems: string[] ;
    constructor(buttonContainerItems: string[],width:string,height:string) {
        super();
        this.addClass("ButtonContainer");
        this.setStyle('position', 'absolute');
        this.setStyle('z-index', '66666666');
        this.setStyle('display', 'flex');
        this.setStyle('width', width);
        this.setStyle('height', height);
        this.setStyle('margin-top', '-6px');
        this.setStyle('flex-direction', 'row');
        this.setStyle('flex-wrap', 'wrap');
        this.setStyle('justify-content', 'center');
        this.setStyle('align-items', 'center');
        this.setStyle('background-color', 'rgb(191 191 191)');
        this.setAttr("tabindex","0")
        this.buttonContainerItems = buttonContainerItems;
        // 遍历数组，添加pick按钮至容器
        for (let i = 0; i < this.buttonContainerItems.length; i++) {
            var colorItem = new ContainerItem(this.buttonContainerItems[i]);
            colorItem.getEl().setAttribute("value",String(i));
            this.addChild(colorItem);
        }
    }

}