import Button from "../../../common/component/control/Button";
import SizeInfo from "../../../common/struct/SizeInfo";

export default class PrintButton extends Button {

    constructor(text: string = "",background:string,title:string,key:string) {
        super(text);
        this.setWidth(SizeInfo.valueOfPX(26))
        this.setHeight(SizeInfo.valueOfPX(27))
        this.setStyle(" background-size", '100%');
        this.setStyle("background", background);
        this.setStyle("border", "solid 1px #DDD");
        this.setStyle("border-radius", "3px");
        this.setStyle("margin-top","2px")
        this.setStyle("margin-left","4px");
        this.setKey(key)

        this.setTitle(title);

    }
    setValue(value: any) {
        super.setValue(value);
        if ("true"== value){
            this.setStyle("background-color","antiquewhite");
        }else {
            this.setStyle("background-color","");

        }
    }


}