import AbstractPrintOptState from "./AbstractPrintOptState";
import ITagNode from "../../../common/xml/node/ITagNode";
import BaseConstants from "../../base/BaseConstants";
import SectionView from "../view/element/SectionView";
import XmlEntity from "../../../common/xml/XmlEntity";

export default class RowReszieState extends AbstractPrintOptState {

    private start: number = -1;
    private tagNode?: ITagNode;
    private row?: ITagNode;
    private el: any;
    private startNode? :ITagNode;
    private endNode? :ITagNode;
    private startHeight? :number;
    private endHeight? :number;
    mousedown(e: MouseEvent): void {
        super.mousedown(e);
        var {x, y} = this.getPosition(e);
        var hitMultiTagNode = this.getView().hitMultiTagNode(x, y - 1);
        this.tagNode = hitMultiTagNode?.getTagNode();
        let row = <ITagNode> this.tagNode!.getParent();
        this.startHeight = row.getAttributeValueInt(BaseConstants.ATTR_Height,0);
        this.row = row;
        this.start = y;
    }

    mousemove(e: MouseEvent): void {
        let ele = <HTMLElement>e.target;
        if (e.button == 0 && e.buttons == 1) {
            var {x, y} = this.getPosition(e);
            let cell = this.tagNode!;
            let length: number = this.start - y;
            let number = Math.abs(length);
            let row = <ITagNode>cell.getParent();
            let hight = row.getAttributeValue(BaseConstants.ATTR_Height);
            let orgLength = Number(hight);
            if (length > 0) {//缩小
                if ((orgLength - number) > 10) {
                    let newLength = orgLength - number;
                    this.getView().initDragState(this.getView(),this.row!,newLength,0,false,true)

                    //  row.setAttributeValue(BaseConstants.ATTR_Height, newLength.toString());
                   // this.getView().getXmlEntity().update(row, true);
                    this.start = y
                    this.endHeight = newLength;
                }
            } else {//拉大
                let newLength = orgLength + number;
                this.getView().initDragState(this.getView(),this.row!,newLength,0,false,true)

                //  row.setAttributeValue(BaseConstants.ATTR_Height, newLength.toString());
               // this.getView().getXmlEntity().update(row, true);
                this.start = y
                this.endHeight = newLength;
            }

        } else if ("col-resize-ltr" == ele.className && e.buttons != 1) {
            this.getDelegate().setResizeState();
            // this.getDelegate().setNormalState();
        } else if (ele.className.indexOf("row-resize-ltr") < 0 && e.button == 0 && e.buttons != 1) {
            this.getDelegate().setNormalState();

        }
    }

    mouseup(e: MouseEvent): void {
        super.mouseup(e);
        this.getView().initDragState(this.getView(),this.row!,this.endHeight!,this.startHeight!,true,true)

    }


    getTagNode(): any {
        return this.tagNode;
    }

    seTagNode(value: any) {
        this.tagNode = value;
    }


    getEl(): any {
        return this.el;
    }

    setEl(value: any) {
        this.el = value;
    }

    getStart(): any {
        return this.start;
    }

    setStart(value: any) {
        this.start = value;
    }
}

