import AbstractOptStateDelegate from "../../../common/state/AbstractOptStateDelegate";
import PrintGraphicView from "../view/PrintGraphicView";
import NormalState from "./NormalState";
import SelectAreaState from "./SelectAreaState";
import ResizeState from "./ReszieState";
import RowReszieState from "./RowReszieState";
import InputState from "./InputState";

export default class PrintOptStateDelegate extends AbstractOptStateDelegate<PrintGraphicView> {

    private normalState: NormalState;
    private resizeState: ResizeState;
    private rowReszieState: RowReszieState;
    private inputState: InputState;
    constructor(view: PrintGraphicView) {
        super(view);
        this.normalState = new NormalState(this);
        this.resizeState = new ResizeState(this);
        this.rowReszieState = new RowReszieState(this);
        this.inputState = new InputState(this);
        this.setInitState(this.normalState);
    }

    setSelectAreaState(selectAreaState:SelectAreaState): void {
        this.setCurrentState(selectAreaState);
    }

    setResizeState():void{
        this.setCurrentState(this.resizeState)
    }
    setRowReszieState():void{
        this.setCurrentState(this.rowReszieState)
    }
    setNormalState(): void {
        this.setCurrentState(this.normalState);
    }
    setInputState(): void {
        this.setCurrentState(this.inputState);
    }
}