import ICmd from "../../../common/cmd/ICmd";
import ActionNames from "../../../common/event/ActionNames";
import ITagNode from "../../../common/xml/node/ITagNode";
import PrintGraphicView from "../view/PrintGraphicView";
import PrintActionUtil from "../util/PrintActionUtil";
import AbstractNode from "../../bpm/view/element/node/AbstractNode";
import PrintConstants from "../base/PrintConstants";
import PrintNodeUtil from "../util/PrintNodeUtil";
import Var from "../../../common/struct/Var";
import XmlEntity from "../../../common/xml/XmlEntity";

export default class NewRowElementCmd implements ICmd {

    private tagNodes: ITagNode;


    private view: PrintGraphicView;

    private   cmd : String ;

    private tagNode?: ITagNode;
    private orgTagNode?: ITagNode;

    constructor(view: PrintGraphicView, tagNodes: ITagNode[],cmd :String) {
        this.view = view;
        this.cmd = cmd;
        if ( PrintConstants.NODE_AddRow_Before == this.cmd){
            this.tagNodes = tagNodes[0];
        }else {
            this.tagNodes = tagNodes[tagNodes.length-1];
        }
    }

    do(): boolean {
        var xmlEntity = this.view.getXmlEntity();
            let tagNode = this.tagNodes
            let rowNode = tagNode!.getParent()!
            let rowsNode = tagNode!.getParent()!.getParent()!;
            if(!rowsNode) return false;
            let section = <ITagNode>rowsNode.getParent();
            this.orgTagNode =  XmlEntity.parseTagNode(section.toXml(true))
            let rows = rowsNode!.getChildren();
            let index : number = rows.indexOf(rowNode);
            let cells = rowNode.getChildren();
            var newNode = PrintNodeUtil.createRowNode(xmlEntity, PrintConstants.NODE_Paragraph,cells.length);
            let children = newNode!.getChildren();
            for (let i:number =0;i<cells.length;i++){
                let cell = <ITagNode>cells[i];
                if ("true" == cell.getAttributeValue(PrintConstants.ATTR_IsMerged)){
                    if ("true" == cell.getAttributeValue(PrintConstants.ATTR_IsMergedHead) && PrintConstants.NODE_AddRow_After == this.cmd){
                        let rowSpan: number = Number(cell.getAttributeValue(PrintConstants.ATTR_MergedRowSpan));
                        if (rowSpan>1){
                            let columnSpan: number = Number(cell.getAttributeValue(PrintConstants.ATTR_MergedColumnSpan));
                            for (let j:number = i;j<i+columnSpan-1;j++){
                                let iNode = <ITagNode>children[j];
                                iNode.setAttributeValue(PrintConstants.ATTR_IsMerged,"true");
                                iNode.setAttributeValue(PrintConstants.ATTR_MergedRowSpan,"1");
                            }
                            cell.setAttributeValue(PrintConstants.ATTR_MergedRowSpan,(rowSpan+1).toString())
                            i = i+columnSpan;
                        }
                    }else {
                        let mergeIndex = rows?.indexOf(rowNode);
                        if (mergeIndex){
                            for (let j: number = mergeIndex - 1; j >= 0; j--) {
                                let currRow = rows?.[j] as ITagNode;
                                let cells = currRow.getChildren();
                                let cell1 = <ITagNode>cells[i];
                                if ("true" == cell1.getAttributeValue(PrintConstants.ATTR_IsMergedHead)) {
                                    let rowSpan: number = Number(cell1.getAttributeValue(PrintConstants.ATTR_MergedRowSpan));
                                    if (rowSpan>1 && (j+rowSpan-1  != mergeIndex &&  PrintConstants.NODE_AddRow_After != this.cmd)){
                                        let columnSpan: number = Number(cell1.getAttributeValue(PrintConstants.ATTR_MergedColumnSpan));
                                        for (let j:number = i;j<i+columnSpan-1;j++){
                                            let iNode = <ITagNode>children[j];
                                            iNode.setAttributeValue(PrintConstants.ATTR_IsMerged,"true");
                                            iNode.setAttributeValue(PrintConstants.ATTR_MergedRowSpan,"1");
                                        }
                                        cell1.setAttributeValue(PrintConstants.ATTR_MergedRowSpan,(rowSpan+1).toString())
                                        i = i + columnSpan;
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            newNode.setParent(<ITagNode>rowsNode);
            if (PrintConstants.NODE_AddRow_Before == this.cmd) {
                rows.splice(index,0,newNode);
            } else if (PrintConstants.NODE_AddRow_After == this.cmd){
                rows.splice(index+1,0,newNode);
            }
           rowsNode =  PrintNodeUtil.reloadSpan(rowsNode);
            let gridNode = tagNode!.getParent()!.getParent()!.getParent()!.getParent();
            this.tagNode = section;
              xmlEntity?.update(rowsNode,true);
            xmlEntity?.update(gridNode,true);
            xmlEntity.getTagRoot().resetLineIndex(new Var(0));//源代码的定位需要startLinde和endLine所以需要去对新加的Sectionc重新reload进行计算

        return true;
    }





    undo(): void {
        var xmlEntity = this.view.getXmlEntity();
        let children = this.orgTagNode?.getChildren();
        this.tagNode?.clearChildren();
            for (let childrenKey of children!) {
                this.tagNode?.addChild(childrenKey)
            }
        xmlEntity?.update(<ITagNode>this.tagNode,true);
        xmlEntity.getTagRoot().resetLineIndex(new Var(0));//源代码的定位需要startLinde和endLine所以需要去对新加的Sectionc重新reload进行计算

    }

}