import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import PrintGraphicView from "../view/PrintGraphicView";
import PrintConstants from "../base/PrintConstants";
import PrintNodeUtil from "../util/PrintNodeUtil";
import Var from "../../../common/struct/Var";
import XmlEntity from "../../../common/xml/XmlEntity";
export default class NewColumnElementCmd implements ICmd {

    private tagNodes: ITagNode;

    private nodes?: ITagNode[];
    private view: PrintGraphicView;

    private   cmd : String ;

    private tagNode?: ITagNode;
    private orgTagNode?: ITagNode;

    constructor(view: PrintGraphicView, tagNodes: ITagNode[],cmd :String) {
        this.view = view;
        this.nodes = tagNodes;
        this.cmd = cmd;
        if ( PrintConstants.NODE_AddColumn_Before == this.cmd){
            this.tagNodes = tagNodes[0];
        }else {
            this.tagNodes = tagNodes[tagNodes.length-1];
        }

    }

    do(): boolean {
        var xmlEntity = this.view.getXmlEntity();
            let tagNode = this.tagNodes
            let rowNode = tagNode!.getParent()!
            let rowsNode = tagNode!.getParent()!.getParent()!;
            if(!rowsNode) return false;
            let rows = rowsNode.getChildren();
            let cells = rowNode.getChildren();
            let index = cells.indexOf(tagNode);//获得对应下标
            let stactionNode = rowsNode!.getParent();
            this.orgTagNode =  XmlEntity.parseTagNode(stactionNode!.toXml(true));

            let columnsNode = <ITagNode>stactionNode!.getChildren()[0];//columns
            let children = columnsNode!.getChildren();
            var columnNode = xmlEntity.getNodeFactory().createTagNode(PrintConstants.NODE_Column);
            columnNode.setAttributeValue(PrintConstants.ATTR_Width,"80");
            columnNode.setParent(columnsNode);
            if (PrintConstants.NODE_AddColumn_Before == this.cmd) {
                children.splice(index,0,columnNode);
            } else if (PrintConstants.NODE_AddColumn_After == this.cmd){
                children.splice(index+1,0,columnNode);
            }
            let addSize :number = 0;
            for (let i :number = 0;i<rows.length ;i++) {
                let rowNode = <ITagNode>rows[i];
                var cellNode = xmlEntity.getNodeFactory().createTagNode(PrintConstants.NODE_Cell);
                let currcells = rowNode!.getChildren();
                let cell = <ITagNode>currcells[index];
                if (addSize>0){
                    cellNode.setAttributeValue(PrintConstants.ATTR_IsMerged,"true");
                    cellNode.setAttributeValue(PrintConstants.ATTR_MergedRowSpan,"1");
                    cellNode.setParent(rowNode);
                    addSize--;
                    if (PrintConstants.NODE_AddColumn_Before == this.cmd) {
                        currcells.splice(index,0,cellNode);
                    } else if (PrintConstants.NODE_AddColumn_After == this.cmd){
                        currcells.splice(index+1,0,cellNode);
                    }
                    continue;
                }
                if ("true" == cell.getAttributeValue(PrintConstants.ATTR_IsMerged)){
                    if ("true" == cell.getAttributeValue(PrintConstants.ATTR_IsMergedHead) && PrintConstants.NODE_AddColumn_After == this.cmd){
                        let columnSpan: number = Number(cell.getAttributeValue(PrintConstants.ATTR_MergedColumnSpan));
                        addSize = Number(cell.getAttributeValue(PrintConstants.ATTR_MergedRowSpan))-1;
                        if (columnSpan>1){
                            cell.setAttributeValue(PrintConstants.ATTR_MergedColumnSpan,(columnSpan+1).toString())
                            cellNode.setAttributeValue(PrintConstants.ATTR_IsMerged,"true");
                            cellNode.setAttributeValue(PrintConstants.ATTR_MergedRowSpan,"1");
                            cellNode.setAttributeValue(PrintConstants.ATTR_MergedColumnSpan,"1");
                            cellNode.setParent(rowNode);
                        }
                    }else {
                        for (let j:number =i;j>=0;j--){
                            let rowb =  <ITagNode>rows![j];
                            let cells = rowb.getChildren();
                            for(let a : number=index;a>=0;a--){
                                let cell = <ITagNode>cells[a];
                                if ("true" == cell.getAttributeValue(PrintConstants.ATTR_IsMergedHead)){
                                    let columnSpan: number = Number(cell.getAttributeValue(PrintConstants.ATTR_MergedColumnSpan));
                                    addSize = Number(cell.getAttributeValue(PrintConstants.ATTR_MergedRowSpan))-1;
                                    cell.setAttributeValue(PrintConstants.ATTR_MergedColumnSpan,(columnSpan+1).toString());
                                    cellNode.setAttributeValue(PrintConstants.ATTR_IsMerged,"true");
                                    cellNode.setAttributeValue(PrintConstants.ATTR_MergedRowSpan,"1");
                                    cellNode.setAttributeValue(PrintConstants.ATTR_MergedColumnSpan,"1");
                                    cellNode.setParent(rowNode);
                                    break;
                                }
                            }
                            if (addSize>0){
                                break;
                            }
                        }
                    }
                }
                    cellNode.setParent(rowNode);
                    if (PrintConstants.NODE_AddColumn_Before == this.cmd) {
                        currcells.splice(index,0,cellNode);
                    } else if (PrintConstants.NODE_AddColumn_After == this.cmd){
                        currcells.splice(index+1,0,cellNode);
                    }
            }
             rowsNode = PrintNodeUtil.reloadSpan(rowsNode);
            let gridNode = tagNode!.getParent()!.getParent()!.getParent()!.getParent();
            this.tagNode = stactionNode;
            xmlEntity?.update(rowsNode,true)
            xmlEntity?.update(gridNode,true)
            xmlEntity.getTagRoot().resetLineIndex(new Var(0));//源代码的定位需要startLinde和endLine所以需要去对新加的Sectionc重新reload进行计算
        return true;
    }





    undo(): void {
        var xmlEntity = this.view.getXmlEntity();
        let children = this.orgTagNode?.getChildren();
        this.tagNode?.clearChildren();
        for (let childrenKey of children!) {
            this.tagNode?.addChild(childrenKey)
        }
        xmlEntity?.update(<ITagNode>this.tagNode,true);
        xmlEntity.getTagRoot().resetLineIndex(new Var(0));//源代码的定位需要startLinde和endLine所以需要去对新加的Sectionc重新reload进行计算
    }

}