import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import BaseConstants from "../../base/BaseConstants";
import XmlEntity from "../../../common/xml/XmlEntity";
import PrintWorkSpace from "../PrintWorkSpace";
import SectionView from "../view/element/SectionView";
import PrintNodeUtil from "../util/PrintNodeUtil";

export default class MergeCellCmd implements ICmd {
    private iTagNodes: ITagNode[];
    private oldITagNodes?: ITagNode[];
    private newITagNodes?: ITagNode[];
    private xmlEntity: IXmlEntity;
    private printWorkSpace: PrintWorkSpace;
    private sectionView: SectionView | null | undefined;

    constructor(xmlEntity: IXmlEntity, tagNode: ITagNode[], printWorkSpace: PrintWorkSpace) {
        this.xmlEntity = xmlEntity;
        this.iTagNodes = tagNode;
        this.printWorkSpace = printWorkSpace;

    }

    do(): boolean {
        if (this.iTagNodes.length <= 0) {
            return false;
        }
        var iTagNode = this.iTagNodes[0];
        var tagNode1 = iTagNode.getParent()!.getParent()!.getParent()!.getTagNode();
        this.sectionView = <SectionView>this.printWorkSpace.getGraphicView().findChildNode(tagNode1);
        this.oldITagNodes = this.oldITagNodes || []
        this.newITagNodes = this.newITagNodes || []
        var firstNode = this.iTagNodes[0];
        var firstView = PrintNodeUtil.getCellViewByTagNode(this.sectionView, firstNode);
        //最大
        var maxX = 0;
        var minX = firstView!.getRowIndex();
        var maxY = 0;
        var minY = firstView!.getColIndex();
        for (let i = 0; i < this.iTagNodes.length; i++) {
            var tagNode: ITagNode | null = this.iTagNodes[i];
            var viewByTagNode = PrintNodeUtil.getCellViewByTagNode(this.sectionView, tagNode);
            if (viewByTagNode) {
                var colIndex = viewByTagNode.getColIndex();
                var rowIndex = viewByTagNode.getRowIndex();
                maxX = Math.max(maxX, rowIndex);
                maxY = Math.max(maxY, colIndex);
                minX = Math.min(minX, rowIndex);
                minY = Math.min(minY, colIndex);
            }
        }
        for (let i = minY; i <= maxY; i++) {
            for (let j = minX; j <= maxX; j++) {
                var locCell = this.sectionView.locCell(j, i);
                if (!locCell) {
                    continue;
                }
                var node = locCell.getTagNode();
                this.oldITagNodes.push(XmlEntity.parseTagNode(node.toXml(true)));
                node.removeAttribute(BaseConstants.ATTR_ISMERGED);
                node.removeAttribute(BaseConstants.ATTR_Merged_Head);
                node.removeAttribute(BaseConstants.ATTR_RowSpan);
                node.removeAttribute(BaseConstants.ATTR_ColSpan);
                node.setAttributeValue(BaseConstants.ATTR_ISMERGED, "true")
                if (i == minY && j == minX) {
                    node.setAttributeValue(BaseConstants.ATTR_Merged_Head, "true")
                    node.setAttributeValue(BaseConstants.ATTR_RowSpan, String(maxX - minX + 1),"0")
                    node.setAttributeValue(BaseConstants.ATTR_ColSpan, String(maxY - minY + 1),"0")
                } else {
                    var colIndex1 = locCell.getColIndex();
                    var rowIndex1 = locCell.getRowIndex();
                    if (rowIndex1-minX>0){
                        node.setAttributeValue(BaseConstants.ATTR_RowSpan, String(rowIndex1 - minX),"0")
                    }
                    node.setAttributeValue(BaseConstants.ATTR_ColSpan, String(colIndex1 - minY),"0")
                }
                this.newITagNodes.push(node);
            }
        }

        var selectionModel = this.xmlEntity.getSelectionModel();
        selectionModel.setBMultiSelection(true);
        this.xmlEntity.getSelectionModel().unMultiSelection();
        selectionModel.setBMultiSelection(false);
        selectionModel.select(this.iTagNodes[0]);
        selectionModel.setBMultiSelection(true);
        if (this.oldITagNodes) {
            for (let i = 1; i < this.iTagNodes.length; i++) {
                selectionModel.select(this.iTagNodes[i]);
            }
        }
        selectionModel.setBMultiSelection(false);
        return true;
    }

    undo(): void {
        if (this.iTagNodes.length <= 0) {
            return;
        }
        if (this.oldITagNodes && this.oldITagNodes!.length > 0) {
            for (let i = 0; i < this!.newITagNodes!.length; i++) {

                var attributes = this!.newITagNodes![i]!.getAttributes();
                attributes.length = 0;
                for (let j = 0; j < this.oldITagNodes[i].getAttributes().length; j++) {
                    attributes.push(this.oldITagNodes[i].getAttributes()[j]);
                }
            }
            var selectionModel = this.xmlEntity.getSelectionModel();
            selectionModel.setBMultiSelection(true);
            this.xmlEntity.getSelectionModel().unMultiSelection();
            selectionModel.setBMultiSelection(false);
            selectionModel.select(this.iTagNodes[0]);
            selectionModel.setBMultiSelection(true);
            for (let i = 1; i < this.iTagNodes.length; i++) {
                selectionModel.select(this.iTagNodes[i]);
            }
            selectionModel.setBMultiSelection(false);
        }
    }
}