import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import PrintGraphicView from "../view/PrintGraphicView";
import BaseConstants from "../../base/BaseConstants";

export default class DragStateCmd implements ICmd {

    private tagNode?: ITagNode;
    private newCount?: number;
    private oldCount?: number;
    private isHeight?: boolean;
    private printGraphicView: PrintGraphicView;
    private  flag?:boolean;


    constructor(printGraphicView: PrintGraphicView, tagNode: ITagNode,newCount :number,oldCount :number,flag:boolean,isHeight:boolean) {
        this.printGraphicView = printGraphicView;
        this.tagNode = tagNode;
        this.newCount = newCount;
        this.oldCount = oldCount;
        this.flag = flag;
        this.isHeight = isHeight;
    }

    do(): boolean {
        if (!this.flag){
            if (this.isHeight){
                this.tagNode?.setAttributeValue(BaseConstants.ATTR_Height,this.newCount!.toString());
            }else {
                this.tagNode?.setAttributeValue(BaseConstants.ATTR_Width,this.newCount!.toString());
            }
            this.printGraphicView.getXmlEntity().getSelectionModel().select(this.tagNode);
        }
        return true;
    }

    undo(): void {
        if (this.tagNode ) {
            if (this.isHeight){
                this.tagNode?.setAttributeValue(BaseConstants.ATTR_Height,this.oldCount!.toString());
            }else {
                this.tagNode?.setAttributeValue(BaseConstants.ATTR_Width,this.oldCount!.toString());
            }
            this.printGraphicView.getXmlEntity().update(this.tagNode, true);
            this.flag = false;
        }
    }
}