import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import BaseConstants from "../../base/BaseConstants";
import XmlEntity from "../../../common/xml/XmlEntity";
import TagNode from "../../../common/xml/node/TagNode";

export default class DivisionCellCmd implements ICmd {
    private iTagNodes: ITagNode[];
    private oldITagNodes?: ITagNode[];
    private newITagNodes?: ITagNode[];
    private xmlEntity: IXmlEntity;

    constructor(xmlEntity: IXmlEntity, tagNode: ITagNode[]) {
        this.xmlEntity = xmlEntity;
        this.iTagNodes = tagNode;
    }

    do(): boolean {
        if (this.iTagNodes.length <= 0) {
            return false;
        }
        var selectionModel = this.xmlEntity.getSelectionModel();

        this.getMergedCells();

        for (let i = 0; i < this.iTagNodes.length; i++) {
            var tagNode: ITagNode | null = this.iTagNodes[i];
            if (!tagNode.getAttributeValueBoolean(BaseConstants.ATTR_ISMERGED, false)) {
                continue;
            }
            this.oldITagNodes = this.oldITagNodes || []
            this.newITagNodes = this.newITagNodes || []
            this.oldITagNodes.push(XmlEntity.parseTagNode(tagNode.toXml(true)));
            tagNode.removeAttribute(BaseConstants.ATTR_ISMERGED);
            tagNode.removeAttribute(BaseConstants.ATTR_Merged_Head);
            tagNode.removeAttribute(BaseConstants.ATTR_RowSpan);
            tagNode.removeAttribute(BaseConstants.ATTR_ColSpan);
            this.newITagNodes.push(tagNode);
        }
        if (this.oldITagNodes) {
            selectionModel.setBMultiSelection(true);
            this.xmlEntity.getSelectionModel().unMultiSelection();
            selectionModel.setBMultiSelection(false);
            selectionModel.select(this.iTagNodes[0]);
            selectionModel.setBMultiSelection(true);
            for (let i = 1; i < this.iTagNodes.length; i++) {
                selectionModel.select(this.iTagNodes[i]);
            }
            selectionModel.setBMultiSelection(false);
        }
        return true;
    }

    undo(): void {
        if (this.iTagNodes.length <= 0) {
            return;
        }
        if (this.oldITagNodes && this.oldITagNodes!.length > 0) {
            for (let i = 0; i < this!.newITagNodes!.length; i++) {

                var attributes = this!.newITagNodes![i]!.getAttributes();
                attributes.length = 0;
                for (let j = 0; j < this.oldITagNodes[i].getAttributes().length; j++) {
                    attributes.push(this.oldITagNodes[i].getAttributes()[j]);
                }
            }
            var selectionModel = this.xmlEntity.getSelectionModel();
            selectionModel.setBMultiSelection(true);
            this.xmlEntity.getSelectionModel().unMultiSelection();
            selectionModel.setBMultiSelection(false);
            selectionModel.select(this.iTagNodes[0]);
            selectionModel.setBMultiSelection(true);
            for (let i = 1; i < this.iTagNodes.length; i++) {
                selectionModel.select(this.iTagNodes[i]);
            }
            selectionModel.setBMultiSelection(false);
        }
    }

    // 获取所有被合并的单元格
    getMergedCells(){
        if ( this.iTagNodes.length == 1 ) {
            let iTagNode = this.iTagNodes[0];
            let rowSpan = iTagNode.getAttributeValueInt(BaseConstants.ATTR_RowSpan, 1);
            let colSpan = iTagNode.getAttributeValueInt(BaseConstants.ATTR_ColSpan, 1);
            // 通过被合并的行和列属性找范围内的所有单元格
            let rowNode = iTagNode.getParent()!;
            let rowNodes = rowNode.getParent()!.getChildren();
            let column = rowNode!.getChildren().indexOf(iTagNode);
            let row = rowNodes.indexOf(rowNode);
            let mergedCells = [];
            for (let i = row; i < row + rowSpan; i++) {
                for (let j = column; j < column + colSpan; j++) {
                    let cell = (<TagNode>rowNodes[i]).getChildren()[j];
                    mergedCells.push(<TagNode>cell);
                }
            }
            this.iTagNodes = mergedCells;
        }
    }
}