import ICmd from "../../../common/cmd/ICmd";
import ActionNames from "../../../common/event/ActionNames";
import ITagNode from "../../../common/xml/node/ITagNode";
import PrintGraphicView from "../view/PrintGraphicView";
import PrintActionUtil from "../util/PrintActionUtil";
import AbstractNode from "../../bpm/view/element/node/AbstractNode";
import PrintConstants from "../base/PrintConstants";
import INode from "../../../common/xml/node/INode";
import Var from "../../../common/struct/Var";
import XmlEntity from "../../../common/xml/XmlEntity";
import PrintNodeUtil from "../util/PrintNodeUtil";

export default class DeleteElementCmd implements ICmd {

    private tagNodes: ITagNode[];

    private delNodes: ITagNode[];
    private updateNodes: ITagNode[];
    private view: PrintGraphicView;
    private roladRows?:ITagNode;
    private tagNode?: ITagNode;
    private orgTagNode?: ITagNode;
    private sectionNode?: ITagNode;
    private   cmd : String ;

    constructor(view: PrintGraphicView, tagNodes: ITagNode[],cmd :String) {
        this.view = view;
        this.tagNodes = tagNodes;
        this.cmd = cmd;
        this.delNodes = [];
        this.updateNodes = [];
    }

    do(): boolean {
        var xmlEntity = this.view.getXmlEntity();
        if (this.tagNodes.length==0){
            return true;
        }
      //  for (let tagNode of this.tagNodes ) {
         let tagNode = <ITagNode>this.tagNodes[0];
           // var viewNode = this.view.findChildNode(tagNode)
           switch (this.cmd) {
               case PrintConstants.NODE_Paragraph_Delete:  //段删除，删除整个Section
                   while (tagNode.getTagName()!=PrintConstants.NODE_Section){
                          let result = tagNode.getParent();
                           tagNode = (result as ITagNode).getTagNode();
                   }
                   let sections = tagNode.getParent()!.getChildren();
                   if (sections!.length>1){
                       this.delNodes.push(tagNode);
                   }
                   this.sectionNode =  XmlEntity.parseTagNode(tagNode.getParent()!.toXml(true));
                   this.tagNode = tagNode.getParent();
                   break;
               case PrintConstants.NODE_Row_Delete: //行删除，删除父级Row ,如果Rows下只存在一行则删除整个Section节点
                   while (tagNode.getTagName()!="Row"){
                       let result = tagNode.getParent();
                       if(!result) return false;
                       tagNode = (result as ITagNode).getTagNode();
                   }
                   let parent = <ITagNode>tagNode.getParent();//rows节点
                   let section = parent?.getParent();
                   this.orgTagNode =  XmlEntity.parseTagNode(section!.toXml(true))
                   let children = parent?.getChildren();
                   if (children?.length == 1){
                       tagNode = parent?.getParent() as ITagNode;
                       this.sectionNode =  XmlEntity.parseTagNode(section!.getParent()!.toXml(true));
                       this.tagNode = section!.getParent();
                   }else {
                       let cells = tagNode.getChildren();
                       for (let i: number =0 ; i < cells.length; i++) {
                           let cell = <ITagNode>cells[i];
                           if ("true" == cell.getAttributeValue(PrintConstants.ATTR_IsMerged)) {  //删除行中有合并单元格配置时取检查并修改相应Span属性
                               if ("true" == cell.getAttributeValue(PrintConstants.ATTR_IsMergedHead)) { //自己为拓展头，删除对应行的IsMerge属性
                                   let columnSpan: number = Number(cell.getAttributeValue(PrintConstants.ATTR_MergedColumnSpan));
                                   let rowSpan: number = Number(cell.getAttributeValue(PrintConstants.ATTR_MergedRowSpan));
                                   let mergeIndex = children?.indexOf(tagNode);
                                   //删除rowSpan下的IsMerge属性
                                   if (mergeIndex!=-1 &&rowSpan>0 && columnSpan>0){
                                       for (let j: number = mergeIndex + 1; j < mergeIndex + rowSpan; j++) {
                                           let currRow = children?.[j] as ITagNode ;
                                           let rows = currRow.getChildren();
                                           for (let a: number = i; a < i + columnSpan; a++) {
                                               //取消合并行的属性
                                               let row = <ITagNode>rows[a];
                                               row.removeAttribute(PrintConstants.ATTR_IsMerged)
                                           }
                                       }
                                       i = i + columnSpan-1;
                                   }
                               }
                           else {  //自己为被拓展单元格，需要将绑定的单元格的MergedRowSpan减一
                                   let mergeIndex = children?.indexOf(tagNode);
                                   if (mergeIndex){
                                       for (let j: number = mergeIndex - 1; j >= 0; j--) {
                                           let currRow = children?.[j] as ITagNode;
                                           let rows = currRow.getChildren();
                                           let row = <ITagNode>rows[i];
                                           if ("true" == row.getAttributeValue(PrintConstants.ATTR_IsMergedHead)) {
                                               let rowSpan: number = Number(row.getAttributeValue(PrintConstants.ATTR_MergedRowSpan));
                                               let columnSpan: number = Number(row.getAttributeValue(PrintConstants.ATTR_MergedColumnSpan));
                                               row.setAttributeValue(PrintConstants.ATTR_MergedRowSpan, (rowSpan - 1).toString())
                                               i = i + columnSpan;
                                               break;
                                           }
                                       }
                                   }
                               }
                           }
                       }
                       this.roladRows = parent ;
                       this.tagNode = section;
                       this.updateNodes.push(parent?.getParent() as ITagNode)//直接更新selection
                   }
                   this.delNodes.push(tagNode);

                   break;
               case PrintConstants.NODE_Column_Delete://列删除,根据选中单元格的index删除Column对应
                   let cellNode = tagNode;
                   while (tagNode.getTagName()!="Row"){
                       let result = tagNode.getParent();
                       if(!result) return false;
                       tagNode = (result as ITagNode).getTagNode();
                   }
                    let children1 = tagNode.getChildren();
                    let index = children1.indexOf(cellNode);//获得对应下标
                   //删除对应Column列

                   let stactionNode = tagNode.getParent()?.getParent();
                   this.orgTagNode =  XmlEntity.parseTagNode(stactionNode!.toXml(true))
                   let child = <ITagNode>(stactionNode as ITagNode).getChildren()[0];
                   if (child?.getChildren().length==1){
                       this.delNodes.push(<ITagNode>stactionNode)//最后一列直接删除整个section节点
                       this.sectionNode =  XmlEntity.parseTagNode(stactionNode!.getParent()!.toXml(true));
                       this.tagNode = stactionNode!.getParent();
                   }else {
                       //删除行对应单元格
                       let rowsNode =  tagNode.getParent()?.getChildren();
                       let addSize: number=0;
                       if (rowsNode &&rowsNode?.length>=0){
                           for(let i:number = 0;i<rowsNode!.length;i++){
                               let rowa =   <ITagNode> rowsNode![i];
                               let iNode = <ITagNode>rowa.getChildren()[index];
                               if (addSize>0){
                                   i = i+addSize-2;
                                   this.delNodes.push(iNode);
                                   addSize = 0;
                                   continue;
                               }
                               if ("true" == iNode.getAttributeValue(PrintConstants.ATTR_IsMerged)) {  //删除列中有合并单元格配置时取检查并修改相应Span属性
                                   if ("true" == iNode.getAttributeValue(PrintConstants.ATTR_IsMergedHead)) { //自己为拓展头，删除对应行的IsMerge属性
                                       let columnSpan: number = Number(iNode.getAttributeValue(PrintConstants.ATTR_MergedColumnSpan));
                                       let rowSpan: number = Number(iNode.getAttributeValue(PrintConstants.ATTR_MergedRowSpan));
                                      let nextNode =  <ITagNode>rowa.getChildren()[index+1];
                                      //判断下个单元格是否是被删除的这列的合并格
                                      if (columnSpan > 1 && nextNode){
                                          if (columnSpan>2 || rowSpan > 1){
                                              nextNode.setAttributeValue(PrintConstants.ATTR_IsMergedHead,"true");
                                              nextNode.setAttributeValue(PrintConstants.ATTR_MergedColumnSpan,(columnSpan-1).toString());
                                              nextNode.setAttributeValue(PrintConstants.ATTR_MergedRowSpan,rowSpan.toString());
                                          }else {
                                              nextNode.removeAttribute(PrintConstants.ATTR_IsMerged)
                                              nextNode.removeAttribute(PrintConstants.ATTR_IsMergedHead)
                                              nextNode.removeAttribute(PrintConstants.ATTR_MergedColumnSpan);
                                              nextNode.removeAttribute(PrintConstants.ATTR_MergedRowSpan);
                                          }
                                      }
                                   }else {
                                         for (let j:number =i;j>=0;j--){
                                             let rowb =  <ITagNode>rowsNode![j];
                                             let cells = rowb.getChildren();
                                             for(let a : number=index;a>=0;a--){
                                                 let cell = <ITagNode>cells[a];
                                                 if ("true" == cell.getAttributeValue(PrintConstants.ATTR_IsMergedHead)){
                                                     let columnSpan: number = Number(cell.getAttributeValue(PrintConstants.ATTR_MergedColumnSpan));
                                                     addSize = Number(cell.getAttributeValue(PrintConstants.ATTR_MergedRowSpan));
                                                     if (columnSpan>2 || addSize >1){
                                                         cell.setAttributeValue(PrintConstants.ATTR_MergedColumnSpan,(columnSpan-1).toString());
                                                     }else {
                                                         cell.removeAttribute(PrintConstants.ATTR_IsMerged)
                                                         cell.removeAttribute(PrintConstants.ATTR_IsMergedHead)
                                                         cell.removeAttribute(PrintConstants.ATTR_MergedColumnSpan);
                                                         cell.removeAttribute(PrintConstants.ATTR_MergedRowSpan);
                                                     }

                                                     break;
                                                 }
                                             }
                                             if (addSize>0){
                                                 break;
                                             }
                                         }
                                   }
                               }
                                   this.delNodes.push(iNode);
                               }

                       }
                       let rows =  <ITagNode>tagNode.getParent() ;
                       this.roladRows = rows ;
                       this.updateNodes.push(<ITagNode>stactionNode)//直接更新selection
                       this.updateNodes.push(rows)//直接更新selection
                       //删除列
                       this.delNodes.push(<ITagNode> child.getChildren()[index]);
                       this.tagNode = stactionNode;
                   }

                   break;
           }

        for (let node of this.delNodes) {
            xmlEntity?.removeNode(node);
        }
        for (let node of this.updateNodes) {
            xmlEntity?.update(node,true);
        }
        if (this.roladRows){
            let reload = <ITagNode>PrintNodeUtil.reloadSpan(this.roladRows);
            xmlEntity?.update(reload,true);
        }
        xmlEntity.getTagRoot().resetLineIndex(new Var(0));//源代码的定位需要startLinde和endLine所以需要去对新加的Sectionc重新reload进行计算
        xmlEntity.getSelectionModel().select(xmlEntity.getTagRoot())
        return true;
    }
    undo(): void {
        var xmlEntity = this.view.getXmlEntity();
        if (this.sectionNode){
            let children = this.sectionNode?.getChildren();
            this.tagNode?.clearChildren();
            for (let childrenKey of children!) {
                this.tagNode?.addChild(childrenKey)
            }
            xmlEntity?.update(<ITagNode>this.tagNode,true);
        }else {
            let children = this.orgTagNode?.getChildren();
            this.tagNode?.clearChildren();
            for (let childrenKey of children!) {
                this.tagNode?.addChild(childrenKey)
            }
            xmlEntity?.update(<ITagNode>this.tagNode,true);
        }
        xmlEntity.getTagRoot().resetLineIndex(new Var(0));//源代码的定位需要startLinde和endLine所以需要去对新加的Sectionc重新reload进行计算
    }

}