import EXCEL from "../../excel/base/EXCEL";

export default class PRINT {
    public static D_COLUMN_WIDTH = 100;
    public static PREFIX = EXCEL.PREFIX

    public static D_ROW_HEIGHT = 30;

    public static D_FONT_NAME = "SimSun";

    public static D_FONT_SIZE = 12;

    public static PROPERTIES_XML: string =
        `<PRINT>
<DefineCollection>
    <Define Key="Report" Caption="打印模板" Extends="">
        <PropertyCollection>
            <Property Key="Key" Caption="标志" Control="TextEditor" Editable = "false"/>
            <Property Key="Caption" Caption="名称" Control="TextEditor"/>
            <Property Key="FormKey" Caption="绑定表单" Control="ButtonEditor" OnButtonClick="Macro_ShowWorkflowBindDialog()" Editable = "false"/>
            <Property Key="Group" Caption="报表组" Control="TextEditor"/>
            <Property Key="Default" Caption="表单默认模板" Control="Combobox" OnInitialize="true,是;false,否" DefaultValue="true"/>

            <Property Key="PageOrientation" Caption="页方向" Control="Combobox" OnInitialize="Portrait,纵向;Landscape,横向" DefaultValue="Portrait" Group="页面设置"/>
            <Property Key="PageWidth" Caption="页宽度" Control="NumberEditor" Group="页面设置"/>
            <Property Key="PageHeight" Caption="页高度" Control="NumberEditor" Group="页面设置"/>
            <Property Key="LeftMargin" Caption="左边距" Control="NumberEditor" DefaultValue="0" Group="页面设置"/>
            <Property Key="RightMargin" Caption="右边距" Control="NumberEditor" DefaultValue="0" Group="页面设置"/>
            <Property Key="TopMargin" Caption="上边距" Control="NumberEditor"  DefaultValue="0" Group="页面设置"/>
            <Property Key="BottomMargin" Caption="下边距" Control="NumberEditor" DefaultValue="0" Group="页面设置"/>
            <Property Key="VirtualPage" Caption="虚页打印" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false" Group="页面设置"/>
        
            <Property Key="PaperOrientation" Caption="纸张方向" Control="Combobox" OnInitialize="Portrait,纵向;Landscape,横向" DefaultValue="Portrait" Group="纸张设置"/>
            <Property Key="PaperWidth" Caption="纸张宽度" Control="NumberEditor" Group="纸张设置"/>
            <Property Key="PaperHeight" Caption="纸张高度" Control="NumberEditor" Group="纸张设置"/>
        </PropertyCollection>
    </Define>
    <Define Key="Table" Caption="数据表" Extends="">
        <PropertyCollection>
            <Property Key="Key" Caption="标志" Control="TextEditor"/>
            <Property Key="Caption" Caption="名称" Control="TextEditor"/>
            <Property Key="ParentKey" Caption="父表格" Control="TextEditor"/>
        </PropertyCollection>
    </Define>
    <Define Key="Section" Caption="表区域" Extends="">
        <PropertyCollection>
            <Property Key="Type" Caption="类型" Control="Combobox" OnInitialize="PageHead,页眉;Paragraph,段落;Table,表格;PageTail,页尾" DefaultValue="Paragraph"/>
            <Property Key="SplitRow" Caption="是否拆行" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false"/>
            <Property Key="Key" Caption="标志" Control="TextEditor"/>
            <Property Key="Caption" Caption="名称" Control="TextEditor"/>
            <Property Key="MinFillRowCount" Caption="最小明细填充数据行数" Control="TextEditor"/>
            <Property Key="PageBreakPolicy" Caption="分页策略" Control="Combobox" OnInitialize="None,无分页;GroupHead,根据分组头分页;" DefaultValue="None"/>
        </PropertyCollection>
    </Define>
    <Define Key="Column" Caption="列属性" Extends="">
        <PropertyCollection>
            <Property Key="Type" Caption="类型" Control="Combobox" OnInitialize="Fix, 固定列;Expand,扩展列;Group,分组列;Total,汇总列;" DefaultValue="Fix"/>
            <Property Key="Width" Caption="宽度" Control="NumberEditor"/>
            <Property Key="Visible" Caption="列可见性" Control="TextEditor"/>
            <Property Key="ExpandKey" Caption="列扩展标识" Control="Combobox" OnInitialize="=Macro_GetColumnExpandKey()"/>
            <Property Key="Lock" Caption="是否横向锁定" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false"/>
        </PropertyCollection>
    </Define>
    <Define Key="Row" Caption="行属性" Extends="">
        <PropertyCollection>
            <Property Key="Type" Caption="类型" Control="Combobox" OnInitialize=",未设置;TableTitleHead,表格标题头;DetailHead,明细头;LinkPrev,承上行;Detail,明细;LinkNext,启下行;DetailTail,明细尾;TableParagraph,表格段落;Group,分组行;TableTitleTail,表格标题尾" DefaultValue=""/>
            <Property Key="Height" Caption="高度" Control="NumberEditor"/>
            <Property Key="BackColor" Caption="背景色" Control="ColorEditor"/>
            <Property Key="TableKey" Caption="来源表"  Control="Combobox" OnInitialize="=Macro_GetTableKeys(GetRefFormKey())"/>
            <Property Key="GroupKey" Caption="行分组标识" Control="Combobox" OnInitialize="=Macro_GetRowGroupKey()"/>
            <Property Key="GroupLevel" Caption="分组层级" Control="NumberEditor" DefaultValue="-1"/>
            <Property Key="LineBreak" Caption="是否拆行" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false"/>
            <Property Key="PageBreak" Caption="页分隔符" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false"/>
            <Property Key="DtlCountEveryPage" Caption="每页行数" Control="NumberEditor" DefaultValue="0"/>
        </PropertyCollection>
    </Define>
    <Define Key="Cell" Caption="单元格属性" Extends="">
        <PropertyCollection>
            <Property Key="Key" Caption="标识" Control="TextEditor"/>
            <Property Key="Caption" Caption="名称" Control="TextEditor"/>
            <Property Key="CellText" Caption="内容" Type="CDATA" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})"/>
            <Property Key="Type" Caption="类型" Control="Combobox" OnInitialize="Text,文本;Image,图片"  DefaultValue="Text" />
            <Property Key="SourceType" Caption="数据来源类型" Control="Combobox" OnInitialize=",文本;Field,字段域;Formula,表达式;Interface,接口;PageNo,页码;Const,常量;System,系统域" />
            <Property Key="TableKey" Caption="表标识"Control="Combobox" OnInitialize="=Macro_GetTableKeys(GetRefFormKey())" Visible="GetPropertyValue('SourceType', '')=='Field'"/> <!--表字段和表标识应当是获取的下拉框 下面这些属性应该是随着数据来源类型可见性发生变化-->
            <Property Key="FieldKey" Caption="表字段" Control="Combobox" OnInitialize="=Macro_GetColumnKeyList(GetRefFormKey(),GetPrintCellTableKey())" Visible="GetPropertyValue('SourceType', '')=='Field'"/>
            <Property Key="Formula" Caption="表达式" Control="ButtonEditor" Visible="GetPropertyValue('SourceType', '')=='Formula'" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})"/>
            <Property Key="Impl" Caption="接口" Control="TextEditor" Visible="GetPropertyValue('SourceType', '')=='Interface'"/>
            <Property Key="PageNo" Caption="页码" Control="Combobox" Visible="GetPropertyValue('SourceType', '')=='PageNo'" OnInitialize="PageOfCount,总页数;Page,页码"/>
            <Property Key="SystemContent" Caption="系统域" Control="Combobox" OnInitialize=",未设置;Page,页数;PageOfCount,总页数;RowIndexOfTotal,行序号;RowIndexOfPage,页内行序号" Visible="GetPropertyValue('SourceType', '')=='System'"/>
            <Property Key="ImageSourceType" Caption="图片文件来源类型" Control="Combobox" Visible="GetPropertyValue('Type', 'Text')=='Image'" OnInitialize="Data,数据;Resource,资源;URL,URL" DefaultValue="Data"/>
            <Property Key="Path" Caption="路径" Control="TextEditor" Visible="GetPropertyValue('Type', 'Text')=='Image'"/>
            <Property Key="GroupType" Caption="分组类型" Control="Combobox" OnInitialize="None,无分组;RowGroup,行分组;RowTreeGroup,树形行分组;" DefaultValue="None"/>
            <Property Key="SortType" Caption="排序类型" Control="Combobox" OnInitialize="None,无排序;Asc,升序;Desc,降序;" DefaultValue="None"/>
           
            <Property Key="MergeDetail" Caption="是否合并明细区域" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false"/>
            <Property Key="MergeTopGroup" Caption="是否合并分组头" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false"/>
            <Property Key="MergeBottomGroup" Caption="是否合并分组尾" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false"/>
<!--            <Property Key="IsRowExpand" Caption="是否行扩展" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false"/>-->
            <Property Key="ColumnExpand" Caption="是否列扩展" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false"/>
            <Property Key="IsPrimary" Caption="是否主键" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false"/>
            <Property Key="IsSummary" Caption="是否总结信息" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false"/>
            <Property Key="FillEmptyContent" Caption="是否套打" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false"/>
            <Property Key="Overflow" Caption="内容溢出" Control="Combobox" OnInitialize="0,不处理;1,调整内容适应大小;2,调整大小适应内容;3,自动换行" DefaultValue="0" />
            <Property Key="Padding" Caption="内边距" Control="TextEditor"/>
<!--            <Property Key="LeftMargin" Caption="左边距" Control="NumberEditor"/>-->
<!--            <Property Key="TopMargin" Caption="顶边距" Control="NumberEditor"/>-->
<!--            <Property Key="RightMargin" Caption="右边距" Control="NumberEditor"/>-->
<!--            <Property Key="BottomMargin" Caption="底边距" Control="NumberEditor"/>-->
        </PropertyCollection>
    </Define>
</DefineCollection>
</PRINT>
`;
}
