import AbstractOptStateDelegate from "../../../../../common/state/AbstractOptStateDelegate";
import IPropertyView from "../IPropertyView";
import NormalState from "./NormalState";
import ResizeState from "./ResizeState";

export default class PropertyStateDelegate extends AbstractOptStateDelegate<IPropertyView> {

    private normalState: NormalState;

    private resizeState: ResizeState;

    constructor(view: IPropertyView) {
        super(view);
        this.normalState = new NormalState(this);
        this.resizeState = new ResizeState(this);
        this.setInitState(this.normalState);
    }

    setNormalState(): void {
        this.setCurrentState(this.normalState);
    }

    setResizeState(): void {
        this.setCurrentState(this.resizeState);
    }
}