import NodeDefine from "../../../../common/define/NodeDefine";
import PropertyDefine from "../../../../common/define/PropertyDefine";
import GlobalConstants from "../../../../common/struct/GlobalConstants";
import ITagNode from "../../../../common/xml/node/ITagNode";
import XmlEntity from "../../../../common/xml/XmlEntity";

export default class PropertyManager {

    private static NODE_DefineCollection: string = "DefineCollection";

    private static NODE_PropertyCollection: string = "PropertyCollection";

    //private static instance: WfPropertyManager = new WfPropertyManager();

    private bpmnXmlEntity: XmlEntity;

    private defines: Map<string, NodeDefine>;

    private root: ITagNode;

    constructor(propertiesXml: string) {
        this.bpmnXmlEntity = XmlEntity.parse(propertiesXml, true);
        this.root = this.bpmnXmlEntity.getTagRoot();
        this.defines = new Map();
        this.init();
    }

    public getNodeDefines(): IterableIterator<NodeDefine> {
        return this.defines.values();
    }

    public getNodeDefine(key: string): NodeDefine | undefined {
        return this.defines.get(key);
    }

    private init(): void {
        var defineCollection = this.root.getChild(PropertyManager.NODE_DefineCollection);
        var children = defineCollection?.getChildren();
        if (children) {
            for (let defineTag of children) {
                var tagNode = <ITagNode> defineTag;
                var key = tagNode.getAttributeValue(GlobalConstants.S_Key);
                var caption = tagNode.getAttributeValue(GlobalConstants.S_Caption);
                var extend = tagNode.getAttributeValue(GlobalConstants.S_Extends);
                var nodeDefine = new NodeDefine(key, caption, extend);
                this.defines.set(key, nodeDefine)

                var propertyCollection = tagNode.getChild(PropertyManager.NODE_PropertyCollection);
                var subNodes = propertyCollection?.getChildren();
                if (subNodes) {
                    for (let sub of subNodes) {
                        var propertyDefine = this.createPropertyNode(<ITagNode> sub);
                        nodeDefine.addProperty(propertyDefine);
                    }
                }
            }
        }
    }

    private createPropertyNode(tagNode: ITagNode): PropertyDefine {
        var key = tagNode.getAttributeValue(GlobalConstants.S_Key);
        var caption = tagNode.getAttributeValue(GlobalConstants.S_Caption);
        var controlType = tagNode.getAttributeValue(GlobalConstants.S_Control);
        var propertyDefine = new PropertyDefine(key, controlType);
        propertyDefine.setCaption(caption);
        propertyDefine.setTextAttributeKey(tagNode.getAttributeValue(GlobalConstants.S_TextAttributeKey));
        propertyDefine.setNode(tagNode.getAttributeValue(GlobalConstants.S_Node));
        propertyDefine.setXmlElementType(tagNode.getAttributeValue(GlobalConstants.S_Type));
        propertyDefine.setEditable(tagNode.getAttributeValue(GlobalConstants.S_Editable, 'true'));
        propertyDefine.setVisible(tagNode.getAttributeValue(GlobalConstants.S_Visible, 'true'));
        propertyDefine.setDefaultValue(tagNode.getAttributeValue(GlobalConstants.S_DefaultValue));
        propertyDefine.setGroup(tagNode.getAttributeValue(GlobalConstants.S_Group));
        propertyDefine.setOnInitialize(tagNode.getAttributeValue(GlobalConstants.S_OnInitialize));
        propertyDefine.setOnButtonClick(tagNode.getAttributeValue(GlobalConstants.S_OnButtonClick));
        propertyDefine.setOnValueChanged(tagNode.getAttributeValue(GlobalConstants.S_OnValueChanged));
        propertyDefine.setUpdateAttributeOnly(tagNode.getAttributeValueBoolean(GlobalConstants.S_UpdateAttributeOnly, false));
        return propertyDefine;
    }
}

