import { XMLElementType } from '../../../../common/enum/Enums';
import ISelectable from '../../../../common/selection/ISelectable';
import { ITagNodeContainer } from '../../../../common/view/ITagNodeContainer';
import ITagNode from '../../../../common/xml/node/ITagNode';
import IPropertyItem from './PropertyDefine';
import {IPropertyIO} from './PropertyDefine';
import {CommonConstant} from "../../../datamap/base/CommonConstant";

export default class PropertyIO implements IPropertyIO {

    private tagNodeContainer: ITagNodeContainer;

    protected curTagNode?: ITagNode;

    constructor(tagNodeContainer: ITagNodeContainer) {
        this.tagNodeContainer = tagNodeContainer;
    }

    prepare(selectable: ISelectable): void {
        this.curTagNode = selectable ? selectable.getTagNode() : this.tagNodeContainer.getTagRoot();
    }

    getTagName(): string {
        return this.curTagNode ? this.curTagNode.getTagName() : this.tagNodeContainer.getTagRoot().getTagName();
    }

    setValue(propertyItem: IPropertyItem, propertyValue: any): void {
        var tagNode = PropertyIO.setPropertyValue(this.curTagNode, propertyItem, propertyValue);
        tagNode && this.tagNodeContainer.update(tagNode, propertyItem.updateAttributeOnly);
    }

    getValue(propertyItem: IPropertyItem): any {
        if (!this.curTagNode) return "";

        var tagNode = PropertyIO.ensureProertyNode(propertyItem, this.curTagNode);
        var text = tagNode.getAttributeValue(propertyItem.textAttributeKey);
        switch (propertyItem.type) {
            case XMLElementType.ATTRIBUTE:
                let key = propertyItem.key;
                if(key == "sourceContent"){
                    key = "Definition";
                }
                if (tagNode.hasAttribute(key)) {
                    return tagNode.getAttributeValue(key);
                } else {
                    if(propertyItem.tag == CommonConstant.NODE_SourceField && key == CommonConstant.NODE_Definition){
                        return tagNode.getAttributeValue(CommonConstant.S_Key);
                    }
                    if (!text) {
                        return propertyItem.defaultvalue ? propertyItem.defaultvalue : "";
                    } else {
                        return text;
                    }
                }
            case XMLElementType.CDATA:
                var tmpNode = tagNode.getChild(propertyItem.key);
                return tmpNode ? tmpNode.getCDATAValue(): "";
            case XMLElementType.COLLECTION:
                var collection = tagNode.ensureChild(propertyItem.key);
                return collection;
        }
    }

    static setPropertyValue(curTagNode: ITagNode | undefined, propertyItem: IPropertyItem | undefined, propertyValue: any): ITagNode | undefined {
        if (!curTagNode || !propertyItem) return undefined;
        var tagNode = PropertyIO.ensureProertyNode(propertyItem, curTagNode);
        switch (propertyItem.type) {
            case XMLElementType.ATTRIBUTE:
                let key = propertyItem.key;
                if(key == "sourceContent"){
                    key = "Definition";
                }
                if (propertyItem.defaultvalue == propertyValue) {
                    tagNode.removeAttribute(key);
                } else {
                    tagNode.setAttributeValue(key, propertyValue);
                }
                break;
            case XMLElementType.CDATA:
                var tmpNode = tagNode.ensureChild(propertyItem.key);
                tmpNode.setCDATAValue(propertyValue);
                if(!propertyValue) {
                    tagNode.removeChild(tmpNode);
                }
                break;
            case XMLElementType.COLLECTION:
                // 集合类型的属性，情况比较复杂，直接在外部通过公式根据具体情况去设置
                //var collection = tagNode.getChild(propertyItem.key);
                break;   
        }
        return tagNode;
    }

    protected static ensureProertyNode(propertyItem: IPropertyItem, curTagNode: ITagNode): ITagNode {
        var tagNode = curTagNode;
        if (propertyItem.type == XMLElementType.ATTRIBUTE && propertyItem.node) {
            var tmpNode = curTagNode.ensureChild(propertyItem.node);
            if (tmpNode) tagNode = tmpNode;
        }
        if (propertyItem.tag != curTagNode.getTagName()) {
            var findTagNode = PropertyIO.findTagNodeFromParent(propertyItem.tag, curTagNode)
            if (findTagNode) tagNode = findTagNode;
        }
        return tagNode;
    }

    private static findTagNodeFromParent(findTag: string, tagNode: ITagNode | undefined): ITagNode | null {
        if (!tagNode) return null;
        if (tagNode.getTagName() == findTag) {
            return tagNode;
        } else {
            return PropertyIO.findTagNodeFromParent(findTag, tagNode.getParent());
        }
    }
}