import IXElement from "../../../../common/dom/xelement/IXElement";
import ISelectable from "../../../../common/selection/ISelectable";
import PropertyUIContainer from "../ui/PropertyUIContainer";
import Tab from './../../../../common/component/tab/Tab';

export interface IPropertyObject {
    
    getComponentName(): string;

    getPropertyValue(propertyKey: string): any;

    setPropertyValue(propertyKey: string, value: any): void;
}

/**
 * 定义单个组件的全部属性列表
 * 
 */
export default interface IPropertyItem {
    tag: string
    key: string,
    caption: string,
    textAttributeKey: string
    control: string,
    defaultvalue: any,
    type: string,  //XMLElementType,
    updateAttributeOnly: boolean,
    node?: string,
    onbuttonclick?: string,
    oninitialize?: string,
    onvaluechanged?: string,
    editable: string,
    visible: string,
    group?: string,
    component?: any,
    component2?: any //可能会放入两个组件
}

export interface IPropertyGroup {
    key: string;
    caption: string;
    expanded: boolean;
    properties: IPropertyItem[];
    config?: any;
}

export interface IPropertyIO {
    getTagName(): string;
    prepare(selectable: ISelectable): void;
    setValue(propertyItem: IPropertyItem, value: any): void;
    getValue(propertyItem: IPropertyItem): any;
}

export interface IPropertyPlugin {

    commit(): void;

    display(componentName: string, callback: IPropertyIO, parent: HTMLElement): void;

    setPropertyValue(key: string, value: any, text?: string): void;

    setFocus(key: string): void;
}

export interface IPropertyContainer<T extends IPropertyPlugin> {
    getPropertyUIContainer(): PropertyUIContainer<T>;
}

