import NodeDefine from "../../../../common/define/NodeDefine";
import PropertyDefine from "../../../../common/define/PropertyDefine";
import IPropertyItem, { IPropertyGroup } from "./PropertyDefine";
import PropertyManager from "./PropertyManager";

/**
 * 工作流属性集合
 */
export default abstract class AbstractPropertyDefine {

    private properyManager: PropertyManager;

    constructor(propertyMananger: PropertyManager) {
        this.properyManager = propertyMananger;
    }

    private createNodeDefine(nodeDefine: NodeDefine | undefined): IPropertyGroup[] {
        var groups: IPropertyGroup[] = [];
        if (!nodeDefine) return groups;
        for( let propertyDefine of nodeDefine.getProperties()) {
            var item = this.createPropertyItem(nodeDefine.getKey(), propertyDefine);
            var group = this.ensurePropertyGroup(item.group ? item.group : nodeDefine.getCaption(), groups);
            group.properties.push(item);
        }
        return groups;
    }

    private ensurePropertyGroup(groupCaption: string, groups: IPropertyGroup[]): IPropertyGroup {
        for (let group of groups) {
            if (group.caption == groupCaption) {
                return group;
            }
        }
        var newGroup = {
            key: groupCaption, 
            caption: groupCaption,
            expanded: true,
            properties: []
        }
        groups.push(newGroup);
        return newGroup;
    }

    private createPropertyItem(tag: string, propertyDefine: PropertyDefine): IPropertyItem {
        return {
            tag: tag,
            key: propertyDefine.getKey(),
            caption: propertyDefine.getCaption(),
            textAttributeKey: propertyDefine.getTextAttributeKey(),
            updateAttributeOnly: propertyDefine.isUpdateAttributeOnly(),
            control: propertyDefine.getControlType(),
            type: propertyDefine.getXmlElementType(),
            node: propertyDefine.getNode(),
            onbuttonclick: propertyDefine.getOnButtonClick(),
            oninitialize: propertyDefine.getOnInitialize(),
            onvaluechanged: propertyDefine.getOnValueChanged(),
            group: propertyDefine.getGroup(),
            defaultvalue: propertyDefine.getDefaultValue(),
            editable: propertyDefine.getEditable(),
            visible: propertyDefine.getVisible()
        };
    }

    private merge(baseGroups:IPropertyGroup[], mergeGroup: IPropertyGroup[]): void {
        for (let merge of mergeGroup) {
            var group = this.ensurePropertyGroup(merge.caption, baseGroups);
            for (let item of merge.properties) {
                group.properties.push(item);
            }
        }
    }

    public getPropertyDefines(type: string): IPropertyGroup[] {
        var nodeDefine = this.properyManager.getNodeDefine(type);
        if (!nodeDefine) return [];
        var extend = nodeDefine.getExtend();
        if (extend) {
            var extendGroup = this.getPropertyDefines(extend);
            var curGroup = this.createNodeDefine(nodeDefine);
            this.merge(extendGroup, curGroup);
            return extendGroup;
        } else {
            return this.createNodeDefine(nodeDefine);
        }
    }

    public getPropertyDefinesByTypes(types: string[]): IPropertyGroup[] {
        var all: IPropertyGroup[] = [];
        for (let type of types) {
            var groups = this.getPropertyDefines(type);
            this.merge(all, groups);
        }
        return all;
    }
}