
/**
 * 加载css,与js
 */
 export default abstract class AbstractResourceLoader {

    protected webRoot: string;

    constructor() {
        this.webRoot = AbstractResourceLoader.getWebRoot();
        this.loadResources();
    }

    private loadScript(url: string) {
        return new Promise((resolve, reject) => {
            const script = document.createElement('script');
            script.src = url;
            script.defer = true;
            script.onload = resolve;
            script.onerror = reject;
            document.getElementsByTagName('head')[0].appendChild(script);
        });
    }

    private loadCSS(cssUrl: string): void {
        var head = document.getElementsByTagName('head')[0];
        var link = document.createElement('link');
        link.href = cssUrl;
        link.rel = 'stylesheet';
        link.type = 'text/css';
        head.appendChild(link);
    };

    private loadResources() {
        var cssArray = this.getCssLinkArray();
        for (let cssLink of cssArray) {
            cssLink && this.loadCSS(cssLink);
        }

        var _loadJs = (jsArray: string[]) => {
            var js = jsArray.shift();
            if (js) {
                this.loadScript(js).then(() => {
                    _loadJs(jsArray);
                });
            }
        };
        var jsArr = this.getJSLinkArray();
        _loadJs(jsArr);
    }

    protected static getWebRoot(): string {
        return YIUI.webRoot ? "./yesui-vnode/" : "../";  //YIUI.webRoot 生产环境下 返回 erp/yesui-vnode/
    }

    protected abstract getJSLinkArray(): string[];

    protected abstract getCssLinkArray(): string[];

}
