import ArrayList from "../../../../common/struct/ArrayList";
import IGElement from "../../../../common/ui/graphic/IGElement";
import IGTable from "../../../../common/ui/graphic/IGTable";

export default class GDataMapElement implements IGTable {

    private snapEl: Snap.Element;
    private paper: Snap.Paper;
    private children: ArrayList<IGElement>;

    constructor(snapEl: Snap.Element) {
        this.snapEl = snapEl;
        this.children = new ArrayList<IGElement>();
        this.paper = <Snap.Paper>this.getGNode();
    }

    remove(): IGTable {
        this.children.clearAll();
        this.snapEl.remove();
        return this;
    }

    mousedown(handler: (event: MouseEvent) => void, thisArg?: any): IGTable {
        this.snapEl.mousedown(handler, thisArg);
        return this;
    }

    mousemove(handler: (event: MouseEvent) => void, thisArg?: any): IGTable {
        this.snapEl.mousemove(handler, thisArg);
        return this;
    }

    mouseout(handler: (event: MouseEvent) => void, thisArg?: any): IGTable {
        this.snapEl.mouseout(handler, thisArg);
        return this;
    }

    mouseover(handler: (event: MouseEvent) => void, thisArg?: any): IGTable {
        this.snapEl.mouseover(handler, thisArg);
        return this;
    }

    mouseup(handler: (event: MouseEvent) => void, thisArg?: any): IGTable {
        this.snapEl.mouseup(handler, thisArg);
        return this;
    }

    path(pathSpec: string | (string | number)[][]): IGTable {
        var elem = this.paper.path(pathSpec);
        return new GDataMapElement(elem);
    }

    line(x1: number, y1: number, x2: number, y2: number): IGTable {
        var elem = this.paper.line(x1, y1, x2, y2);
        return new GDataMapElement(elem);
    }

    table(x: number, y: number, width: number, height: number, ele: HTMLElement): SVGForeignObjectElement {
        let svgSourceElement = document.createElementNS('http://www.w3.org/2000/svg', "foreignObject");
        svgSourceElement.setAttribute("x", x.toString());
        svgSourceElement.setAttribute("y", y.toString())
        svgSourceElement.setAttribute("width", width.toString());
        svgSourceElement.setAttribute("height", height.toString());
        svgSourceElement.appendChild(ele)
        this.getHtmlElement().appendChild(svgSourceElement);
        return svgSourceElement;
    }

    clear(): void {
        this.paper.clear()
    }

    getGNode(): Snap.Element {
        return this.snapEl;
    }

    attr(params: { [attr: string]: any; }): IGTable {
        this.snapEl.attr(params);
        return this;
    }

    addClass(cls: string): IGTable {
        this.snapEl.addClass(cls);
        return this;
    }

    getHtmlElement(): HTMLElement {
        return this.snapEl.node;
    }

    section(varargs?: any): IGTable {
        //var el = document.createElement('g');
        //this.paper.add(el);
        var section = this.paper.g();
        return new GDataMapElement(section);
    }
}