import JComponent from "../../../../common/component/JComponent";
import IExcelElementView from "./IExcelElementView";
import ITagNode from "../../../../common/xml/node/ITagNode";
import PrintConstants from "../../../print/base/PrintConstants";
import INode from "../../../../common/xml/node/INode";
import BaseConstants from "../../../base/BaseConstants";
import PRINT from "../../../print/base/PRINT";
import EXCEL from "../../base/EXCEL";
import ExcelConstants from "../../base/ExcelConstants";
import {ExcelCellView} from "./ExcelCellView";
import ExcelTableLayout from "../ExcelTableLayout";
import DomElement from "../../../../common/dom/element/DomElement";
import TagNode from "../../../../common/xml/node/TagNode";
import DomUtil from "../../../../common/dom/DomUtil";
import ExcelGraphicView from "../ExcelGraphicView";

export default class SheetView extends JComponent<ExcelTableLayout> implements IExcelElementView {
    private tagNode: ITagNode;
    private D_MAX_COL_SIZE: number = 0;
    private D_MAX_ROW_SIZE: number = 0;


    private tableElement: ExcelTableLayout;

    constructor(tagNode: ITagNode, MAX_ROW_SIZE: number = 0, MAX_COL_SIZE: number = 0, excelGraphicView: ExcelGraphicView, create: boolean) {
        super(new ExcelTableLayout([], 0, create));
        this.tagNode = tagNode;
        this.tableElement = this.getDomElement();
        if (!create) {
            return;
        }
        this.D_MAX_ROW_SIZE = MAX_ROW_SIZE;
        this.D_MAX_COL_SIZE = MAX_COL_SIZE;
        var columns: number[] = [];
        var D_MAX_COL_SIZE = Math.max(EXCEL.D_MAX_COL_SIZE, this.D_MAX_COL_SIZE);
        let tagColumns = this.tagNode.getChild("Columns");
        if (tagColumns) {
            var columnsNode: INode[] | undefined = tagColumns?.getChildren();
            for (let i = 0; i < columnsNode!.length; i++) {
                let rowNode = <ITagNode>columnsNode![i];
                let colIndex = rowNode.getAttributeValueInt(ExcelConstants.ATTR_ColumnIndex, 1);
                D_MAX_COL_SIZE = Math.max(D_MAX_COL_SIZE, colIndex)
            }
        }
        var tagRowsNode = this.tagNode.getChild(ExcelConstants.NODE_Rows);
        var tagRows: INode[] | undefined = tagRowsNode?.getChildren();
        for (let i = 0; i < tagRows!.length; i++) {
            let rowNode = <ITagNode>tagRows![i];
            if (rowNode) {
                for (let j = 0; j < rowNode.getChildren().length; j++) {
                    var child = <ITagNode>rowNode.getChildren()[j];
                    let rowIndex = child.getAttributeValueInt(ExcelConstants.ATTR_CellIndex, 1);
                    D_MAX_COL_SIZE = Math.max(D_MAX_COL_SIZE, rowIndex)
                }
            }
        }
        for (let i = 0; i < D_MAX_COL_SIZE; i++) {
            columns.push(EXCEL.D_COLUMN_WIDTH)
        }
        columns[0] = EXCEL.D_TH_COLUMN_HEIGHT;
        if (tagColumns) {
            var columnsNode: INode[] | undefined = tagColumns?.getChildren();
            for (let i = 0; i < columnsNode!.length; i++) {
                let rowNode = <ITagNode>columnsNode![i];
                let width = rowNode.getAttributeValueInt(BaseConstants.ATTR_Width, EXCEL.D_COLUMN_WIDTH);
                let rowIndex = rowNode.getAttributeValueInt(ExcelConstants.ATTR_ColumnIndex, 0);
                columns[rowIndex] = width;
            }
        }
        this.tableElement.init(columns, 0);
        this.tableElement.addClass('excelareaLayout');

        var rows = [];
        var D_MAX_ROW_SIZE = Math.max(EXCEL.D_MAX_ROW_SIZE, this.D_MAX_ROW_SIZE);
        for (let i = 0; i < tagRows!.length; i++) {
            let rowNode = <ITagNode>tagRows![i];
            let rowIndex = rowNode.getAttributeValueInt(ExcelConstants.ATTR_RowIndex, 1);
            D_MAX_ROW_SIZE = Math.max(D_MAX_ROW_SIZE, rowIndex)
        }
        for (let i = 0; i < D_MAX_ROW_SIZE; i++) {
            rows.push(EXCEL.D_ROW_HEIGHT)
        }
        var types = [];
        for (let i = 0; i < EXCEL.D_MAX_ROW_SIZE; i++) {
            types.push(EXCEL.D_ROW_Type)
        }
        for (let i = 0; i < tagRows!.length; i++) {
            let rowNode = <ITagNode>tagRows![i];
            let height = rowNode.getAttributeValueInt(BaseConstants.ATTR_Height, EXCEL.D_ROW_HEIGHT);
            let type = rowNode.getAttributeValue(BaseConstants.ATTR_Type, "Fix");
            let rowIndex = rowNode.getAttributeValueInt(ExcelConstants.ATTR_RowIndex, 0) - 1;
            rows[rowIndex] = height;
            types[rowIndex] = type;
        }
        for (var rowindex = 0; rowindex < rows.length; rowindex++) {
            var rowElement = this.tableElement.addRow(rows[rowindex], rowindex, types[rowindex]);
            for (var colindex = 0; colindex < columns.length; colindex++) {
                var cellView = new ExcelCellView(rowindex, colindex);
                var tagNode1 = new TagNode("Cell");
                tagNode1.setAttributeValue("rowindex", String(rowindex));
                tagNode1.setAttributeValue("colindex", String(colindex));
                cellView.setTagCell(tagNode1)
                rowElement.setCellElement(colindex, cellView);
                //cellView.updateView();
            }

        }
        this.updateRows(excelGraphicView);

    }

    getMaxRow(): number {
        return this.D_MAX_ROW_SIZE;
    }

    getMaxCol(): number {
        return this.D_MAX_COL_SIZE;
    }

    setMaxRow(row: number): void {
        this.D_MAX_ROW_SIZE = row;
    }

    setMaxCol(col: number): void {
        this.D_MAX_COL_SIZE = col;
    }

    containPoint(x: number, y: number): boolean {
        var offset = DomUtil.offsetParent(this.getEl());
        var top = offset.offsetTop;
        var left = offset.offsetLeft;
        var width = this.getDomElement().getHtmlClientWidth();
        var height = this.getDomElement().getHtmlClientHeight();
        return x >= left && x <= (left + width)
            && y >= top && y <= (top + height);
    }

    getColumns(): number[] {
        var columnWidths = [];
        var tagColumnsNode = this.tagNode.getChild(PrintConstants.NODE_Columns);
        var tagColumns: INode[] | undefined = tagColumnsNode?.getChildren();
        if (tagColumns) {
            for (let column of tagColumns) {
                var tagColumn = <ITagNode>column;
                columnWidths.push(tagColumn.getAttributeValueInt(BaseConstants.ATTR_Width, PRINT.D_COLUMN_WIDTH));
            }
        }
        return columnWidths;
    }

    getChildNode(row: number, col: number): ExcelCellView | null {
        var cell = this.tableElement.getCellAt(row, col);

        if (cell) {
            return <ExcelCellView>cell.getContent();

        }
        return cell;
    }

    locMultiCell(x: number, y: number): ExcelCellView | null {
        var cellLocation = this.tableElement.hitCell(x, y);
        if (cellLocation) {
            var cell = this.tableElement.getCell(cellLocation);
            return <ExcelCellView>cell.getContent();
        }
        return null;
    }

    getChildColgroupNode(col: number): any {
        return this.tableElement.getColgroupAt(col);
    }

    getChildColgroupNodes(): any {
        return this.tableElement.getColgroups();
    }

    getColChildNode(col: number): any[] {
        var colList = [];
        var lastRowIndex = this.tableElement.getLastRowIndex();
        for (let i = 0; i <= lastRowIndex; i++) {
            colList.push(this.tableElement.getCellAt(i, col));
        }
        return colList;
    }

    getRowChildNode(row: number): any[] {
        var rowList = [];
        var lastColumnIndex = this.tableElement.getLastColumnIndex();
        for (let i = 0; i <= lastColumnIndex; i++) {
            rowList.push(this.tableElement.getCellAt(row, i));
        }
        return rowList;
    }

    getChildThNode(col: number): any {
        try {
            return this.tableElement.getTheadThAt(col);

        } catch (e) {
            return null;

        }
    }

    getRowChildThNode(row: number): any {
        try {
            return this.tableElement.getBodyThAt(row);

        } catch (e) {
            return null;

        }
    }

    getColSize(): number {
        return this.tableElement.getLastColumnIndex();
    }

    getRowSize(): number {
        return this.tableElement.getLastRowIndex();
    }

    getChildCell(row: number, col: number): any | null {
        return this.tableElement.getCellAt(row, col);
    }

    getTagNode(): ITagNode {
        return this.tagNode;
    }

    isEmbed(): boolean {
        return false;
    }

    resetColumnsLefts(): void {
        //更新界面
        var thead = this.tableElement.getThead();
        thead.resetColumnsLefts(thead.getChildren()[0].getChildren())
    }

    updateView(): void {

    }

    updateMultiView(): void {

    }

    updateRows(excelGraphicView: ExcelGraphicView) {
        var tagRowsNode = this.tagNode.getChild(ExcelConstants.NODE_Rows);

        var tagRows: INode[] | undefined = tagRowsNode?.getChildren();
        if (tagRows) {
            for (var rowindex = 0; rowindex < tagRows.length; rowindex++) {
                var tagRow = <ITagNode>tagRows[rowindex];
                var rowIndex = tagRow.getAttributeValueInt("RowIndex", 0);
                var tagCells = tagRow.getChildren();
                for (var colindex = 0; colindex < tagCells.length; colindex++) {
                    var tagCell = <ITagNode>tagCells[colindex];
                    var cellIndex = tagCell.getAttributeValueInt("CellIndex", 0);
                    var childNode = <ExcelCellView>this.getChildNode(rowIndex - 1, cellIndex - 1);
                    childNode.setTagCell(tagCell);
                    var rowSpan = tagCell.getAttributeValueInt(BaseConstants.ATTR_RowSpan, 0);
                    var colSpan = tagCell.getAttributeValueInt(BaseConstants.ATTR_ColSpan, 0);
                    if (rowSpan == 0 && colSpan > 0) {
                        for (let i = 0; i < colSpan; i++) {
                            for (let j = 0; j <= rowSpan; j++) {
                                var childNode1 = <ExcelCellView>this.getChildNode(rowIndex + j - 1, cellIndex + i - 1);
                                if (childNode == childNode1) {
                                    continue;
                                }

                                var containerEl = childNode1.parentEl();
                                if (containerEl) {//td
                                    var container = new DomElement(containerEl);
                                    container.addClass("divisioncell");
                                    container.setAttr("MegerHeadRowindex", String(rowIndex - 1));
                                    container.setAttr("MegerHeadColindex", String(cellIndex - 1));
                                    childNode1.setAttr("MegerHeadRowindex", String(rowIndex - 1));
                                    childNode1.setAttr("MegerHeadColindex", String(cellIndex - 1));
                                }

                                childNode1.setCellVisible(false);
                                childNode1.setMegerHeadRowindex(rowIndex - 1);
                                childNode1.setMegerHeadColindex(cellIndex - 1);
                            }
                        }
                    } else if (rowSpan > 0 && colSpan == 0) {
                        for (let i = 0; i <= colSpan; i++) {
                            for (let j = 0; j < rowSpan; j++) {
                                var childNode1 = <ExcelCellView>this.getChildNode(rowIndex + j - 1, cellIndex + i - 1);
                                if (childNode == childNode1) {
                                    continue;
                                }
                                var containerEl = childNode1.parentEl();
                                if (containerEl) {//td
                                    var container = new DomElement(containerEl);
                                    container.addClass("divisioncell");
                                    container.setAttr("MegerHeadRowindex", String(rowIndex - 1));
                                    container.setAttr("MegerHeadColindex", String(cellIndex - 1));
                                    childNode1.setAttr("MegerHeadRowindex", String(rowIndex - 1));
                                    childNode1.setAttr("MegerHeadColindex", String(cellIndex - 1));
                                }
                                childNode1.setCellVisible(false);
                                childNode1.setMegerHeadRowindex(rowIndex - 1);
                                childNode1.setMegerHeadColindex(cellIndex - 1);
                            }
                        }
                    } else if (rowSpan > 0 && colSpan > 0) {
                        for (let i = 0; i < colSpan; i++) {
                            for (let j = 0; j < rowSpan; j++) {
                                var childNode1 = <ExcelCellView>this.getChildNode(rowIndex + j - 1, cellIndex + i - 1);
                                if (childNode == childNode1) {
                                    continue;
                                }

                                var containerEl = childNode1.parentEl();
                                if (containerEl) {//td
                                    var container = new DomElement(containerEl);
                                    container.addClass("divisioncell");
                                    container.setAttr("MegerHeadRowindex", String(rowIndex - 1));
                                    container.setAttr("MegerHeadColindex", String(cellIndex - 1));
                                    childNode1.setAttr("MegerHeadRowindex", String(rowIndex - 1));
                                    childNode1.setAttr("MegerHeadColindex", String(cellIndex - 1));
                                }

                                childNode1.setCellVisible(false);
                                childNode1.setMegerHeadRowindex(rowIndex - 1);
                                childNode1.setMegerHeadColindex(cellIndex - 1);
                            }
                        }
                    }
                    childNode.updateView(excelGraphicView);
                }
            }
        }
    }

    findChildNode(tagNode: ITagNode): IExcelElementView | undefined {

        var colindex = tagNode.getAttributeValue("colindex", "none");
        var rowindex = tagNode.getAttributeValue("rowindex", "none");
        if (colindex == "none" || rowindex == "none") {
            var childNodeByTagNode = this.getChildNodeByTagNode(tagNode);
            if (childNodeByTagNode) {
                return childNodeByTagNode;
            }
            return undefined
        }
        for (var row = 0; row <= this.tableElement.getLastRowIndex(); row++) {
            for (var col = 0; col <= this.tableElement.getLastColumnIndex(); col++) {
                var cell = this.tableElement.getCellAt(row, col);
                var cellView = <ExcelCellView>cell.getContent();

                if (cellView.getTagNode()?.getAttributeValue("colindex") == colindex && cellView.getTagNode()?.getAttributeValue("rowindex") == rowindex) {
                    return cellView;
                    //
                }
            }
        }
        return undefined;
    }

    getChildNodeByTagNode(tagNode: ITagNode | undefined): IExcelElementView | undefined {
        for (var row = 0; row <= this.tableElement.getLastRowIndex(); row++) {
            for (var col = 0; col <= this.tableElement.getLastColumnIndex(); col++) {
                var cell = this.tableElement.getCellAt(row, col);
                var cellView = <ExcelCellView>cell.getContent();
                if (cellView.getTagNode() == tagNode) {
                    return cellView;
                    //
                }
            }
        }
        return undefined;
    }
}