import PrintToolbar from "../../print/view/PrintToolbar";
import Paras from "../../../common/struct/Paras";
import AbstractControl from "../../../common/component/control/AbstractControl";
import PrintButtonBox from "../../print/view/PrintButtonBox";
import PRINT from "../../print/base/PRINT";
import EXCEL from "../base/EXCEL";
import P18N from "../base/P18N";
import ExcelColorEditor from "../../../common/component/control/ExcelColorEditor";

export default class ExcelToolbar extends PrintToolbar {


    updateToobar(printToolbar: ExcelToolbar, paras: Paras) {

        var toolBarItems = printToolbar.getToolBarItems();
/*

        // var borderColor: AbstractControl<any> = toolBarItems.get("BorderColor");//边框颜色
        var border_style: PrintButtonBox = toolBarItems.get("border_style");//边框模式
        var images1 = ['url("' + EXCEL.PREFIX + '/css/img/border_none.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/border_style1.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/border_style_dashed.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/border_style_double.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/border_style_Hair.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/border_style_medium.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/border_style_Thick.png") center no-repeat'
        ]
        border_style.buttonText.setStyle("background", images1[Number(border_style.buttonText.getValue())]);

        var borderStyle: PrintButtonBox = toolBarItems.get("BorderStyle");//边框类型
        var images = [
            'url("' + EXCEL.PREFIX + '/css/img/cell_full_border.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/cell_no_border.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/cell_full_out_border.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/cell_left_out_border.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/cell_right_out_border.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/cell_top_out_border.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/cell_bottom_out_border.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/cell_left_border.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/cell_right_border.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/cell_top_border.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/cell_bottom_border.png") center no-repeat'
        ];
        borderStyle.buttonText.setStyle("background", images[Number(borderStyle.buttonText.getValue())]);

*/


        var element = paras.getElement();
        var showEvl = toolBarItems.get("showEvl");
        var text = toolBarItems.get("text");

        if (element && element.tagName == "Cell") {
            var row = element.getParent();
            showEvl.setValue("");
            text.setValue("");
            if (!row) {
                return;
            }
            var display = element.getChild("Display");
            var font;
            var border;
            var backColor: ExcelColorEditor = toolBarItems.get("BackColor");
            var foreColor: ExcelColorEditor = toolBarItems.get("ForeColor");
            //var hAlign: AbstractControl<any> = toolBarItems.get("HAlign");
            var left_align: AbstractControl<any> = toolBarItems.get("left_align");
            var center_align: AbstractControl<any> = toolBarItems.get("center_align");
            var right_align: AbstractControl<any> = toolBarItems.get("right_align");
            var top_align: AbstractControl<any> = toolBarItems.get("top_align");
            var vcenter_align: AbstractControl<any> = toolBarItems.get("vcenter_align");
            var bottom_align: AbstractControl<any> = toolBarItems.get("bottom_align");
            //var vAlign: AbstractControl<any> = toolBarItems.get("VAlign");
            if (display) {
                font = display.getChild("Font");
                border = display.getChild("Border");
                backColor.setValueAndStyle(display.getAttributeValue("BackColor"),P18N.getColorString(display.getAttributeValue("BackColor")));
                foreColor.setValueAndStyle(display.getAttributeValue("ForeColor"),P18N.getColorString(display.getAttributeValue("ForeColor")));
                var hAlign = display.getAttributeValue("HAlign");
                var vAlign = display.getAttributeValue("VAlign");
                switch (vAlign) {
                    case "Top":
                        top_align.setValue("true");

                        vcenter_align.setValue("false");

                        bottom_align.setValue("false");

                        break;
                    case "Bottom":
                        top_align.setValue("false");
                        vcenter_align.setValue("false");
                        bottom_align.setValue("true");
                        break;
                    default:
                        top_align.setValue("false");
                        vcenter_align.setValue("true");
                        bottom_align.setValue("false");
                        break;
                }
                switch (hAlign) {
                    case "Left":
                        left_align.setValue("true");
                        center_align.setValue("false");
                        right_align.setValue("false");
                        break;
                    case "Right":
                        left_align.setValue("false");
                        center_align.setValue("false");
                        right_align.setValue("true");
                        break;
                    default:
                        left_align.setValue("false");

                        center_align.setValue("true");


                        right_align.setValue("false");
                        break;
                }
            } else {
                backColor.setValue("");
                foreColor.setValue("");
                left_align.setValue("false");
                center_align.setValue("true");
                right_align.setValue("false");
                top_align.setValue("false");
                vcenter_align.setValue("true");
                bottom_align.setValue("false");

            }
            //字体
            var name: AbstractControl<any> = toolBarItems.get("Name");
            //字体大小
            var size: AbstractControl<any> = toolBarItems.get("Size");
            var bold: AbstractControl<any> = toolBarItems.get("Bold");
            var italic: AbstractControl<any> = toolBarItems.get("Italic");
            if (font) {
                size.setValue(font.getAttributeValue("Size"));
                name.setValue(font.getAttributeValue("Name"));
                // : "SolidNormal");
                bold.setValue(font.getAttributeValue("Bold"));
                italic.setValue(font.getAttributeValue("Italic"));
            } else {
                size.setValue("12");
                name.setValue("宋体");
                bold.setValue("false");
                italic.setValue("false");
            }

            var textValue = element.getAttributeValue("Definition", "");
            showEvl.setValue(textValue);
            text.setValue(textValue);

        } else {
            showEvl.setValue("");
            text.setValue("");
            return;
        }


    }
}