import ButtonElement from "../../../common/dom/element/ButtonElement";
import AbstractControl from "../../../common/component/control/AbstractControl";
import SizeInfo from "../../../common/struct/SizeInfo";
import AbstractDomElement from "../../../common/dom/AbstractDomElement";
import Button from "../../../common/component/control/Button";


export default class ExcelButtonBox extends AbstractControl<ButtonElement> {
    public buttonContainer: ButtonContainer

    constructor(caption: string, width: SizeInfo, height: SizeInfo) {
        super(new ButtonElement(caption));
        this.buttonContainer = new ButtonContainer(width.toString(), height.toString());
    }

    initButtonContainer(buttonContainerItems: Map<string, Button>): void {
        this.buttonContainer.initButtonContainerItems(buttonContainerItems)
    }
}

class ContainerItem extends AbstractDomElement {
    private item: any;

    constructor(item: any) {
        super();
        this.item = item;
        this.addClass('property-Container-item');
        this.setStyle('width', '70px');
        this.setStyle('height', '20px');
        this.setStyle('margin', '2px');
        this.setStyle('cursor', 'pointer');
        this.setStyle('border-width', '1px');
    }

    public getContainer(): string {
        return this.item;
    }
}

class ButtonContainer extends AbstractDomElement {
    private buttonContainerItems?: Map<string, Button>;
    private newbuttonContainerItems: Map<string, Button>;

    constructor(width: string, height: string) {
        super();
        this.addClass("ButtonContainer");
        this.setStyle('position', 'absolute');
        this.setStyle('z-index', '66666666');
        this.setStyle('display', 'flex');
        this.setStyle('width', width);
        this.setStyle('height', height);
        this.setStyle('margin-top', '-6px');
        this.setStyle('flex-direction', 'column');
        this.setStyle('flex-wrap', 'wrap');
        this.setStyle('justify-content', 'center');
        this.setStyle('align-items', 'center');
        this.setAttr("tabindex", "0");
        this.setStyle("background-color", "#deecf9");
        this.newbuttonContainerItems = new Map();
    }

    initButtonContainerItems(buttonContainerItems: Map<string, Button>): void {
        this.clearChildren();
        this.newbuttonContainerItems = new Map()
        this.buttonContainerItems = buttonContainerItems;
        // 遍历数组，添加pick按钮至容器
        this.buttonContainerItems.forEach((a, b) => {
            var button = new Button(a.getDomElement().getText());
            this.newbuttonContainerItems.set(b, button);
            // $.extend(true,button,item);
            button.getEl().setAttribute("value", b);
            button.setStyle("background-color", "#deecf9");
            this.addChild(button.getDomElement());
        });
    }

    getButtonContainerItem(key: string): Button | undefined {
        return this.newbuttonContainerItems!.get(key);
    }

    getButtonContainerItems(): Map<string, Button> | undefined {
        return this.buttonContainerItems;
    }


}