import AbstractPrintOptState from "../../print/state/AbstractPrintOptState";
import ITagNode from "../../../common/xml/node/ITagNode";
import BaseConstants from "../../base/BaseConstants";
import AbstractExcelOptState from "./AbstractExcelOptState";
import PrintConstants from "../../print/base/PrintConstants";
import EXCEL from "../base/EXCEL";
import ExcelConstants from "../base/ExcelConstants";
import SheetView from "../view/element/SheetView";
import {ExcelCellView} from "../view/element/ExcelCellView";
import XmlEntity from "../../../common/xml/XmlEntity";


export default class RragRowState extends AbstractExcelOptState {

    private start: number = -1;
    private tagNode?: ITagNode;
    private el: any;
    private startNode? :ITagNode;
    private endNode? :ITagNode;
    mousedown(e: MouseEvent): void {
        super.mousedown(e);
        var {x, y} = this.getPosition(e);
        let selectSheetViewName = this.getView().getSelectSheetViewName();
        let tagRoot = this.getView().getXmlEntity().getTagRoot();
        let children = tagRoot.getChildren();
        let sheetNode;
        for (let child of children) {
            let sheet = <ITagNode>child;
            let key = sheet.getAttributeValue(BaseConstants.ATTR_Name);
            if (key == selectSheetViewName) {
                sheetNode = sheet;
                break;
            }
        }
        let parentNode =<HTMLElement>((<HTMLElement>e.target).parentNode);
        let rowIndex = Number(parentNode.innerText);
        this.tagNode = sheetNode;
        let row;
        let rowsNode = <ITagNode> this.tagNode!.getChildren()[0];
        let rows = rowsNode!.getChildren();
        if (rowsNode) {
            for (let rowd of rows) {
                let rowNode = <ITagNode>rowd
                let rowin = Number(rowNode.getAttributeValue(ExcelConstants.ATTR_RowIndex));
                if (rowin && rowin == rowIndex) {
                    row = rowNode;
                    break;
                }
            }
            if (row){
                this.startNode =  XmlEntity.parseTagNode(row.toXml(true));
            }
        }
        this.el = e.target;
        this.start = y;
    }

    mousemove(e: MouseEvent): void {
        let ele = <HTMLElement>e.target;
        if (e.button == 0 && e.buttons == 1) {
            var {x, y} = this.getPosition(e);
            let sheetNode = this.tagNode!;
            let length: number = this.start - y;
            let number = Math.abs(length);
            let el = <HTMLElement>this.getEl();
            let parentNode = <HTMLElement>el.parentNode;
            let rowIndex = Number(parentNode.innerText);
            let row;
            let rowsNode = <ITagNode>sheetNode.getChildren()[0];
            let rows = rowsNode!.getChildren();
            if (!rowsNode) {
                rowsNode = this.getView().getXmlEntity().getNodeFactory().createTagNode(ExcelConstants.NODE_Rows)
                rowsNode.setParent(sheetNode);
                sheetNode.addChild(rowsNode);
                this.getView().getXmlEntity().update(sheetNode, true);
            } else {
                for (let rowd of rows) {
                    let rowNode = <ITagNode>rowd
                    let rowin = Number(rowNode.getAttributeValue(ExcelConstants.ATTR_RowIndex));
                    if (rowin && rowin == rowIndex) {
                        row = rowNode;
                        break;
                    }
                }
            }
            if (!row) {
                let rowNode = this.getView().getXmlEntity().getNodeFactory().createTagNode(ExcelConstants.NODE_Row);
                rowNode.setParent(rowsNode);
                rowNode.setAttributeValue(BaseConstants.ATTR_Height, (number + 40).toString());
                rowNode.setAttributeValue(ExcelConstants.ATTR_RowIndex, rowIndex.toString());
                rowsNode.addChild(rowNode);
                this.getView().getXmlEntity().update(rowNode, true);
                this.start = y
                this.endNode = rowNode
            } else {
                let rowNode = <ITagNode>row;
                let orgLength = rowNode.getAttributeValueInt(BaseConstants.ATTR_Height, EXCEL.D_ROW_HEIGHT);
                if (length > 0) {//缩小
                    if ((orgLength - number) > 10) {
                        let newLength = orgLength - number;
                        rowNode.setAttributeValue(BaseConstants.ATTR_Height, newLength.toString());
                        this.getView().getXmlEntity().update(rowNode, true);
                        this.start = y
                    }
                } else {//拉大
                    let newLength = orgLength + number;
                    rowNode.setAttributeValue(BaseConstants.ATTR_Height, newLength.toString());
                    this.getView().getXmlEntity().update(rowNode, true);
                    this.start = y
                }
                this.endNode = rowNode;
            }
            var selectionModel = this.getView().getXmlEntity().getSelectionModel();
            var selectSheetView = <SheetView>this.getView().getSelectSheetView();
            selectionModel.select(selectSheetView.getTagNode());
        } else if ("excel-dragRow" == ele.className && e.buttons != 1) {
            this.getDelegate().setRragRowState();
        } else if ("excel-dragColumn" == ele.className && e.buttons != 1) {
            this.getDelegate().setDragColumnState();
        } else if (ele.nodeName == "TH" && e.buttons != 1) {
            this.getDelegate().setExcelThEventState();
        } else if (e.buttons != 1) {
            this.getDelegate().setNormalState();
        }
    }

    mouseup(e: MouseEvent): void {
        super.mouseup(e);
        this.getView().initDragState(this.getView(),this.startNode!,this.endNode!)
    }


    getTagNode(): any {
        return this.tagNode;
    }

    seTagNode(value: any) {
        this.tagNode = value;
    }


    getEl(): any {
        return this.el;
    }

    setEl(value: any) {
        this.el = value;
    }

    getStart(): any {
        return this.start;
    }

    setStart(value: any) {
        this.start = value;
    }
}

