import AbstractExcelOptState from "./AbstractExcelOptState";
import SelectAreaState from "./SelectAreaState";
import SheetView from "../view/element/SheetView";
import {ExcelCellView} from "../view/element/ExcelCellView";
import SizeInfo from "../../../common/struct/SizeInfo";
import BaseConstants from "../../base/BaseConstants";


export default class NormalState extends AbstractExcelOptState {
    private startX = 0;
    private startY = 0;
    private el: any;

    mousedown(e: MouseEvent): void {
        var {x, y} = this.getPosition(e);
        var selectionModel = this.getView().getXmlEntity().getSelectionModel();
        var singleSeletionItem = this.getView().getXmlEntity().getSelectionModel().getSingleSeletionItem()
        var iTagNodes = this.getView().getXmlEntity().getSelectionModel().doCacheTagNodes();
        var length = iTagNodes.length;
        this.el = <HTMLElement>e.target;
        this.startX = Number(this.el.getAttribute("rowindex"));
        this.startY = Number(this.el.getAttribute("colindex"));
        var selectSheetView = <SheetView>this.getView().getSelectSheetView();
        var hitMultiTagNode = <ExcelCellView>this.getView().hitMultiTagNode(x, y);

        if (!hitMultiTagNode) {
            hitMultiTagNode = <ExcelCellView>selectSheetView.getChildNode(this.startX, this.startY);
        }
        var rowindex = hitMultiTagNode!.getRowIndex();
        var colindex = hitMultiTagNode!.getColIndex();
        var megerHeadRowindex = hitMultiTagNode.getMegerHeadRowindex();
        var megerHeadColindex = hitMultiTagNode.getMegerHeadColindex();
        var startTagNode = hitMultiTagNode?.getTagNode();
        var rowSpan = startTagNode!.getAttributeValueInt(BaseConstants.ATTR_RowSpan, 0);
        var colSpan = startTagNode!.getAttributeValueInt(BaseConstants.ATTR_ColSpan, 0);

        var childNode = <ExcelCellView>selectSheetView.getChildNode(this.startX, this.startY);
        this.getView().reloadSelectExcelView();
        this.getView().selectExcelView(childNode);

        if (megerHeadRowindex > 0 || megerHeadColindex > 0) {//
            var childHeadNode = <ExcelCellView>selectSheetView.getChildNode(megerHeadRowindex, megerHeadColindex);//ͷ
            var headTagNode = childHeadNode?.getTagNode();
            rowindex = childHeadNode.getRowIndex();
            colindex = childHeadNode.getColIndex();
            var headRowSpan = headTagNode!.getAttributeValueInt(BaseConstants.ATTR_RowSpan, 0);
            var headColSpan = headTagNode!.getAttributeValueInt(BaseConstants.ATTR_ColSpan, 0);
            var array: any[];
            //  array.push(childHeadNode);
            if (headRowSpan > 0 && headColSpan == 0) {
                array = new Array();
                array.push(childNode);
                for (let j = colindex; j <= colindex + headColSpan; j++) {
                    for (let i = rowindex; i < rowindex + headRowSpan; i++) {
                        var item0 = <ExcelCellView>selectSheetView.getChildNode(i, j);
                        if (array.indexOf(item0) != -1) {
                            continue;
                        }
                        if (item0) {
                            array.push(item0);
                        }
                    }
                }

            } else if (headRowSpan == 0 && headColSpan > 0) {
                array = new Array();
                array.push(childNode);
                for (let j = colindex; j < colindex + headColSpan; j++) {
                    for (let i = rowindex; i <= rowindex + headRowSpan; i++) {
                        var item0 = <ExcelCellView>selectSheetView.getChildNode(i, j);
                        if (array.indexOf(item0) != -1) {
                            continue;
                        }
                        if (item0) {
                            array.push(item0);
                        }
                    }
                }

            } else {
                array = new Array();
                array.push(childNode);
                for (let j = colindex; j < colindex + headColSpan; j++) {
                    for (let i = rowindex; i < rowindex + headRowSpan; i++) {
                        var item0 = <ExcelCellView>selectSheetView.getChildNode(i, j);
                        if (array.indexOf(item0) != -1) {
                            continue;
                        }
                        if (item0) {
                            array.push(item0);
                        }
                    }
                }

            }
            if ((e.button == 0 && length == array.length &&
                    singleSeletionItem?.isSelected() &&
                    childNode.getTagNode() == iTagNodes[0]?.getTagNode())
                || (e.button == 0 && this.startX == childNode!.getTagNode()!.getAttributeValueInt("rowindex", 0) &&
                    this.startY == childNode!.getTagNode()!.getAttributeValueInt("colindex", 0) &&
                    childNode.getTagNode()?.isSelected() && length == array.length)) {
                var childNode1 = selectSheetView.getChildCell(this.startX, this.startY);
                var height = SizeInfo.valueOfPX(Number($(childNode1.el).height()));
                var width = SizeInfo.valueOfPX(Number($(childNode1.el).width()));
                childNode.setStyle("display", "none");
                var childNode2 = selectSheetView.getChildNode(this.startX, this.startY);
                var textEditor = childNode2!.getTextEditor();
                textEditor.setStyle("display", "block");
                textEditor.setStyle("width", width);
                textEditor.setStyle("height", "100%")
                textEditor.setStyle("min-height", height)
                textEditor.setStyle("disabled", "true");
                setTimeout(function () {
                    var text = childNode.getAttr("value");
                    textEditor.setValue(text);
                    textEditor.getEl().focus();
                }, 10);

            } else {

                selectionModel.setBMultiSelection(true);
                selectionModel.unMultiSelection();
                selectionModel.setBMultiSelection(false);
                selectionModel.select(array[0].getTagNode());
                selectionModel.setBMultiSelection(true);
                for (let i = 1; i < array.length; i++) {
                    selectionModel.select(array[i].getTagNode());
                }
                selectionModel.setBMultiSelection(false);
            }

        } else if (rowSpan > 0 || colSpan > 0) {//ͷ
            var array: any[];
            if (rowSpan > 0 && colSpan == 0) {
                array = new Array();
                array.push(childNode);
                for (let j = colindex; j <= colindex + colSpan; j++) {
                    for (let i = rowindex; i < rowindex + rowSpan; i++) {
                        var item0 = <ExcelCellView>selectSheetView.getChildNode(i, j);
                        if (array.indexOf(item0) != -1) {
                            continue;
                        }
                        if (item0) {
                            array.push(item0);
                        }
                    }
                }
            } else if (rowSpan == 0 && colSpan > 0) {
                array = new Array();
                array.push(childNode);
                for (let j = colindex; j < colindex + colSpan; j++) {
                    for (let i = rowindex; i <= rowindex + rowSpan; i++) {
                        var item0 = <ExcelCellView>selectSheetView.getChildNode(i, j);
                        if (array.indexOf(item0) != -1) {
                            continue;
                        }
                        if (item0) {
                            array.push(item0);
                        }
                    }
                }
            } else {
                array = new Array();
                array.push(childNode);
                // array.push(hitMultiTagNode);
                for (let j = colindex; j < colindex + colSpan; j++) {
                    for (let i = rowindex; i < rowindex + rowSpan; i++) {
                        var item0 = <ExcelCellView>selectSheetView.getChildNode(i, j);
                        if (array.indexOf(item0) != -1) {
                            continue;
                        }
                        if (item0) {
                            array.push(item0);
                        }
                    }
                }
            }


            if ((e.button == 0 && length == array.length && singleSeletionItem?.isSelected() && childNode.getTagNode() == iTagNodes[0]?.getTagNode()) || (e.button == 0 && this.startX == childNode!.getTagNode()!.getAttributeValueInt("rowindex", 0) &&
                this.startY == childNode!.getTagNode()!.getAttributeValueInt("colindex", 0) && childNode.getTagNode()?.isSelected() && length == array.length)) {
                var childNode1 = selectSheetView.getChildCell(this.startX, this.startY);
                var height = SizeInfo.valueOfPX(Number($(childNode1.el).height()));
                var width = SizeInfo.valueOfPX(Number($(childNode1.el).width()));
                childNode.setStyle("display", "none");
                var childNode2 = selectSheetView.getChildNode(this.startX, this.startY);
                var textEditor = childNode2!.getTextEditor();
                textEditor.setStyle("display", "block");
                textEditor.setStyle("width", width);
                textEditor.setStyle("height", "100%")
                textEditor.setStyle("min-height", height)
                textEditor.setStyle("disabled", "true");
                setTimeout(function () {
                    var text = childNode.getAttr("value");
                    textEditor.setValue(text);
                    textEditor.getEl().focus();
                }, 10);
            } else {
                selectionModel.setBMultiSelection(true);
                selectionModel.unMultiSelection();
                selectionModel.setBMultiSelection(false);
                selectionModel.select(array[0].getTagNode());
                selectionModel.setBMultiSelection(true);
                for (let i = 1; i < array.length; i++) {
                    selectionModel.select(array[i].getTagNode());
                }
                selectionModel.setBMultiSelection(false);
            }
        } else {
            if ((e.button == 0 && childNode.getTagNode() == singleSeletionItem && singleSeletionItem?.isSelected() && length == 1) ||
                (e.button == 0 && this.startX == childNode!.getTagNode()!.getAttributeValueInt("rowindex", 0) &&
                    this.startY == childNode!.getTagNode()!.getAttributeValueInt("colindex", 0) && childNode.getTagNode()?.isSelected() && length == 1)) {//�ٴε������༭״̬
                var childNode1 = selectSheetView.getChildCell(this.startX, this.startY);
                var height = SizeInfo.valueOfPX(Number($(childNode1.el).height()));
                var width = SizeInfo.valueOfPX(Number($(childNode1.el).width()));
                childNode.setStyle("display", "none");
                var childNode2 = selectSheetView.getChildNode(this.startX, this.startY);
                var textEditor = childNode2!.getTextEditor();
                textEditor.setStyle("display", "block");
                textEditor.setStyle("width", width);
                textEditor.setStyle("height", "100%")
                textEditor.setStyle("min-height", height)
                textEditor.setStyle("disabled", "true");
                setTimeout(function () {
                    var text = childNode.getAttr("value");
                    textEditor.setValue(text);
                    textEditor.getEl().focus();
                }, 10);

            } else {
                selectionModel.setBMultiSelection(true);
                selectionModel.unMultiSelection();
                selectionModel.setBMultiSelection(false);
                selectionModel.select(childNode.getTagNode());
            }
        }

    }

    mousemove(e: MouseEvent): void {
        var target = <HTMLElement>e.target;
        if (target.nodeName == "IMG" && target.className == 'selected-td-img') {
            this.getDelegate().setExcelImgClickState();
        } else if (target.nodeName == "TH") {
            this.getDelegate().setExcelThEventState();
        } else if (e.button == 0 && e.buttons == 1) {
            var x = Number(target.getAttribute("rowindex"));
            var y = Number(target.getAttribute("colindex"));
            if (Math.abs(this.startX - x) > 0 || Math.abs(this.startY - y) > 0) {
                var selectionModel = this.getView().getXmlEntity().getSelectionModel();
                selectionModel.setBMultiSelection(true);
                var selectAreaState = new SelectAreaState(this.getDelegate());
                selectAreaState.setStartX(this.startX);
                selectAreaState.setStartY(this.startY);
                this.getDelegate().setSelectAreaState(selectAreaState);
            }

        }
    }


    mouseup(e: MouseEvent): void {
        var selectionModel = this.getView().getXmlEntity().getSelectionModel();
        selectionModel.setBMultiSelection(false);
        this.reset();
    }

}
