import ExcelGraphicView from "../view/ExcelGraphicView";
import AbstractOptStateDelegate from "../../../common/state/AbstractOptStateDelegate";
import NormalState from "./NormalState";
import SelectAreaState from "./SelectAreaState";
import ExcelImgClickState from "./ExcelImgClickState";
import InputState from "./InputState";
import ExcelThEventState from "./ExcelThEventState";
import RragRowState from "./RragRowState";
import DragColumnState from "./DragColumnState";

export default class ExcelOptStateDelegate extends AbstractOptStateDelegate<ExcelGraphicView> {
    private normalState: NormalState;
    private excelImgClickState: ExcelImgClickState;
    private thEventState: ExcelThEventState;

    private inputState: InputState;
    private ragRowState: RragRowState;
    private dragColumnState: DragColumnState;

    constructor(view: ExcelGraphicView) {
        super(view);
        this.normalState = new NormalState(this);
        this.excelImgClickState = new ExcelImgClickState(this);
        this.inputState = new InputState(this);
        this.thEventState = new ExcelThEventState(this);
        this.ragRowState = new RragRowState(this);
        this.dragColumnState = new DragColumnState(this);

        this.setInitState(this.normalState);
    }

    setSelectAreaState(selectAreaState:SelectAreaState): void {
        this.setCurrentState(selectAreaState);
    }
    setExcelImgClickState(): void {
        this.setCurrentState(this.excelImgClickState);
    }
    setExcelThEventState(): void {
        this.setCurrentState(this.thEventState);
    }
    setNormalState(): void {
        this.setCurrentState(this.normalState);
    }
    setInputState(): void {
        this.setCurrentState(this.inputState);
    }
    setRragRowState(): void {
        this.setCurrentState(this.ragRowState);
    }
    setDragColumnState(): void {
        this.setCurrentState(this.dragColumnState);
    }
}