import AbstractExcelOptState from "./AbstractExcelOptState";
import SheetView from "../view/element/SheetView";
import {ExcelCellView} from "../view/element/ExcelCellView";
import ExcelWorkSpace from "../ExcelWorkSpace";
import OperationDispatcher from "../../../common/operation/OperationDispatcher";

export default class ExcelImgClickState extends AbstractExcelOptState {
    private startX = 0;
    private startY = 0;
    private el: any;
    mousedown(e: MouseEvent): void {
        super.mousedown(e);

        this.el = <HTMLElement>e.target;
        this.startX = Number(this.el.offsetParent.getAttribute("rowindex"))
        this.startY = Number(this.el.offsetParent.getAttribute("colindex"))
        var selectSheetView = <SheetView>this.getView().getSelectSheetView();
        var childNode = <ExcelCellView>selectSheetView.getChildNode(this.startX, this.startY);
        this.getView().reloadSelectExcelView();
        this.getView().selectExcelView(childNode);
        this.getView().getXmlEntity().getSelectionModel().select(childNode.getTagNode());
        var {x, y} = this.getPosition(e);
       console.log("你点击了图片")
    }

    mousemove(e: MouseEvent): void {
        var target = <HTMLElement>e.target;
        if (target.nodeName != "IMG" || target.className != 'selected-td-img') {
            this.getDelegate().setNormalState();
        }
    }


    mouseup(e: MouseEvent): void {
        super.mouseup(e);
        var {x, y} = this.getPosition(e);
        console.log("你点击了图片")
    }
}