import IXmlEntity from "../../../common/xml/IXmlEntity";
import IPropertyItem from "../../plugin/property/base/PropertyDefine";
import PropertyIO from "../../plugin/property/base/PropertyIO";
import ITagNode from "../../../common/xml/node/ITagNode";
import {XMLElementType} from "../../../common/enum/Enums";
import ExcelConstants from "../../excel/base/ExcelConstants";
import TagNode from "../../../common/xml/node/TagNode";
import ExcelGraphicView from "../view/ExcelGraphicView";
import SheetView from "../view/element/SheetView";
import ExcelPropertyDefine from "../base/ExcelPropertyDefine";
import BaseConstants from "../../base/BaseConstants";
import StringUtil from "../../../common/util/StringUtil";
import PrintNodeCheckUtil from "../../print/util/PrintNodeCheckUtil";

export class ExcelPropertyIO extends PropertyIO {
    private excelGraphicView: ExcelGraphicView
    private xmlEntity: IXmlEntity

    constructor(xmlEntity: IXmlEntity, excelGraphicView: ExcelGraphicView) {
        super(xmlEntity);
        this.xmlEntity = xmlEntity;
        this.excelGraphicView = excelGraphicView
    }

    setValue(propertyItem: IPropertyItem, propertyValue: any): void {
        var crateNode = true;
        if (propertyItem.defaultvalue === propertyValue) {
            crateNode = false;
        }
        var propertyNode = this.ensureProertyNode(propertyItem, <ITagNode>this.curTagNode, crateNode, propertyValue);
        if (propertyNode) {
            var oldValue = "";
            if (propertyItem.type === "CDATA") {
                var child = propertyNode.getChild(propertyItem.key);
                if (child == null) {
                    oldValue = '无属性';
                } else {
                    oldValue = child.getCDATAValue();
                }
            } else {
                oldValue = propertyNode!.getAttributeValue(propertyItem.key, '无属性')
            }
            const pattern = /[:\\/?\*|\[\]]/;
            let length = propertyValue.length;
            if (propertyNode.getTagName() == ExcelConstants.NODE_Sheet &&
                (!propertyValue || length > 31 || pattern.test(propertyValue) ||
                    propertyValue[0] == "'" || propertyValue[length - 1] == "'") ||
                (propertyNode.getParent() && propertyNode.getParent()!.find(ExcelConstants.NODE_Sheet, ExcelConstants.ATTR_Name, propertyValue))
            ) {
                propertyValue = oldValue;
                // @ts-ignore
                layui.layer.msg(`在重命名工作表时输入的名称无效。请尝试以下操作:</br>确认输入的名称不多于31个字符。</br>确认名称中不包含以下字符: :\\/?*[或]。</br>确认名称的第一个或者最后一个字符不能是单引号。</br>确认工作表名称不为空。</br>确认工作表名称不重复。`, {
                    icon: 5,
                    time: 5000,
                })
            }

            if (oldValue === "无属性") {
                if (propertyItem.defaultvalue === propertyValue) {
                    this.excelGraphicView.loadSheetView(this.xmlEntity);
                    if (propertyItem.tag == ExcelConstants.NODE_Cell) {
                        this.xmlEntity.select(<ITagNode>this.excelGraphicView.getSelectExcelView().getTagNode());
                    }
                    return;
                }
            } else {
                if (oldValue === propertyValue) {
                    this.excelGraphicView.loadSheetView(this.xmlEntity);
                    if (propertyItem.tag == ExcelConstants.NODE_Cell) {
                        this.xmlEntity.select(<ITagNode>this.excelGraphicView.getSelectExcelView().getTagNode());
                    }
                    return;
                }
            }
            var tagNode = PropertyIO.setPropertyValue(propertyNode, propertyItem, propertyValue);
            this.excelGraphicView.loadSheetView(this.xmlEntity);
            if (propertyItem.tag == ExcelConstants.NODE_Cell) {
                tagNode && this.xmlEntity.select(<ITagNode>this.excelGraphicView.getSelectExcelView().getTagNode());
            }
        } else {
            var oldValue = "";
            if (propertyItem.type === "CDATA") {
                var child = this.curTagNode!.getChild(propertyItem.key);
                if (child == null) {
                    oldValue = '无属性';
                } else {
                    oldValue = child.getCDATAValue();
                }
            } else {
                oldValue = this.curTagNode!.getAttributeValue(propertyItem.key, '无属性')
            }
            if (oldValue === "无属性") {
                if (propertyItem.defaultvalue === propertyValue) {
                    return;
                }
            } else {
                if (oldValue === propertyValue) {
                    return;
                }
            }
            PropertyIO.setPropertyValue(this.curTagNode, propertyItem, propertyValue);
            super.setValue(propertyItem, propertyValue);
            var rowIndex = this.excelGraphicView.getSelectExcelView().getRowIndex();
            var colIndex = this.excelGraphicView.getSelectExcelView().getColIndex();
            var selectSheetView = <SheetView>this.excelGraphicView.getSelectSheetView();
            if (propertyItem.tag == ExcelConstants.NODE_Sheet && propertyItem.key == ExcelConstants.ATTR_Name) {
                this.excelGraphicView.setSelectSheetViewName(propertyValue);
                this.excelGraphicView.loadSheetView(this.xmlEntity);
            } else {
                this.excelGraphicView.loadSheetView(this.xmlEntity);
                var sheetNode = selectSheetView.getTagNode();
                var tagNode1 = this.excelGraphicView.getSelectExcelView().getTagNode();
                var rows = sheetNode.getChild(ExcelConstants.NODE_Rows);
                var find;
                if (tagNode1?.getParent()) {
                    var row = rows!.find(ExcelConstants.NODE_Row, ExcelConstants.ATTR_RowIndex, String(rowIndex + 1));
                    find = row?.find(BaseConstants.Node_Cell, ExcelConstants.ATTR_CellIndex, String(colIndex + 1));
                }
                if (find) {//找到
                    this.xmlEntity.select(find);
                } else {
                    this.xmlEntity.select(this.curTagNode);
                }
            }

        }

    }

    getValue(propertyItem: IPropertyItem): any {
        var tagNode = this.ensureProertyNode(propertyItem, <ITagNode>this.curTagNode, false, "");
        if (tagNode) {
            var text = tagNode.getAttributeValue(propertyItem.textAttributeKey);
            switch (propertyItem.type) {
                case XMLElementType.ATTRIBUTE:
                    if (tagNode.hasAttribute(propertyItem.key)) {
                        return tagNode.getAttributeValue(propertyItem.key);
                    } else {
                        if (!text) {
                            return propertyItem.defaultvalue ? propertyItem.defaultvalue : "";
                        } else {
                            return text;
                        }
                    }
                case XMLElementType.CDATA:
                    var tmpNode = tagNode.getChild(propertyItem.key);
                    return tmpNode ? tmpNode.getCDATAValue() : "";
                case XMLElementType.COLLECTION:
                    var collection = tagNode.ensureChild(propertyItem.key);
                    return collection;
            }
        } else {
            return super.getValue(propertyItem);

        }
    }


    private ensureProertyNode(propertyItem: IPropertyItem, curTagNode: ITagNode, crater: boolean, propertyValue: string): ITagNode | null {
        var tagNode = null;
        if (propertyItem.tag == curTagNode.getTagName() && curTagNode.getTagName() == ExcelConstants.NODE_Cell) {//本身处理
            if (!curTagNode.getParent()) {
                if (crater) {
                    var selectSheetView = <SheetView>this.excelGraphicView.getSelectSheetView();
                    var rowindex = String(curTagNode.getAttributeValueInt(ExcelConstants.ATTR_rowindex, 0) + 1);
                    var colindex = String(curTagNode.getAttributeValueInt(ExcelConstants.ATTR_colindex, 0) + 1);
                    var iTagNode = selectSheetView.getTagNode().ensureChild(ExcelConstants.NODE_Rows).find(ExcelConstants.NODE_Row, ExcelConstants.ATTR_RowIndex, rowindex);
                    var iParentNode = iTagNode;
                    if (!iTagNode) {
                        iParentNode = new TagNode(ExcelConstants.NODE_Row);
                        iParentNode.setAttributeValue(ExcelConstants.ATTR_RowIndex, rowindex);
                        selectSheetView.getTagNode().ensureChild(ExcelConstants.NODE_Rows).addChild(iParentNode);
                    }
                    var tagNode1 = new TagNode(ExcelConstants.NODE_Cell);
                    tagNode1.setAttributeValue(ExcelConstants.ATTR_CellIndex, colindex);
                    if (!iParentNode!.find(ExcelConstants.NODE_Cell, ExcelConstants.ATTR_CellIndex, colindex)) {
                        switch (propertyItem.type) {
                            case XMLElementType.ATTRIBUTE:
                                if (propertyItem.defaultvalue == propertyValue) {
                                    tagNode1.removeAttribute(propertyItem.key);
                                } else {
                                    tagNode1.setAttributeValue(propertyItem.key, propertyValue);
                                }
                                break;
                            case XMLElementType.CDATA:
                                var tmpNode = tagNode1.ensureChild(propertyItem.key);
                                tmpNode.setCDATAValue(propertyValue);
                                break;
                            case XMLElementType.COLLECTION:
                                // 集合类型的属性，情况比较复杂，直接在外部通过公式根据具体情况去设置
                                //var collection = tagNode.getChild(propertyItem.key);
                                break;
                        }
                        iParentNode!.addChild(tagNode1)
                    }
                    tagNode = tagNode1;
                    this.excelGraphicView.getSelectExcelView().setTagCell(tagNode1);
                    this.curTagNode = tagNode1;
                }

            }
        }

        if (propertyItem.tag != curTagNode.getTagName() && propertyItem.tag == ExcelConstants.NODE_Column && curTagNode.getTagName() == ExcelConstants.NODE_Cell) {//列处理
            if (curTagNode.getParent()) {//说明界面存在的且Xml也存在的节点
                var child = curTagNode.getParent()!.getParent()!.getParent()?.getChild(ExcelConstants.ATTR_Columns);
                if (child == null) {
                    child = new TagNode(ExcelConstants.ATTR_Columns);
                    if (crater) {
                        curTagNode.getParent()!.getParent()!.getParent()?.addChild(child);
                    }
                }
                var findTmpNode = child!.find(propertyItem.tag, ExcelConstants.ATTR_ColumnIndex, curTagNode.getAttributeValue(ExcelConstants.ATTR_CellIndex));
                if (findTmpNode) {//找到
                    tagNode = findTmpNode;
                } else {//未找到列
                    var node = new TagNode(ExcelConstants.NODE_Column);
                    node.setAttributeValue(ExcelConstants.ATTR_ColumnIndex, curTagNode.getAttributeValue(ExcelConstants.ATTR_CellIndex))
                    if (crater) {
                        if (!child!.find(ExcelConstants.NODE_Column, ExcelConstants.ATTR_ColumnIndex, curTagNode.getAttributeValue(ExcelConstants.ATTR_CellIndex))) {
                            child!.addChild(node);
                        }
                    }
                    tagNode = node;
                }

            } else {//界面存在,xml不存在
                var selectSheetView1 = <SheetView>this.excelGraphicView.getSelectSheetView();
                var tagNode2 = selectSheetView1.getTagNode();
                var value = String(curTagNode.getAttributeValueInt(ExcelConstants.ATTR_colindex, 0) + 1);
                var find = tagNode2.find(propertyItem.tag, ExcelConstants.ATTR_ColumnIndex, value);
                if (find) {//找到
                    tagNode = find;
                } else {//未找到伪造一个显示列号
                    var node = new TagNode(ExcelConstants.NODE_Column);
                    node.setAttributeValue(ExcelConstants.ATTR_ColumnIndex, value)
                    if (crater) {
                        var selectSheetView = <SheetView>this.excelGraphicView.getSelectSheetView();
                        var iTagNode1 = selectSheetView.getTagNode().ensureChild(ExcelConstants.ATTR_Columns);
                        if (!iTagNode1!.find(ExcelConstants.NODE_Column, ExcelConstants.ATTR_ColumnIndex, value)) {
                            iTagNode1!.addChild(node);
                        }
                    }
                    tagNode = node;
                }
            }
        }
        if (propertyItem.tag != curTagNode.getTagName() && propertyItem.tag == ExcelConstants.NODE_Row && curTagNode.getTagName() == ExcelConstants.NODE_Cell) {//行处理
            if (!curTagNode.getParent()) {//界面存在,xml不存在
                var selectSheetView1 = <SheetView>this.excelGraphicView.getSelectSheetView();
                var tagNode2 = selectSheetView1.getTagNode();
                var value1 = String(curTagNode.getAttributeValueInt(ExcelConstants.ATTR_rowindex, 0) + 1);
                var find = tagNode2.find(propertyItem.tag, ExcelConstants.ATTR_RowIndex, value1);
                if (find) {//找到
                    tagNode = find;
                } else {//未找到伪造一个显示列号
                    var node = new TagNode(ExcelConstants.NODE_Row);
                    node.setAttributeValue(ExcelConstants.ATTR_RowIndex, value1)
                    if (crater) {
                        var selectSheetView = <SheetView>this.excelGraphicView.getSelectSheetView();
                        var iTagNode1 = selectSheetView.getTagNode().ensureChild(ExcelConstants.NODE_Rows);
                        if (!iTagNode1!.find(ExcelConstants.NODE_Row, ExcelConstants.ATTR_RowIndex, value1)) {
                            iTagNode1!.addChild(node);
                        }
                    }
                    tagNode = node;
                }
            } else {
                tagNode = <ITagNode>curTagNode.getParent();
            }
        }
        if (propertyItem.tag != curTagNode.getTagName() && propertyItem.tag == ExcelConstants.NODE_Sheet && curTagNode.getTagName() == ExcelConstants.NODE_Cell) {//页处理
            var selectSheetViewName = this.excelGraphicView.getSelectSheetViewName();
            var find = this.xmlEntity.getTagRoot().find(ExcelConstants.NODE_Sheet, ExcelConstants.ATTR_Name, selectSheetViewName);
            if (find) {//找到
                tagNode = find;
            }
        }
        return tagNode;
    }

}