import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import TagNode from "../../../common/xml/node/TagNode";
import ExcelGraphicView from "../view/ExcelGraphicView";
import {CellView} from "../../print/view/element/CellView";
import {ExcelCellView} from "../view/element/ExcelCellView";
import BaseConstants from "../../base/BaseConstants";
import ExcelConstants from "../base/ExcelConstants";
import Var from "../../../common/struct/Var";
import SheetView from "../view/element/SheetView";


export default class SetStyleBorderCmd implements ICmd {
    private iTagNodes: ITagNode[];
    private xmlEntity: IXmlEntity;
    private styleBorder: string;
    private borderColor: string;
    private borderStyle: string;
    private alignmentOldValue: string[][];
    private oldITagNodes?: ITagNode[];
    private newITagNodes?: ITagNode[];
    private selectTagNodes?: ITagNode[];
    private newTagNodes?: ITagNode[];
    private alignmentType: string[];
    private excelGraphicView: ExcelGraphicView;
    private tagName: string;

    constructor(excelGraphicView: ExcelGraphicView, tagName: string, xmlEntity: IXmlEntity, tagNode: ITagNode[], styleBorder: string, borderColor: string, borderStyle: string, alignmentOldValue: string[][], alignmentType: string[]) {
        this.xmlEntity = xmlEntity;
        this.iTagNodes = tagNode;
        this.styleBorder = styleBorder;
        this.borderColor = borderColor;
        this.borderStyle = borderStyle;
        this.alignmentType = alignmentType;
        this.excelGraphicView = excelGraphicView;
        this.alignmentOldValue = alignmentOldValue;
        this.tagName = tagName;
    }

    do(): boolean {
        if (this.iTagNodes.length == 0) {
            return true;
        }
        let fristCell = <ExcelCellView>this.excelGraphicView.getSelectSheetView()!.findChildNode(this.iTagNodes[0]);
        let fristCol = fristCell.getColIndex() + 1;
        let fristRow = fristCell.getRowIndex() + 1;
        let endCol = fristCol;
        let endRow = fristRow;
        //第一个选中的格子不是选中区域的第一格
        if (this.iTagNodes.length != 1) {
            for (let i = 0; i < this.iTagNodes.length; i++) {
                let nodeCell = <ExcelCellView>this.excelGraphicView.getSelectSheetView()!.findChildNode(this.iTagNodes[i]);
                let colIndex = nodeCell.getColIndex() + 1;
                let rowIndex = nodeCell.getRowIndex() + 1;
                if (colIndex <= fristCol && rowIndex <= fristRow) {
                    fristCol = colIndex;
                    fristRow = rowIndex;
                }
                if (colIndex >= endCol && rowIndex >= endRow) {
                    endCol = colIndex;
                    endRow = rowIndex;
                }
            }
        }
        for (let i = 0; i < this.iTagNodes.length; i++) {
            var tagNode: ITagNode | undefined = this.iTagNodes[i];//cellNode
            if (this.tagName == "" || tagNode.getTagName() != "Cell") {
            } else {
                let isModify = false;
                this.oldITagNodes = this.oldITagNodes || []
                this.newITagNodes = this.newITagNodes || []
                this.selectTagNodes = this.selectTagNodes || []
                this.newTagNodes = this.newTagNodes || []
                let colIndex = 0;
                let rowIndex = 0;
                if (tagNode.getParent()) {
                    rowIndex = tagNode.getParent()!.getAttributeValueInt("RowIndex", 0);
                    colIndex = tagNode.getAttributeValueInt("CellIndex", 0);
                } else {
                    rowIndex = tagNode.getAttributeValueInt("rowindex", 0) + 1;
                    colIndex = tagNode.getAttributeValueInt("colindex", 0) + 1;
                }
                var split = this.tagName.split(";");
                let sheetView = <SheetView>this.excelGraphicView.getSelectSheetView();
                var sheetNode = sheetView.getTagNode();
                if (!tagNode.getParent()) {
                    let rowsNode = <ITagNode>sheetNode.ensureChild(ExcelConstants.NODE_Rows);
                    let targetRowNode = rowsNode.find(ExcelConstants.NODE_Row, ExcelConstants.ATTR_RowIndex, String(rowIndex));
                    if (targetRowNode) {
                        tagNode = targetRowNode.find(ExcelConstants.NODE_Cell,ExcelConstants.ATTR_CellIndex,String(colIndex));
                        if (!tagNode) {
                            tagNode = this.excelGraphicView.getXmlEntity().getNodeFactory().createTagNode(ExcelConstants.NODE_Cell)
                            tagNode.setAttributeValue(ExcelConstants.ATTR_CellIndex, colIndex.toString());
                            tagNode.setParent(targetRowNode);
                            targetRowNode.addChild(tagNode);
                            this.newTagNodes.push(tagNode);
                        }
                    } else {
                        targetRowNode = this.excelGraphicView.getXmlEntity().getNodeFactory().createTagNode(ExcelConstants.NODE_Row)
                        targetRowNode.setAttributeValue("RowIndex", rowIndex.toString());
                        targetRowNode.setParent(rowsNode);
                        rowsNode.addChild(targetRowNode);
                        tagNode = this.excelGraphicView.getXmlEntity().getNodeFactory().createTagNode(ExcelConstants.NODE_Cell)
                        tagNode.setAttributeValue("CellIndex", colIndex.toString());
                        tagNode.setParent(targetRowNode);
                        targetRowNode.addChild(tagNode);
                        this.newTagNodes.push(tagNode);
                    }


                }
                this.selectTagNodes?.push(tagNode);
                let mergedColumnSpan = tagNode.getAttributeValue("MergedColumnSpan");
                let mergedRowSpan = tagNode.getAttributeValue("MergedRowSpan");
                for (let j = 0; j < split.length; j++) {
                    tagNode = tagNode!.ensureChild(split[j]);
                }
                this.oldITagNodes.push(tagNode);
                switch (this.borderStyle) {
                    case "0"://全边框
                        for (let j = 0; j < 4; j++) {
                            tagNode.setAttributeValue(this.alignmentType[j], this.borderColor);
                        }
                        for (let i = 4; i < this.alignmentType.length; i++) {
                            tagNode.setAttributeValue(this.alignmentType[i], this.styleBorder);
                        }
                        isModify = true;
                        break;
                    case "1"://无边框
                        this.removeAllBorder(tagNode);
                        isModify = true;
                        break;
                    case "2"://全外边框
                        this.removeAllBorder(tagNode);
                        isModify = true;
                        if (this.iTagNodes.length == 1) {
                            tagNode.setAttributeValue(this.alignmentType[0], this.borderColor);
                            tagNode.setAttributeValue(this.alignmentType[4], this.styleBorder);//上边框
                            tagNode.setAttributeValue(this.alignmentType[2], this.borderColor);
                            tagNode.setAttributeValue(this.alignmentType[6], this.styleBorder);//左边框
                            tagNode.setAttributeValue(this.alignmentType[1], this.borderColor);
                            tagNode.setAttributeValue(this.alignmentType[5], this.styleBorder);//下边框
                            tagNode.setAttributeValue(this.alignmentType[3], this.borderColor);
                            tagNode.setAttributeValue(this.alignmentType[7], this.styleBorder);//右边框
                        } else if (colIndex == fristCol && rowIndex == fristRow) {
                            tagNode.setAttributeValue(this.alignmentType[0], this.borderColor);
                            tagNode.setAttributeValue(this.alignmentType[4], this.styleBorder);//上边框
                            tagNode.setAttributeValue(this.alignmentType[2], this.borderColor);
                            tagNode.setAttributeValue(this.alignmentType[6], this.styleBorder);//左边框
                            if (fristRow == endRow) {//选中区域只有一行单元格或者一列
                                tagNode.setAttributeValue(this.alignmentType[1], this.borderColor);
                                tagNode.setAttributeValue(this.alignmentType[5], this.styleBorder);//下边框
                            } else if (fristCol == endCol) {
                                tagNode.setAttributeValue(this.alignmentType[3], this.borderColor);
                                tagNode.setAttributeValue(this.alignmentType[7], this.styleBorder);//右边框
                            }
                        } else if (colIndex == endCol && rowIndex === fristRow) {
                            tagNode.setAttributeValue(this.alignmentType[0], this.borderColor);
                            tagNode.setAttributeValue(this.alignmentType[4], this.styleBorder);//上边框
                            tagNode.setAttributeValue(this.alignmentType[3], this.borderColor);
                            tagNode.setAttributeValue(this.alignmentType[7], this.styleBorder);//右边框
                            if (fristRow == endRow) {
                                tagNode.setAttributeValue(this.alignmentType[1], this.borderColor);
                                tagNode.setAttributeValue(this.alignmentType[5], this.styleBorder);//下边框
                            }
                        } else if (colIndex == fristCol && rowIndex === endRow) {
                            tagNode.setAttributeValue(this.alignmentType[1], this.borderColor);
                            tagNode.setAttributeValue(this.alignmentType[5], this.styleBorder);//下边框
                            tagNode.setAttributeValue(this.alignmentType[2], this.borderColor);
                            tagNode.setAttributeValue(this.alignmentType[6], this.styleBorder);//左边框
                            if (fristCol == endCol) {
                                tagNode.setAttributeValue(this.alignmentType[3], this.borderColor);
                                tagNode.setAttributeValue(this.alignmentType[7], this.styleBorder);//右边框
                            }
                        } else if (colIndex == endCol && rowIndex === endRow) {
                            tagNode.setAttributeValue(this.alignmentType[1], this.borderColor);
                            tagNode.setAttributeValue(this.alignmentType[5], this.styleBorder);//下边框
                            tagNode.setAttributeValue(this.alignmentType[3], this.borderColor);
                            tagNode.setAttributeValue(this.alignmentType[7], this.styleBorder);//右边框
                        } else if (rowIndex == fristRow) {
                            tagNode.setAttributeValue(this.alignmentType[0], this.borderColor);
                            tagNode.setAttributeValue(this.alignmentType[4], this.styleBorder);//上边框
                            if (fristRow == endRow) {
                                tagNode.setAttributeValue(this.alignmentType[1], this.borderColor);
                                tagNode.setAttributeValue(this.alignmentType[5], this.styleBorder);//下边框
                            }
                        } else if (rowIndex == endRow) {
                            tagNode.setAttributeValue(this.alignmentType[1], this.borderColor);
                            tagNode.setAttributeValue(this.alignmentType[5], this.styleBorder);//下边框
                        } else if (colIndex == fristCol) {
                            tagNode.setAttributeValue(this.alignmentType[2], this.borderColor);
                            tagNode.setAttributeValue(this.alignmentType[6], this.styleBorder);//左边框
                            if (fristCol == endCol) {
                                tagNode.setAttributeValue(this.alignmentType[3], this.borderColor);
                                tagNode.setAttributeValue(this.alignmentType[7], this.styleBorder);//右边框
                            }
                        } else if (colIndex == endCol) {
                            tagNode.setAttributeValue(this.alignmentType[3], this.borderColor);
                            tagNode.setAttributeValue(this.alignmentType[7], this.styleBorder);//右边框
                        }
                        if (mergedColumnSpan && endCol == parseInt(mergedColumnSpan) + colIndex - 1) {
                            tagNode.setAttributeValue(this.alignmentType[3], this.borderColor);
                            tagNode.setAttributeValue(this.alignmentType[7], this.styleBorder);//右边框
                        }
                        if (mergedRowSpan && endRow == parseInt(mergedRowSpan) + rowIndex - 1) {
                            tagNode.setAttributeValue(this.alignmentType[1], this.borderColor);
                            tagNode.setAttributeValue(this.alignmentType[5], this.styleBorder);//下边框
                        }
                        break;
                    case "3"://左外边框
                        this.removeAllBorder(tagNode);
                        if (colIndex == fristCol) {
                            tagNode.setAttributeValue(this.alignmentType[2], this.borderColor);
                            tagNode.setAttributeValue(this.alignmentType[6], this.styleBorder);//左边框
                            isModify = true;
                        }
                        break;
                    case "4"://右外边框
                        this.removeAllBorder(tagNode);
                        if (colIndex == endCol) {
                            tagNode.setAttributeValue(this.alignmentType[3], this.borderColor);
                            tagNode.setAttributeValue(this.alignmentType[7], this.styleBorder);//右边框
                            isModify = true;
                        }
                        break;
                    case "5"://顶外边框
                        this.removeAllBorder(tagNode);
                        if (rowIndex == fristRow) {
                            tagNode.setAttributeValue(this.alignmentType[0], this.borderColor);
                            tagNode.setAttributeValue(this.alignmentType[4], this.styleBorder);//上边框
                            isModify = true;
                        }
                        break;
                    case "6"://底外边框
                        this.removeAllBorder(tagNode);
                        if (rowIndex == endRow) {

                            tagNode.setAttributeValue(this.alignmentType[1], this.borderColor);
                            tagNode.setAttributeValue(this.alignmentType[5], this.styleBorder);//下边框
                            isModify = true;
                        }
                        break;
                    case "7"://左边框
                        this.removeAllBorder(tagNode);
                        tagNode.setAttributeValue(this.alignmentType[2], this.borderColor);
                        tagNode.setAttributeValue(this.alignmentType[6], this.styleBorder);//左边框
                        isModify = true;
                        break;
                    case "8"://右边框
                        this.removeAllBorder(tagNode);
                        tagNode.setAttributeValue(this.alignmentType[3], this.borderColor);
                        tagNode.setAttributeValue(this.alignmentType[7], this.styleBorder);//右边框
                        isModify = true;
                        break;
                    case "9"://顶边框
                        this.removeAllBorder(tagNode);
                        tagNode.setAttributeValue(this.alignmentType[0], this.borderColor);
                        tagNode.setAttributeValue(this.alignmentType[4], this.styleBorder);//上边框
                        isModify = true;
                        break;
                    case "10"://底边框
                        this.removeAllBorder(tagNode);
                        tagNode.setAttributeValue(this.alignmentType[1], this.borderColor);
                        tagNode.setAttributeValue(this.alignmentType[5], this.styleBorder);//下边框
                        isModify = true;
                        break;

                }
                this.newITagNodes.push(tagNode);
                if (!isModify) {
                    this.newITagNodes.pop()
                    this.oldITagNodes.pop()
                }
            }
        }
        if (this.newITagNodes && this.newITagNodes!.length > 0 && this.selectTagNodes) {
            var selectionModel = this.xmlEntity.getSelectionModel();
            this.excelGraphicView.loadSheetView(this.excelGraphicView.getXmlEntity());
            selectionModel.setBMultiSelection(true);
            this.xmlEntity.getSelectionModel().unMultiSelection();
            selectionModel.setBMultiSelection(false);
            selectionModel.select(this.selectTagNodes[0]);
            selectionModel.setBMultiSelection(true);
            for (let i = 1; i < this.selectTagNodes.length; i++) {
                selectionModel.select(this.selectTagNodes[i]);
            }
            selectionModel.setBMultiSelection(false);
        }


        return true;
    }

    private removeAllBorder(tagNode: ITagNode): void {
        for (let j = 0; j < this.alignmentType.length; j++) {
            tagNode.removeAttribute(this.alignmentType[j]);
        }

    }

    undo(): void {
        if (this.iTagNodes.length <= 0 || !this.oldITagNodes || this.oldITagNodes.length <= 0) {
            return;
        }
        for (let i = 0; i < this!.newITagNodes!.length; i++) {
            var attributes = this!.newITagNodes![i]!.getAttributes();
            attributes.length = 0;
            for (let j = 0; j < this.oldITagNodes[i].getAttributes().length; j++) {
                attributes.push(this.oldITagNodes[i].getAttributes()[j]);
            }
        }
        if (this.newTagNodes) {
            for (let i = 0; i < this.newTagNodes.length; i++) {
                let iTagNode = <ITagNode>this.newTagNodes[i];
                let parent = iTagNode.getParent();
                parent?.removeChild(iTagNode);
            }
        }
        if (this.oldITagNodes && this.oldITagNodes!.length > 0) {
            var selectionModel = this.xmlEntity.getSelectionModel();
            this.excelGraphicView.loadSheetView(this.excelGraphicView.getXmlEntity());
            selectionModel.setBMultiSelection(true);
            this.xmlEntity.getSelectionModel().unMultiSelection();
            selectionModel.setBMultiSelection(false);
            selectionModel.select(this.iTagNodes[0]);
            selectionModel.setBMultiSelection(true);
            for (let i = 1; i < this.iTagNodes.length; i++) {
                selectionModel.select(this.iTagNodes[i]);
            }
            selectionModel.setBMultiSelection(false);
        }
    }
}