import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import SheetView from "../view/element/SheetView";

export default class SetImageValueCmd implements ICmd {
    private iTagNode: ITagNode;
    private xmlEntity: IXmlEntity;
    private alignmentValue: string;
    private alignmentOldValue?: string;
    private sheetView: SheetView;

    constructor(xmlEntity: IXmlEntity, tagNode: ITagNode, alignmentValue: string, sheetView: SheetView) {
        this.xmlEntity = xmlEntity;
        this.iTagNode = tagNode;
        this.alignmentValue = alignmentValue;
        this.sheetView = sheetView;
    }

    do(): boolean {
        this.alignmentOldValue = this.iTagNode.getAttributeValue("Definition", "");
        this.iTagNode.setAttributeValue("Definition", this.alignmentValue);
        var selectionModel = this.xmlEntity.getSelectionModel();
        selectionModel.select(this.sheetView.getTagNode());
        selectionModel.select(this.iTagNode);
        return true;
    }

    undo(): void {
        if (this.alignmentOldValue) {
            this.iTagNode.setAttributeValue("Definition", this.alignmentOldValue);
            var selectionModel = this.xmlEntity.getSelectionModel();
            selectionModel.select(this.sheetView.getTagNode());
            this.xmlEntity.getSelectionModel().select(this.iTagNode);
        }

    }
}
