import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import ExcelConstants from "../base/ExcelConstants";
import IExcelElementView from "../view/element/IExcelElementView";
import SheetView from "../view/element/SheetView";
import TagNode from "../../../common/xml/node/TagNode";
import ExcelNormalUtil from "../util/ExcelNormalUtil";

export default class SetAlignmentCmd implements ICmd {
    private iTagNodes: ITagNode[];
    private xmlEntity: IXmlEntity;
    private alignmentValue: string;
    private alignmentOldValue: string[];
    private alignmentType: string;
    private oldITagNodes?: ITagNode[];
    private newITagNodes?: ITagNode[];
    private tagName: string;
    private view: IExcelElementView;

    constructor(tagName: string, xmlEntity: IXmlEntity, tagNode: ITagNode[], alignmentValue: string, alignmentOldValue: string[], alignmentType: string, view: IExcelElementView) {
        this.xmlEntity = xmlEntity;
        this.iTagNodes = tagNode;
        this.alignmentValue = alignmentValue;
        this.alignmentType = alignmentType;
        this.alignmentOldValue = alignmentOldValue;
        this.tagName = tagName;
        this.view = view;
    }

    do(): boolean {
        for (let i = 0; i < this.iTagNodes.length; i++) {
            var tagNode: ITagNode | null = this.iTagNodes[i];
            var iTagNode: ITagNode | null = this.iTagNodes[i];
            if (this.tagName == "" || tagNode.getTagName() != "Cell") {
            } else {
                var split = this.tagName.split(";");
                for (let j = 0; j < split.length; j++) {
                    tagNode = tagNode!.ensureChild(split[j]);
                }
            }
            this.alignmentOldValue[i] = tagNode!.getAttributeValue(this.alignmentType);
            tagNode!.setAttributeValue(this.alignmentType, this.alignmentValue);
            this.newITagNodes = this.newITagNodes || [];
            if (!iTagNode.getParent()) {
                var rowindex = iTagNode.getAttributeValueInt(ExcelConstants.ATTR_rowindex, 0) + 1;
                var colindex = iTagNode.getAttributeValueInt(ExcelConstants.ATTR_colindex, 0) + 1;
                var view = <SheetView>this.view;
                var isDivisioncell = view.getChildNode(rowindex-1,colindex-1)!.getEl()!.parentElement!.classList.contains("divisioncell");
                if (isDivisioncell){
                    continue;
                }
                ExcelNormalUtil.scrollToNode(view,rowindex-1,colindex-1)
                iTagNode.removeAttribute(ExcelConstants.ATTR_rowindex);
                iTagNode.removeAttribute(ExcelConstants.ATTR_colindex);
                iTagNode.setAttributeValue(ExcelConstants.ATTR_CellIndex, String(colindex));

                var sheet = view.getTagNode();
                var rows = sheet.getChild(ExcelConstants.NODE_Rows);
                var row = rows?.find(ExcelConstants.NODE_Row, ExcelConstants.ATTR_RowIndex, String(rowindex));
                if (row) {
                    row.addChild(iTagNode);
                    this.newITagNodes.push(iTagNode);
                } else {
                    var Row = new TagNode(ExcelConstants.NODE_Row);
                    Row.setAttributeValue(ExcelConstants.ATTR_RowIndex, String(rowindex));
                    rows?.addChild(Row);
                    Row.addChild(iTagNode);
                    this.newITagNodes.push(Row);
                }
            }else {
                var rowindex = iTagNode.getParent()!.getAttributeValueInt(ExcelConstants.ATTR_RowIndex, 0) -1;
                var colindex = iTagNode.getAttributeValueInt(ExcelConstants.ATTR_CellIndex, 0) -1;
                    ExcelNormalUtil.scrollToNode(<SheetView>this.view,rowindex,colindex)

            }
        }
        if (this.alignmentOldValue && this.alignmentOldValue.length > 0) {
            var selectionModel = this.xmlEntity.getSelectionModel();
            var selectSheetView = <SheetView>this.view;
            selectionModel.select(selectSheetView.getTagNode());
            selectionModel.setBMultiSelection(true);
            this.xmlEntity.getSelectionModel().unMultiSelection();
            selectionModel.setBMultiSelection(false);
            selectionModel.select(this.iTagNodes[0]);
            selectionModel.setBMultiSelection(true);
            for (let i = 1; i < this.iTagNodes.length; i++) {
                selectionModel.select(this.iTagNodes[i]);
            }
            selectionModel.setBMultiSelection(false);
        }
        return true;
    }

    undo(): void {
        for (let i = 0; i < this.iTagNodes.length; i++) {
            var tagNode: ITagNode | null = this.iTagNodes[i];
            if (this.tagName == "" || tagNode.getTagName() != "Cell") {
            } else {
                var split = this.tagName.split(";");
                for (let j = 0; j < split.length; j++) {
                    tagNode = tagNode!.ensureChild(split[j]);
                }
            }
            tagNode!.setAttributeValue(this.alignmentType, this.alignmentOldValue[i]);
        }
        if (this.newITagNodes) {
            for (let i = 0; i < this.newITagNodes.length; i++) {
                var iTagNode = this.newITagNodes[i];
                var parent = iTagNode.getParent();
                parent?.removeChild(iTagNode);
            }
        }
        if (this.alignmentOldValue && this.alignmentOldValue!.length > 0 || this.newITagNodes) {
            var selectionModel = this.xmlEntity.getSelectionModel();
            var selectSheetView = <SheetView>this.view;
            selectionModel.select(selectSheetView.getTagNode());
            selectionModel.setBMultiSelection(true);
            this.xmlEntity.getSelectionModel().unMultiSelection();
            selectionModel.setBMultiSelection(false);
            selectionModel.select(this.iTagNodes[0]);
            selectionModel.setBMultiSelection(true);
            for (let i = 1; i < this.iTagNodes.length; i++) {
                selectionModel.select(this.iTagNodes[i]);
            }
            selectionModel.setBMultiSelection(false);
        }
    }
}