import ExcelGraphicView from "../view/ExcelGraphicView";
import ITagNode from "../../../common/xml/node/ITagNode";
import ICmd from "../../../common/cmd/ICmd";
import ExcelConstants from "../base/ExcelConstants";
import BaseConstants from "../../base/BaseConstants";
import XmlEntity from "../../../common/xml/XmlEntity";
import SheetView from "../view/element/SheetView";


export default class NewRowElementCmd implements ICmd {

   

    private   cmd : String ;
    private view: ExcelGraphicView;
    private tagNode: ITagNode;
    private  nodes?: ITagNode[];
    private orgtagNodes?: ITagNode[];
    private tagNodes?: ITagNode[];
    private newITagNodes?: ITagNode[];


  

    constructor(view: ExcelGraphicView, tagNodes: ITagNode[],cmd :String) {
        this.view = view;
        this.cmd = cmd;
        this.nodes =tagNodes;
        if (this.cmd == ExcelConstants.NODE_AddRow_After){
            this.tagNode = tagNodes[tagNodes.length-1];
        }else {
            this.tagNode = tagNodes[0];
        }
    }

    do(): boolean {
        let xmlEntity = this.view.getXmlEntity();
        let cellNode = this.tagNode;
        let selectSheetViewName = this.view.getSelectSheetViewName();
        let rowNode = <ITagNode>cellNode.getParent();
        let rowIndex: number = 0
        if (rowNode){
            rowIndex = Number( rowNode.getAttributeValue("RowIndex"));
        }else {
            rowIndex = Number( cellNode.getAttributeValue("rowindex"))+1;
        }
        this.orgtagNodes = this.orgtagNodes || [];
        this.newITagNodes = this.newITagNodes || [];
        this.tagNodes = this.tagNodes || [];
        let tagRoot = xmlEntity.getTagRoot();
        let children = tagRoot.getChildren();
        let sheetNode:ITagNode = cellNode;
        for (let child of children) {
            let sheet = <ITagNode>child;
            let key = sheet.getAttributeValue(BaseConstants.ATTR_Name);
            if (key == selectSheetViewName){
                sheetNode = sheet;
                break;
            }
        }
        if (this.cmd == ExcelConstants.NODE_AddRow_After){
            rowIndex = rowIndex+1;
        }
        let rowsNode = <ITagNode>sheetNode.getChildren()[0];
        let rows = rowsNode!.getChildren();
        for (let row of rows) {
            let rownode = <ITagNode>row;
            let currnentIndex = Number( rownode.getAttributeValue("RowIndex"));
            if (currnentIndex>=rowIndex){
                this.orgtagNodes.push(XmlEntity.parseTagNode(rownode.toXml(true)));
                rownode.setAttributeValue(ExcelConstants.ATTR_RowIndex,(currnentIndex+1).toString())
                this.newITagNodes.push(rownode);

            }else {
                let cells = rownode.getChildren();
                for (let cell of cells) {
                    let cellNode = <ITagNode>cell;
                    let rowSpan: number = Number(cellNode.getAttributeValue(ExcelConstants.ATTR_MergedRowSpan));//合并行处理
                    if (rowSpan && (currnentIndex+rowSpan)>rowIndex){
                        this.orgtagNodes.push(XmlEntity.parseTagNode(rownode.toXml(true)));
                        cellNode.setAttributeValue(ExcelConstants.ATTR_MergedRowSpan,(rowSpan+1).toString());
                        this.newITagNodes.push(rownode);
                    }
                }
            }
        }
        if (this.nodes){
            var selectSheetView = <SheetView>this.view.getSelectSheetView();
            xmlEntity.getSelectionModel().select(selectSheetView.getTagNode());
            xmlEntity.getSelectionModel().reset();
            for (let node of this.nodes) {
                if (!node.getParent()){
                    if(this.cmd == ExcelConstants.Node_Add_Row){
                        let attributeValueInt = node.getAttributeValueInt("rowindex",0);
                        node.setAttributeValue("rowindex",(attributeValueInt+1).toString());
                    }
                }
                if (this.nodes.length>1){
                    xmlEntity.getSelectionModel().setBMultiSelection(true);
                }
                xmlEntity.getSelectionModel().select(node)
            }
            xmlEntity.getSelectionModel().setBMultiSelection(false);
        }
        return true;
    }





    undo(): void {
        if (!(this.orgtagNodes && this.orgtagNodes!.length > 0)) {
            return;
        }
        for (let i = 0; i < this!.newITagNodes!.length; i++) {

            var attributes = this!.newITagNodes![i]!.getAttributes();
            attributes.length = 0;
            for (let j = 0; j < this.orgtagNodes[i].getAttributes().length; j++) {
                attributes.push(this.orgtagNodes[i].getAttributes()[j]);
            }
            let xmlEntity = this.view.getXmlEntity();
            xmlEntity.update(this!.newITagNodes![i],true);
        }
        let xmlEntity = this.view.getXmlEntity();
        var selectSheetView = <SheetView>this.view.getSelectSheetView();
        xmlEntity.getSelectionModel().select(selectSheetView.getTagNode());
        xmlEntity.select(this.tagNode)
    }

}