import ExcelGraphicView from "../view/ExcelGraphicView";
import ITagNode from "../../../common/xml/node/ITagNode";
import ICmd from "../../../common/cmd/ICmd";
import ExcelConstants from "../base/ExcelConstants";
import BaseConstants from "../../base/BaseConstants";
import XmlEntity from "../../../common/xml/XmlEntity";
import SheetView from "../view/element/SheetView";


export default class NewColumnElementCmd implements ICmd {



    private   cmd : String ;
    private view: ExcelGraphicView;
    private tagNodes: ITagNode;
    private orgtagNodes?: ITagNode[];
    private nodes?: ITagNode[];
    private newITagNodes?: ITagNode[];



    constructor(view: ExcelGraphicView, tagNodes: ITagNode[],cmd :String) {
        this.view = view;
        this.nodes = tagNodes;
        this.cmd = cmd;
        if (this.cmd == ExcelConstants.NODE_AddColumn_After){
            this.tagNodes = tagNodes[tagNodes.length-1];
        }else {
            this.tagNodes = tagNodes[0];
        }
    }

    do(): boolean {
        let xmlEntity = this.view.getXmlEntity();
        let cellNode = this.tagNodes;
        let selectSheetViewName = this.view.getSelectSheetViewName();
        let rowNode = <ITagNode>cellNode.getParent();
        let columnIndex: number = 0
        if (rowNode){
            columnIndex = Number( cellNode.getAttributeValue("CellIndex"));
        }else {
            columnIndex = Number( cellNode.getAttributeValue("colindex"))+1;
        }
        this.orgtagNodes = this.orgtagNodes || [];
        this.newITagNodes = this.newITagNodes || [];
        let tagRoot = xmlEntity.getTagRoot();
        let children = tagRoot.getChildren();
        let sheetNode:ITagNode = cellNode;
        for (let child of children) {
            let sheet = <ITagNode>child;
            let key = sheet.getAttributeValue(BaseConstants.ATTR_Name);
            if (key == selectSheetViewName){
                sheetNode = sheet;
                break;
            }
        }
        if (this.cmd == ExcelConstants.NODE_AddColumn_After){
            columnIndex = columnIndex+1;
        }
        let rowsNode = <ITagNode>sheetNode.getChildren()[0];
        let rows = rowsNode!.getChildren();
        for (let row of rows) {
            let rownode = <ITagNode>row;
            let cells = rownode.getChildren();
            for (let cell of cells) {
                let cellNode = <ITagNode>cell;
                let cellIndex = Number( cellNode.getAttributeValue("CellIndex"));
                let columnSpan: number = Number(cellNode.getAttributeValue(ExcelConstants.ATTR_MergedColumnSpan));//合并列处理
                if (cellIndex>=columnIndex){
                    this.orgtagNodes.push(XmlEntity.parseTagNode(cellNode.toXml(true)));
                    cellNode.setAttributeValue("CellIndex",(cellIndex+1).toString());
                    this.newITagNodes.push(cellNode);
                }else if (columnSpan && (cellIndex+columnSpan)>columnIndex){
                    this.orgtagNodes.push(XmlEntity.parseTagNode(cellNode.toXml(true)));
                    cellNode.setAttributeValue(ExcelConstants.ATTR_MergedColumnSpan,(columnSpan+1).toString());
                    this.newITagNodes.push(cellNode);
                }
            }
        }
        if (this.nodes){
            var selectSheetView = <SheetView>this.view.getSelectSheetView();
            xmlEntity.getSelectionModel().select(selectSheetView.getTagNode());
            xmlEntity.getSelectionModel().reset();
            for (let node of this.nodes) {
                if (!node.getParent()){
                    if(this.cmd == ExcelConstants.Node_Add_Column){
                        let attributeValueInt = node.getAttributeValueInt("colindex",0);
                        node.setAttributeValue("colindex",(attributeValueInt+1).toString());
                    }
                }
                if (this.nodes.length>1){
                    xmlEntity.getSelectionModel().setBMultiSelection(true);
                }
                xmlEntity.getSelectionModel().select(node)
            }
            xmlEntity.getSelectionModel().setBMultiSelection(false);
        }
        return true;
    }





    undo(): void {
        if (!(this.orgtagNodes && this.orgtagNodes!.length > 0)) {
            return;
        }
        for (let i = 0; i < this!.newITagNodes!.length; i++) {
            var attributes = this!.newITagNodes![i]!.getAttributes();
            attributes.length = 0;
            for (let j = 0; j < this.orgtagNodes[i].getAttributes().length; j++) {
                attributes.push(this.orgtagNodes[i].getAttributes()[j]);
            }
            let xmlEntity = this.view.getXmlEntity();
            xmlEntity.update(this!.newITagNodes![i],true);
        }
        let xmlEntity = this.view.getXmlEntity();
        var selectSheetView = <SheetView>this.view.getSelectSheetView();
        xmlEntity.getSelectionModel().select(selectSheetView.getTagNode());
        xmlEntity.select(this.tagNodes)
    }

}