import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import ExcelWorkSpace from "../ExcelWorkSpace";
import SheetView from "../view/element/SheetView";
import ExcelConstants from "../base/ExcelConstants";
import TagNode from "../../../common/xml/node/TagNode";
import XmlEntity from "../../../common/xml/XmlEntity";

export default class MergeCellCmd implements ICmd {
    private iTagNodes: ITagNode[];
    private oldITagNodes?: ITagNode[];
    private newITagNodes?: ITagNode[];
    private xmlEntity: IXmlEntity;
    private excelWorkSpace: ExcelWorkSpace;
    private sectionView: SheetView;
    private newITagNode?: ITagNode;


    constructor(xmlEntity: IXmlEntity, tagNode: ITagNode[], excelWorkSpace: ExcelWorkSpace, sheetView: SheetView) {
        this.xmlEntity = xmlEntity;
        this.iTagNodes = tagNode;
        this.excelWorkSpace = excelWorkSpace;
        this.sectionView = sheetView;

    }

    do(): boolean {
        if (this.iTagNodes.length <= 0) {
            return false;
        }
        var iTagNode = this.iTagNodes[0];
        //最大
        var maxX = 0;
        var minX = 100000;
        var maxY = 0;
        var minY = 100000;
        this.oldITagNodes = this.oldITagNodes || []
        this.newITagNodes = this.newITagNodes || []
        for (let i = 0; i < this.iTagNodes.length; i++) {
            var iTagNode1 = this.iTagNodes[i];
            var cellIndex;
            var rowIndex;
            if (iTagNode1.getParent()) {
                cellIndex = iTagNode1.getAttributeValueInt(ExcelConstants.ATTR_CellIndex, 0);
                rowIndex = iTagNode1.getParent()!.getAttributeValueInt(ExcelConstants.ATTR_RowIndex, 0);
                if (i != 0) {
                    this.oldITagNodes.push(XmlEntity.parseTagNode(iTagNode1.toXml(true)));
                    iTagNode1.removeAttribute(ExcelConstants.ATTR_MergedColumnSpan);
                    iTagNode1.removeAttribute(ExcelConstants.ATTR_MergedRowSpan);
                    this.newITagNodes.push(iTagNode1);
                }
            } else {
                cellIndex = iTagNode1.getAttributeValueInt(ExcelConstants.ATTR_colindex, 0) + 1;
                rowIndex = iTagNode1.getAttributeValueInt(ExcelConstants.ATTR_rowindex, 0) + 1;
            }
            maxX = Math.max(maxX, rowIndex);
            maxY = Math.max(maxY, cellIndex);
            minX = Math.min(minX, rowIndex);
            minY = Math.min(minY, cellIndex);
        }

        //此时求得最大
        if (iTagNode.getParent()) {
            this.oldITagNodes.push(XmlEntity.parseTagNode(iTagNode.toXml(true)));
            iTagNode.removeAttribute(ExcelConstants.ATTR_MergedColumnSpan);
            iTagNode.removeAttribute(ExcelConstants.ATTR_MergedRowSpan);
            iTagNode.setAttributeValue(ExcelConstants.ATTR_MergedColumnSpan, String(maxY - minY + 1), "1");
            iTagNode.setAttributeValue(ExcelConstants.ATTR_MergedRowSpan, String(maxX - minX + 1), "1");
            this.newITagNodes.push(iTagNode);
        } else {
            var mergedRowSpan = String(maxX - minX + 1);
            var mergedColumnSpan = String(maxY - minY + 1);
            var iTagNode2 = this.sectionView!.getTagNode().ensureChild(ExcelConstants.NODE_Rows);
            var find = iTagNode2.find(ExcelConstants.NODE_Row, ExcelConstants.ATTR_RowIndex, String(minX));
            var tagNode2;
            if (!find) {
                tagNode2 = new TagNode(ExcelConstants.NODE_Cell);
                tagNode2.setAttributeValue(ExcelConstants.ATTR_SourceType, "Const");
                tagNode2.setAttributeValue(ExcelConstants.ATTR_CellIndex, String(minY));
                tagNode2.setAttributeValue(ExcelConstants.ATTR_MergedColumnSpan, mergedColumnSpan, "1");
                tagNode2.setAttributeValue(ExcelConstants.ATTR_MergedRowSpan, mergedRowSpan, "1");
                var row = new TagNode(ExcelConstants.NODE_Row);
                row.setAttributeValue(ExcelConstants.ATTR_RowIndex, String(minX));
                iTagNode2.addChild(row);
                row.addChild(tagNode2);
            } else {
                tagNode2 = find.find(ExcelConstants.NODE_Cell, ExcelConstants.ATTR_CellIndex, String(minY));
                if (tagNode2) {
                    tagNode2.setAttributeValue(ExcelConstants.ATTR_MergedColumnSpan, mergedColumnSpan, "1");
                    tagNode2.setAttributeValue(ExcelConstants.ATTR_MergedRowSpan, mergedRowSpan, "1");
                } else {
                    tagNode2 = new TagNode(ExcelConstants.NODE_Cell);
                    tagNode2.setAttributeValue(ExcelConstants.ATTR_SourceType, "Const");
                    tagNode2.setAttributeValue(ExcelConstants.ATTR_CellIndex, String(minY));
                    tagNode2.setAttributeValue(ExcelConstants.ATTR_MergedColumnSpan, mergedColumnSpan, "1");
                    tagNode2.setAttributeValue(ExcelConstants.ATTR_MergedRowSpan, mergedRowSpan, "1");
                    find.addChild(tagNode2);
                }
            }
            this.newITagNode = tagNode2;
        }
        var selectionModel = this.xmlEntity.getSelectionModel();
        this.excelWorkSpace.getGraphicView().loadSheetView(this.xmlEntity);
        selectionModel.setBMultiSelection(true);
        this.xmlEntity.getSelectionModel().unMultiSelection();
        selectionModel.setBMultiSelection(false);
        if (iTagNode.getParent()) {
            selectionModel.select(iTagNode);
        } else {
            selectionModel.select(this.newITagNode);
        }
        selectionModel.setBMultiSelection(true);
        if (this.oldITagNodes) {
            for (let i = 1; i < this.iTagNodes.length; i++) {
                selectionModel.select(this.iTagNodes[i]);
            }
        }
        selectionModel.setBMultiSelection(false);
        return true;
    }

    undo(): void {
        if (this.iTagNodes.length <= 0) {
            return;
        }
        if ((this.oldITagNodes && this.oldITagNodes!.length > 0) || this.oldITagNodes) {
            for (let i = 0; i < this!.newITagNodes!.length; i++) {
                var attributes = this!.newITagNodes![i]!.getAttributes();
                attributes.length = 0;
                for (let j = 0; j < this.oldITagNodes[i].getAttributes().length; j++) {
                    attributes.push(this.oldITagNodes[i].getAttributes()[j]);
                }
            }
            if (this.newITagNode) {
                var parent = this.newITagNode.getParent();
                parent?.removeChild(this.newITagNode);
            }
            var selectionModel = this.xmlEntity.getSelectionModel();
            this.excelWorkSpace.getGraphicView().loadSheetView(this.xmlEntity);
            selectionModel.setBMultiSelection(true);
            this.xmlEntity.getSelectionModel().unMultiSelection();
            selectionModel.setBMultiSelection(false);
            selectionModel.select(this.iTagNodes[0]);
            selectionModel.setBMultiSelection(true);
            if (this.oldITagNodes) {
                for (let i = 1; i < this.iTagNodes.length; i++) {
                    selectionModel.select(this.iTagNodes[i]);
                }
            }
            selectionModel.setBMultiSelection(false);
        }
    }
}