import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import SheetView from "../view/element/SheetView";
import TagNode from "../../../common/xml/node/TagNode";
import ExcelGraphicView from "../view/ExcelGraphicView";
import Var from "../../../common/struct/Var";
import BaseConstants from "../../base/BaseConstants";
import Button from "../../../common/component/control/Button";
import ExcelConstants from "../base/ExcelConstants";

export default class InputSheetCmd implements ICmd {
    private iTagNode?: ITagNode;
    private oldValue?: string;
    private newITagNode?: ITagNode;

    private sefl: ExcelGraphicView
    private e: any
    private button: Button

    constructor(sefl: ExcelGraphicView, button: Button, e: any) {
        this.sefl = sefl;
        this.button = button;
        this.e = e;
    }

    do(): boolean {
        var e = this.e;
        var sefl = this.sefl;
        let tagNode;
        console.log("失去焦点")
        // var innerHTML = <HTMLElement>e.target;
        var view2 = <SheetView>sefl.getSheetView(sefl.getSelectSheetViewName());
        if (view2) {
            tagNode = <ITagNode>view2.getTagNode();
        }
        var value = String($(e.target).val());
        if (tagNode) {
            var oldValue = tagNode.getAttributeValue(BaseConstants.ATTR_Name, "");
            if (value != oldValue) {
                const pattern = /[:\\/?\*|\[\]]/;
                let length = value.length;
                if (!value || length > 31 || pattern.test(value) ||
                    value[0] == "'" || value[length - 1] == "'" ||
                    tagNode.getParent()!.find(ExcelConstants.NODE_Sheet, ExcelConstants.ATTR_Name, value)
                ) {
                    value = oldValue;
                    // @ts-ignore
                    layui.layer.msg(`在重命名工作表时输入的名称无效。请尝试以下操作:</br>确认输入的名称不多于31个字符。</br>确认名称中不包含以下字符: :\\/?*[或]。</br>确认名称的第一个或者最后一个字符不能是单引号。</br>确认工作表名称不为空。</br>确认工作表名称不重复。`, {
                        icon: 5,
                        time: 5000,
                    })
                }
                tagNode.setAttributeValue(BaseConstants.ATTR_Name, value);
                sefl.setSelectSheetViewName(value);
                this.button!.getDomElement().removeChild();
                this.button!.getDomElement().setText(value);
                this.sefl.getXmlEntity().update(tagNode, true);
            }
        }
        this.button!.getDomElement().removeChild();
        this.button!.getDomElement().setText(value);
        return true;
    }

    undo(): void {
        if (this.oldValue) {
            this.iTagNode!.setAttributeValue("Definition", this.oldValue);
            this.sefl.getXmlEntity().getSelectionModel().select(this.iTagNode);
        } else if (this.newITagNode) {
            var parent = this.newITagNode.getParent();
            parent?.removeChild(this.newITagNode);
            this.sefl.getXmlEntity().getTagRoot().resetLineIndex(new Var<number>(0));
            this.sefl.getXmlEntity().getSelectionModel().select(parent);
        }

    }
}