import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import SheetView from "../view/element/SheetView";
import TagNode from "../../../common/xml/node/TagNode";
import ExcelGraphicView from "../view/ExcelGraphicView";
import Var from "../../../common/struct/Var";
import ExcelConstants from "../base/ExcelConstants";

export default class InputCellCmd implements ICmd {
    private iTagNode?: ITagNode;
    private oldValue?: string;
    private newITagNode?: ITagNode;

    private sefl: ExcelGraphicView
    private e: any

    constructor(sefl: ExcelGraphicView, e: any) {
        this.sefl = sefl;
        this.e = e;
    }

    do(): boolean {
        var e = this.e;
        var sefl = this.sefl;
        console.log("失去焦点")
        //   setTimeout(function () {
        var view2 = <SheetView>sefl.getSheetView(sefl.getSelectSheetViewName());
        var el = <HTMLElement>this.e.target;
        var offsetParent = el.parentElement;
        var startX = Number(offsetParent!.getAttribute("rowindex"))
        var startY = Number(offsetParent!.getAttribute("colindex"))
        var childNode1 = view2!.getChildNode(startX, startY);
        var tagNode1 = childNode1?.getTagNode();
        var rowindexStr = tagNode1?.getAttributeValue("rowindex");
        var value1 = String($(e.target).val());
        if (rowindexStr == "") {
            var value = value1;
            var oldValue = tagNode1?.getAttributeValue("Definition", "");
            if (value == oldValue) {
                return true;
            }
            this.oldValue = oldValue;
            this.iTagNode = tagNode1;
            tagNode1?.setAttributeValue("Definition", value);
        } else {
            if (value1 == "")return false;
            var rowindex = tagNode1!.getAttributeValueInt("rowindex", 0) + 1;
            var colindex = tagNode1!.getAttributeValueInt("colindex", 0) + 1;
            var rows = view2.getTagNode().getChild("Rows");
            let Row = rows?.find(ExcelConstants.NODE_Row,ExcelConstants.ATTR_RowIndex,String(rowindex));
            var cell;
            if (Row){
                 cell = Row.find(ExcelConstants.NODE_Cell,ExcelConstants.ATTR_ColumnIndex,String(colindex));
                if (cell){
                    cell.setAttributeValue("Definition", value1);
                } else {
                    cell = new TagNode("Cell");
                    Row.addChild(cell);
                    this.newITagNode = cell;
                    cell.setAttributeValue("CellIndex", String(colindex));
                    cell.setAttributeValue("SourceType", "Const");
                    cell.setAttributeValue("Definition", value1);
                }
            } else {
                Row= new TagNode("Row");
                Row.setAttributeValue("RowIndex", String(rowindex));
                this.newITagNode = Row;
                cell = new TagNode("Cell");
                Row.addChild(cell);
                rows?.addChild(Row);
                this.newITagNode = cell;
                cell.setAttributeValue("CellIndex", String(colindex));
                cell.setAttributeValue("SourceType", "Const");
                cell.setAttributeValue("Definition", value1);
            }

        } if (this.newITagNode) {
            this.sefl.loadSheetView(this.sefl.getXmlEntity());
            this.sefl.getXmlEntity().getSelectionModel().select(cell);
        }else {
            this.sefl.loadSheetView(this.sefl.getXmlEntity());
            this.sefl.getXmlEntity().getSelectionModel().select(cell);
        }
        return true;
    }

    undo(): void {
        if (this.oldValue) {
            this.iTagNode!.setAttributeValue("Definition", this.oldValue);
            this.sefl.loadSheetView(this.sefl.getXmlEntity());
            this.sefl.getXmlEntity().getSelectionModel().select(this.iTagNode);
        } else if (this.newITagNode) {
            var parent = this.newITagNode.getParent();
            parent?.removeChild(this.newITagNode);
            this.sefl.loadSheetView(this.sefl.getXmlEntity());
            this.sefl.getXmlEntity().getSelectionModel().select(this.sefl.getSelectExcelView().getTagNode());
        }
    }
}