import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import SheetView from "../view/element/SheetView";
import TagNode from "../../../common/xml/node/TagNode";
import Var from "../../../common/struct/Var";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import ExcelGraphicView from "../view/ExcelGraphicView";

export default class EnsureSetImageValueCmd implements ICmd {
    private iTagNode: ITagNode;
    private newITagNode?: ITagNode;
    private view: SheetView;
    private xmlEntity: IXmlEntity;
    private newValue: string;
    private graphicView: ExcelGraphicView;


    constructor(xmlEntity: IXmlEntity, view: SheetView, iTagNode: ITagNode, value: string, excelGraphicView: ExcelGraphicView) {
        this.xmlEntity = xmlEntity;
        this.view = view;
        this.iTagNode = iTagNode;
        this.newValue = value;
        this.graphicView = excelGraphicView;
    }

    do(): boolean {
        var rowindex = this.iTagNode.getAttributeValueInt("rowindex", 0) + 1;
        var colindex = this.iTagNode.getAttributeValueInt("colindex", 0) + 1;
        var rows = this.view.getTagNode().getChild("Rows");
        var children = rows!.getChildren();
        if (children.length == 0) {
            var row = new TagNode("Row");
            row.setAttributeValue("RowIndex", String(rowindex));
            var cell = new TagNode("Cell");
            cell.setAttributeValue("CellIndex", String(colindex));
            cell.setAttributeValue("SourceType", "Const");
            cell.setAttributeValue("Definition", this.newValue);

            row.addChild(cell);
            this.newITagNode = row;
            rows?.addChild(row)
        } else {
            var isAddChild = false;
            for (let k = 0; k < children.length; k++) {
                var iNode1 = <ITagNode>children[k];
                if (iNode1!.getAttributeValueInt("RowIndex", 0) == rowindex) {
                    var children1 = iNode1.getChildren();
                    for (let l = 0; l < children1.length; l++) {
                        var node = <ITagNode>children1[l];
                        if (node!.getAttributeValueInt("CellIndex", 0) == colindex) {
                            continue;
                        } else {
                            var cell1 = new TagNode("Cell");
                            cell1.setAttributeValue("CellIndex", String(colindex));
                            cell1.setAttributeValue("SourceType", "Const");
                            cell1.setAttributeValue("Definition", this.newValue);
                            iNode1.addChild(cell1);
                            this.newITagNode = cell1;
                            isAddChild = true;
                            break;
                        }

                    }
                } else if (!isAddChild) {
                    //添加节点
                    var row1 = new TagNode("Row");
                    row1.setAttributeValue("RowIndex", String(rowindex));
                    var cell2 = new TagNode("Cell");
                    cell2.setAttributeValue("CellIndex", String(colindex));
                    cell2.setAttributeValue("SourceType", "Const");
                    cell2.setAttributeValue("Definition", this.newValue);
                    row1.addChild(cell2)
                    rows?.addChild(row1)
                    this.newITagNode = row1;
                    break;
                }
            }
        }
        if (this.newITagNode) {
            var selectionModel = this!.xmlEntity!.getSelectionModel();
            var selectSheetView = <SheetView>this.graphicView.getSelectSheetView();
            selectionModel.select(selectSheetView.getTagNode());
            this!.xmlEntity!.getTagRoot().resetLineIndex(new Var<number>(0));
            if (this.newITagNode.getTagName() == "Cell") {
                this.graphicView.getSelectExcelView().setTagCell(this.newITagNode);
                selectionModel.select(this.newITagNode);
            } else {
                this.graphicView.getSelectExcelView().setTagCell(<ITagNode>this.newITagNode!.getChild("Cell"));
                selectionModel.select(this.newITagNode.getChild("Cell"));
            }
        }
        return true;
    }

    undo(): void {
        if (this.newITagNode) {
            var parent = this.newITagNode.getParent();
            parent?.removeChild(this.newITagNode);
            var selectionModel = this!.xmlEntity!.getSelectionModel();
            var selectSheetView = <SheetView>this.graphicView.getSelectSheetView();
            selectionModel.select(selectSheetView.getTagNode());
            selectionModel.select(parent);
        }
    }

}