import ExcelGraphicView from "../view/ExcelGraphicView";
import ITagNode from "../../../common/xml/node/ITagNode";
import ICmd from "../../../common/cmd/ICmd";
import ExcelConstants from "../base/ExcelConstants";
import XmlEntity from "../../../common/xml/XmlEntity";


export default class EliminateCellCmd implements ICmd {


    private cmd: String;
    private view: ExcelGraphicView;
    private tagNodes: ITagNode[];
    private orgtagNode?: ITagNode[];
    private newITagNode?: ITagNode[];
    private deleteNode?: ITagNode[];
    private rowNode?: ITagNode;
    private isDelete: boolean = false;
    private selectNodes?: ITagNode[];

    // 记录修改前的组件和父组件的对应
    private orgComponent?: Map<ITagNode, ITagNode[]>;
    private orgParentNode?: ITagNode[];

    constructor(view: ExcelGraphicView, tagNodes: ITagNode[], cmd: String) {
        this.view = view;
        this.tagNodes = tagNodes;
        this.cmd = cmd;
    }

    do(): boolean {
        this.newITagNode = this.newITagNode || []
        this.deleteNode = this.deleteNode || []
        this.selectNodes = this.selectNodes || []
        this.orgtagNode = this.orgtagNode || []
        this.orgComponent = new Map();
        this.orgParentNode = [];
        for (let i = 0; i < this.tagNodes.length; i++) {
            let cellNode = this.tagNodes[i];
            let rowNode = <ITagNode>cellNode.getParent();
            if (rowNode) {
                let mergedColumnSpan = cellNode.getAttributeValueInt(ExcelConstants.ATTR_MergedColumnSpan, 0);
                let mergedRowSpan = cellNode.getAttributeValueInt(ExcelConstants.ATTR_MergedRowSpan, 0);
                if (mergedColumnSpan == 0 && mergedRowSpan == 0) {
                    this.isDelete = true;
                    this.putToMap(this.orgComponent, rowNode, cellNode);
                    this.pushToParentNode(this.orgParentNode, rowNode);
                    rowNode.removeChild(cellNode);
                    let colIndex = cellNode.getAttributeValueInt(ExcelConstants.ATTR_CellIndex, 0) - 1;
                    let rowIndex = rowNode.getAttributeValueInt(ExcelConstants.ATTR_RowIndex, 0) - 1;
                    let tempNode = this.view.getXmlEntity().getNodeFactory().createTagNode(ExcelConstants.NODE_Cell);
                    tempNode.setAttributeValue(ExcelConstants.ATTR_colindex, colIndex.toString());
                    tempNode.setAttributeValue(ExcelConstants.ATTR_rowindex, rowIndex.toString());
                    this.selectNodes.push(tempNode);
                } else {
                    // 克隆一个cellNode
                    let newCellNode = XmlEntity.parseTagNode(cellNode!.toXml(true))
                    this.putToMap(this.orgComponent, rowNode, newCellNode);
                    this.pushToParentNode(this.orgParentNode, rowNode);
                    // 重新添加一个节点 避免干扰到this.tagNode 造成重做时数据错误
                    let iTagNode = XmlEntity.parseTagNode(cellNode!.toXml(true));
                    iTagNode.removeAttribute(ExcelConstants.ATTR_Definition);
                    this.removeChild(cellNode, rowNode);
                    rowNode.addChild(iTagNode);
                    this.selectNodes.push(cellNode);
                }
                // this.tagNodes = rowNode;
            } else {
                this.selectNodes.push(cellNode);
            }
        }
        if (this.selectNodes) {
            var selectionModel = this.view.getXmlEntity().getSelectionModel();
            this.view.loadSheetView(this.view.getXmlEntity())
            selectionModel.setBMultiSelection(true);
            this.view.getXmlEntity().getSelectionModel().unMultiSelection();
            selectionModel.setBMultiSelection(false);
            selectionModel.select(this.selectNodes[0]);
            selectionModel.setBMultiSelection(true);
            if (this.selectNodes) {
                for (let i = 1; i < this.selectNodes.length; i++) {
                    selectionModel.select(this.selectNodes[i]);
                }
            }
            selectionModel.setBMultiSelection(false);
        }
        return true;
    }


    undo(): void {
        if (this.tagNodes.length <= 0) {
            return;
        }
        // 撤销流程
        if( this.orgParentNode!.length > 0){
            for (let i = 0; i < this.orgParentNode!.length; i++) {
                let parentNode = this.orgParentNode![i];
                let nodes = this.orgComponent!.get(parentNode)!;

                // 查找parentNode中存在merged的节点
                let mergedNodes = parentNode.getChildren().filter((node) => {
                    return (<ITagNode>node).getAttributeValueInt(ExcelConstants.ATTR_MergedColumnSpan, 0) > 0
                        || (<ITagNode>node).getAttributeValueInt(ExcelConstants.ATTR_MergedRowSpan, 0) > 0;
                });
                // 遍历merged节点，将其删除
                mergedNodes.forEach((node) => { parentNode.removeChild(node); });
                nodes.forEach((node) => { parentNode.addChild(node); });
            }
        }

        var selectionModel = this.view.getXmlEntity().getSelectionModel();
        this.view.loadSheetView(this.view.getXmlEntity())
        selectionModel.setBMultiSelection(true);
        this.view.getXmlEntity().getSelectionModel().unMultiSelection();
        selectionModel.setBMultiSelection(false);
        selectionModel.select(this.tagNodes[0]);
        selectionModel.setBMultiSelection(true);

        for (let i = 1; i < this.tagNodes.length; i++) {
            selectionModel.select(this.tagNodes[i]);
        }
        selectionModel.setBMultiSelection(false);

    }

    private putToMap(map: Map<ITagNode, ITagNode[]>, key: ITagNode, value: ITagNode) {
        if (map.has(key)) {
            map.get(key)!.push(value);
        } else {
            map.set(key, [value]);
        }
    }

    private pushToParentNode(arr: ITagNode[], parentNode: ITagNode) {
        // 如果parent里已经存在了 就不添加
        for (let i = 0; i < arr.length; i++) {
            if (arr[i] == parentNode) {
                return;
            }
        }
        arr.push(parentNode);
    }

    /**
     * 原有的removeChild方法移除不了被拷贝的节点 原因：在被合并单元格的处理中，会将被合并的单元格移除，在undo中重新添加回去的是克隆的节点
     * @param child
     * @param parent
     * @private
     */
    private removeChild(child: ITagNode, parent: ITagNode) {
        let children = parent.getChildren();
        for (let i = 0; i < children.length; i++) {
            if (this.isCellIndexEqual(<ITagNode>children[i], child)) {
                children.splice(i, 1);
                break;
            }
        }
    }

    // 判断两个节点的CellIndex是否相等
    private isCellIndexEqual(node1: ITagNode, node2: ITagNode): boolean {
        return node1.getAttributeValueInt(ExcelConstants.ATTR_CellIndex, 0) == node2.getAttributeValueInt(ExcelConstants.ATTR_CellIndex, 0);
    }

}