import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";

import ExcelGraphicView from "../view/ExcelGraphicView";

export default class DragStateCmd implements ICmd {

    private oldITagNode: ITagNode;
    private newITagNode: ITagNode;
    private excelGraphicView: ExcelGraphicView;


    constructor(excelGraphicView: ExcelGraphicView, oldNode: ITagNode,newNode :ITagNode) {
        this.excelGraphicView = excelGraphicView;
        this.oldITagNode = oldNode;
        this.newITagNode = newNode;
    }

    do(): boolean {
        return true;
    }

    undo(): void {
        if (this.oldITagNode && this.newITagNode) {
            var attributes = this!.newITagNode!.getAttributes();
            attributes.length = 0;
            for (let j = 0; j < this.oldITagNode.getAttributes().length; j++) {
                attributes.push(this.oldITagNode.getAttributes()[j]);
            }
            this.excelGraphicView.getXmlEntity().update(this.newITagNode, true);
        }else if (!this.oldITagNode && this.newITagNode){
            this.excelGraphicView.getXmlEntity().removeNode(this.newITagNode);
        }
    }
}