import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import SheetView from "../view/element/SheetView";
import TagNode from "../../../common/xml/node/TagNode";
import ExcelGraphicView from "../view/ExcelGraphicView";
import Var from "../../../common/struct/Var";
import BaseConstants from "../../base/BaseConstants";
import XmlEntity from "../../../common/xml/XmlEntity";

export default class DeleteSheetCmd implements ICmd {
    private iTagNode?: ITagNode;
    private oldValue?: string;
    private orgtagNode?: ITagNode;
    private sefl: ExcelGraphicView
    private e: any

    constructor(sefl: ExcelGraphicView, e: any) {
        this.sefl = sefl;
        this.e = e;
    }

    do(): boolean {
        var e = this.e;
        var sefl = this.sefl;
        let tagNode;
        console.log("失去焦点")
        // var innerHTML = <HTMLElement>e.target;
        var view2 = <SheetView>sefl.getSheetView(sefl.getSelectSheetViewName());
        if (view2){
            tagNode = <ITagNode>view2.getTagNode();
        }

        if (tagNode){
            let workBook = tagNode.getParent();
            this.orgtagNode =  XmlEntity.parseTagNode(workBook!.toXml(true));
            if (workBook!.getChildren().length>1){
                sefl.setSelectSheetViewName("");
                this.sefl.getXmlEntity().removeNode(tagNode);
            }
            this.iTagNode =workBook;
        }
        return true;
    }

    undo(): void {
        var xmlEntity = this.sefl.getXmlEntity();
        let children = this.orgtagNode?.getChildren();
        this.iTagNode?.clearChildren();
        for (let childrenKey of children!) {
            this.iTagNode?.addChild(childrenKey)
        }
        xmlEntity?.update(<ITagNode>this.iTagNode,true);
        xmlEntity.getTagRoot().resetLineIndex(new Var(0));//源代码的定位需要startLinde和endLine所以需要去对新加的Sectionc重新reload进行计算

    }
}