import AbstractWorkSpace from "../base/AbstractWorkSpace";
import {EDesignMode} from "../../common/enum/Enums";
import AbstractDesignView from "../base/AbstractDesignView";
import ComplexDesignView from "../base/ComplexDesignView";

import ExcelGraphicView from "./view/ExcelGraphicView";
import ExcelDesignView from "./view/ExcelDesignView";
import PrintButton from "../print/view/PrintButton";
import Label from "../../common/component/control/Label";
import PrintH5HFlexPanel from "../print/view/PrintH5HFlexPanel";
import CmdQueue from "../../common/cmd/CmdQueue";
import OperationDispatcher from "../../common/operation/OperationDispatcher";
import Toolbar from "../../common/component/toolbar/Toolbar";
import PrintButtonBox from "../print/view/PrintButtonBox";
import ITagNode from "../../common/xml/node/ITagNode";
import JComponent from "../../common/component/JComponent";
import PrintCombobox from "../print/view/PrintCombobox";
import TypeUtil from "../../common/util/TypeUtil";
import SizeInfo from "../../common/struct/SizeInfo";
import P18N from "./base/P18N";
import ExcelConstants from "./base/ExcelConstants";
import Button from "../../common/component/control/Button";
import Events from "../../common/event/Events";
import ExcelActionUtil from "./util/ExcelActionUtil";
import NewRowElementCmd from "./cmd/NewRowElementCmd";
import PrintTextEditor from "./view/PrintTextEditor";
import ExcelToolbar from "./view/ExcelToolbar";
import DeleteRowElementCmd from "./cmd/DeleteRowElementCmd";
import NewColumnElementCmd from "./cmd/NewColumnElementCmd";
import DeleteColumnElementCmd from "./cmd/DeleteColumnElementCmd";
import SetImageValueCmd from "./cmd/SetImageValueCmd";
import SheetView from "./view/element/SheetView";
import {ExcelCellView} from "./view/element/ExcelCellView";
import EnsureSetImageValueCmd from "./cmd/EnsureSetImageValueCmd";
import KeyUpEvent = JQuery.KeyUpEvent;
import AbstractDomElement from "../../common/dom/AbstractDomElement";
import EXCEL from "./base/EXCEL";
import EliminateCellCmd from "./cmd/EliminateCellCmd";
import {IPropertyIO} from "../plugin/property/base/PropertyDefine";
import {ExcelPropertyIO} from "./property/ExcelPropertyIO";
import MergeCellCmd from "./cmd/MergeCellCmd";
import DivisionCellCmd from "./cmd/DivisionCellCmd";
import ExcelColorEditor from "../../common/component/control/ExcelColorEditor";
import SetStyleBorderCmd from "../excel/cmd/SetStyleBorderCmd";
import SetBorderCmd from "./cmd/SetBorderCmd";
import SetAlignmentCmd from "./cmd/SetAlignmentCmd";
import TagNode from "../../common/xml/node/TagNode";
import SetBorderColorCmd from "./cmd/SetBorderColorCmd";

export default class ExcelWorkSpace extends AbstractWorkSpace<ExcelGraphicView, Toolbar> {
    private observer?: any
    private recordOldValue?: any

    constructor(mode: EDesignMode) {
        super(mode, new Toolbar());
        this.addClass("excel-workspace");
    }

    createDesignView(viewContainer: ComplexDesignView<any, any>, operationDispatcher: OperationDispatcher): AbstractDesignView<any> {
        return new ExcelDesignView(viewContainer, operationDispatcher);
    }

    createGraphicView(mode: EDesignMode) {
        var excelGraphicView = new ExcelGraphicView();
        for (var action of ExcelActionUtil.ACTION_ON_NODE) {
            var menuItem = excelGraphicView.getToolBar().addMenuItem(action, P18N.getString(action))
            menuItem.setStyle("font-size", "12px");
            this.initToolOptHandler(menuItem, excelGraphicView);
        }
        let innerTemplateView = excelGraphicView.getInnerTemplateView();
        this.initViewMouseEvent(innerTemplateView.getDomElement());
        this.installExcelToolbar(excelGraphicView.getExcelToolbar());
        var self = this;
        var element = this.getDomElement().getEl();
        let MutationObserver = window.MutationObserver;
        this.observer = new MutationObserver((mutationList) => {
            let width = getComputedStyle(element).getPropertyValue('width')
            let height = getComputedStyle(element).getPropertyValue('height')
            if (self.recordOldValue && self.recordOldValue.width && width === self.recordOldValue.width && height === self.recordOldValue.height) return
            self.recordOldValue = {
                width,
                height
            }
            self.getGraphicView().loadSheetView(self.getXmlEntity());

        })
        this.observer.observe(element, {attributes: true, attributeFilter: ['style'], attributeOldValue: true})
        return excelGraphicView;
    }

    load(xml: string) {
        super.load(xml ? xml : this.DEMO_XML)
        this.getXmlEntity().addEventListener(this.getGraphicView().getExcelToolbar());
    }

    /**
     * 初始化设计模板鼠标事件
     */
    private initViewMouseEvent(domEl: AbstractDomElement): void {
        domEl.addEventListener('mousedown', (e: MouseEvent) => {
            var target = <HTMLElement>e.target;
            if (target.nodeName == "IMG" && target.className == 'selected-td-img') {
                this.getGraphicView().getOptStateDelegate().getCurrentState().mousedown(e)
                this.operationDispatcher.eval("Macro_ShowColumnList()");
            } else {
                this.getGraphicView().getOptStateDelegate().getCurrentState().mousedown(e)
            }
        });
        domEl.addEventListener('mousemove', (e: MouseEvent) => this.getGraphicView().getOptStateDelegate().getCurrentState().mousemove(e));
        domEl.addEventListener('mouseup', (e: MouseEvent) => this.getGraphicView().getOptStateDelegate().getCurrentState().mouseup(e));
    }

    private initToolOptHandler(item: JComponent<any>, excelGraphicView: ExcelGraphicView): void {
        item.addEventListener(Events.MouseDown, (event: any) => {
            event = event || window.event;
            var action = item.getKey();
            switch (action) {
                case ExcelConstants.NODE_Cell_Data:
                    var exp = "ShowModal('D_ReportColumn',{FormKey:{GetPrintAttrValue('FormKey'),{ReportKey:{GetPrintAttrValue('Key'),},);"
                    this.operationDispatcher.eval(exp)
                    break;
                case ExcelConstants.Node_Add_Row:
                    this.doAddRowElementCmd(action, excelGraphicView);
                    break;
                case ExcelConstants.Node_Remove_Row:
                    this.doDeleteRowElementCmd(action, excelGraphicView);
                    break;
                case ExcelConstants.Node_Add_Column:
                    this.doNewColumnElementCmd(action, excelGraphicView);
                    break;
                case ExcelConstants.Node_Remove_Column:
                    this.doDeleteColumnElementCmd(action, excelGraphicView);
                    break;
                case ExcelConstants.Node_Eliminate_Cell:
                    this.doEliminateCellCmd(action, excelGraphicView);
                    break;
                case ExcelConstants.Node_Cell_Porperty:
                    var exp = "ShowModal('D_ExcelCellFormat',{FormKey:{GetPrintAttrValue('FormKey')},ExcelKey:{GetPrintAttrValue('Key')}, XML:{GetSheetXML()}, ColumnIndex:{GetExcelColumnIndex()},RowIndex: {GetExcelRowIndex()}});"
                    this.operationDispatcher.eval(exp)
                    break;
                case ExcelConstants.Node_Cell_Expand:
                    var exp = "ShowModal('D_ExcelColumnExpand',{FormKey:{GetPrintAttrValue('FormKey')},ExcelKey:{GetPrintAttrValue('Key')}, XML:{GetSheetXML()}, ColumnIndex:{GetExcelColumnIndex()},RowIndex: {GetExcelRowIndex()}});"
                    this.operationDispatcher.eval(exp)
                    break;
                case ExcelConstants.Node_ColAndRow_Size:
                    var exp = "ShowModal('D_ExcelCellSize',{FormKey:{GetPrintAttrValue('FormKey')},ExcelKey:{GetPrintAttrValue('Key')}, XML:{GetSheetXML()}, ColumnIndex:{GetExcelColumnIndex()},RowIndex: {GetExcelRowIndex()}});"
                    this.operationDispatcher.eval(exp)
                    break;
                case ExcelConstants.Node_Template_Porperty:
                    var exp = "ShowModal('D_ExcelProp',{FormKey:{GetPrintAttrValue('FormKey')},ExcelKey:{GetPrintAttrValue('Key')}, Type:{'Excel'}, XML:{GetReportXML()}});"
                    this.operationDispatcher.eval(exp)
                    break;
            }

            excelGraphicView.getToolBar().hide();
        }, true);
    }


    //新增行
    public doAddRowElementCmd(action: string, excelGraphicView: ExcelGraphicView): any {
        var cmd = new NewRowElementCmd(excelGraphicView, this.getSelectionModel().doCacheTagNodes(), action);
        var selectSheetView = <SheetView>excelGraphicView.getSelectSheetView();
        selectSheetView.setMaxRow(Math.max(selectSheetView.getMaxRow(), EXCEL.D_MAX_ROW_SIZE) + 1);
        this.getCmdQueue().doCmd(cmd);
    }

    //删除行
    public doDeleteRowElementCmd(action: string, excelGraphicView: ExcelGraphicView): any {
        var cmd = new DeleteRowElementCmd(excelGraphicView, this.getSelectionModel().doCacheTagNodes(), action);
        var selectSheetView = <SheetView>excelGraphicView.getSelectSheetView();
        selectSheetView.setMaxRow(Math.max(selectSheetView.getMaxRow(), EXCEL.D_MAX_ROW_SIZE) - 1);
        this.getCmdQueue().doCmd(cmd);
    }

    //新增列
    public doNewColumnElementCmd(action: string, excelGraphicView: ExcelGraphicView): any {
        var cmd = new NewColumnElementCmd(excelGraphicView, this.getSelectionModel().doCacheTagNodes(), action);
        var selectSheetView = <SheetView>excelGraphicView.getSelectSheetView();
        selectSheetView.setMaxCol(Math.max(selectSheetView.getMaxCol(), EXCEL.D_MAX_COL_SIZE) + 1);
        this.getCmdQueue().doCmd(cmd);
    }

    //删除列
    public doDeleteColumnElementCmd(action: string, excelGraphicView: ExcelGraphicView): any {
        var cmd = new DeleteColumnElementCmd(excelGraphicView, this.getSelectionModel().doCacheTagNodes(), action);
        var selectSheetView = <SheetView>excelGraphicView.getSelectSheetView();
        selectSheetView.setMaxCol(Math.max(selectSheetView.getMaxCol(), EXCEL.D_MAX_COL_SIZE) - 1);
        this.getCmdQueue().doCmd(cmd);
    }

    //清除单元格
    public doEliminateCellCmd(action: string, excelGraphicView: ExcelGraphicView): any {
        var cmd = new EliminateCellCmd(excelGraphicView, this.getSelectionModel().doCacheTagNodes(), action);
        this.getCmdQueue().doCmd(cmd);
    }

    installToolbar(toolbar: Toolbar, viewContainer: ComplexDesignView<any, any>): void {
        var btnUndo = new Button("撤销");
        //btnUndo.setTitle("快捷键 Ctrl+z");
        btnUndo.setOnClickListener((e: MouseEvent) => viewContainer.undo());
        toolbar.addItem(btnUndo);
        var btnRedo = new Button("重做");
        //btnRedo.setTitle("快捷键 Ctrl+y");
        btnRedo.setOnClickListener((e: MouseEvent) => viewContainer.redo());
        toolbar.addItem(btnRedo);
        // 分隔符
        toolbar.addSeparator();
        var btnSwitch = new Button("源码");
        btnSwitch.setOnClickListener((e: MouseEvent) => {
            viewContainer.toggleSourceVisible();
            btnSwitch.setCaption(viewContainer.isSourceVisible() ? "视图" : "源码");
        });
        toolbar.addItem(btnSwitch);
    }

    installExcelToolbar(toolbar: ExcelToolbar): void {
        //文本操作
        var h5VFlexPanel = new PrintH5HFlexPanel(toolbar, "TestPanel");
        toolbar.addComponent(h5VFlexPanel, 1, 1, 5, 1)
        h5VFlexPanel.setStyle("position", "relative");
        h5VFlexPanel.addClass("bpm-toolbar")
        //字体
        var font = new PrintCombobox(130, "字体", "Name");
        font.setOnValueChanged((e: MouseEvent) => this.align_click("Display;Font", "Name", font.getValue()));
        font.initControl("宋体:宋体;新宋体:新宋体;仿宋:仿宋;黑体:黑体;微软雅黑:微软雅黑;隶书:隶书;楷体:楷体;Agency FB:Agency" +
            " FB;Algerian:Algerian;Arial:Arial;Arial Black:Arial Black;Arial Narrow:Arial Narrow;Arial:Arial;Arial Black:Arial Black;Arial Narrow:Arial Narrow;Book Antiqua:Book Antiqua;Bookman Old Style:Bookman Old Style;Bookshelf Symbol 7:Bookshelf Symbol 7;Bradley Hand ITC:Bradley Hand ITC;Calibri:Calibri;Calibri Light:Calibri Light;Cambria:Cambria;Cambria Math:Cambria Math;Candara:Candara;Candara Light:Candara Light;Century:Century;Century Gothic:Century Gothic;Comic Sans MS:Comic Sans MS;Consolas:Consolas;Constantia:Constantia;Corbel:Corbel;Corbel Light:Corbel Light;Courier New:Courier New;DejaVu Sans Mono:DejaVu Sans Mono;DengXian:DengXian;DengXian Light:DengXian Light;Dubai:Dubai;Dubai Light:Dubai Light;Dubai Medium:Dubai Medium;Ebrima:Ebrima;FangSong:FangSong;Franklin Gothic Medium:Franklin Gothic Medium;Freestyle Script:Freestyle Script;French Script MT:French Script MT;Gabriola:Gabriola;Gadugi:Gadugi;Garamond:Garamond;Georgia:Georgia;HoloLens MDL2 Assets:HoloLens MDL2 Assets;Impact:Impact;Ink Free:Ink Free;Javanese Text:Javanese Text;Juice ITC:Juice ITC;KaiTi:KaiTi;Kristen ITC:Kristen ITC;Leelawadee UI:Leelawadee UI;Leelawadee UI Semilight:Leelawadee UI Semilight;Lucida Bright:Lucida Bright;Lucida Console:Lucida Console;Lucida Handwriting:Lucida Handwriting;华文中宋:华文中宋;华文仿宋:华文仿宋;华文宋体:华文宋体;华文彩云:华文彩云;华文新魏:华文新魏;华文楷体:华文楷体;华文琥珀:华文琥珀;华文细黑:华文细黑;华文行楷:华文行楷;华文隶书:华文隶书;幼圆:幼圆;方正姚体:方正姚体;方正舒体:方正舒体;隶书:隶书            ")
        h5VFlexPanel.addComponent(font)
        //字体大小
        var fontSize = new PrintCombobox(50, "字体大小", "Size");
        fontSize.setOnValueChanged((e: MouseEvent) => this.align_click("Display;Font", "Size", fontSize.getValue()));
        fontSize.initControl("8;9;10;11;12;14;16;18;20;22;24;26;28;36;48;72")
        h5VFlexPanel.addComponent(fontSize)


        var qcolorLabel = new Label("前景色");
        qcolorLabel.setKey("qcolorLabel");
        qcolorLabel.setWidth(SizeInfo.valueOfPX(50));
        qcolorLabel.addClass("print-label")


        h5VFlexPanel.addComponent(qcolorLabel);
        var qcolorEditor = new ExcelColorEditor();
        qcolorEditor.setKey("ForeColor")
        qcolorEditor.setWidth(SizeInfo.valueOfPX(100));
        qcolorEditor.setHeight(SizeInfo.valueOfPX(23));
        qcolorEditor.addClass("print-colorEditor")
        qcolorEditor.setOnValueChanged((e: MouseEvent) => {
            this.align_click("Display", "ForeColor", qcolorEditor.getValue());

        })

        h5VFlexPanel.addComponent(qcolorEditor);


        var bcolorLabel = new Label("背景色");
        bcolorLabel.setKey("bcolorLabel");
        bcolorLabel.setWidth(SizeInfo.valueOfPX(50));
        bcolorLabel.addClass("print-label")
        h5VFlexPanel.addComponent(bcolorLabel);

        var bcolorEditor = new ExcelColorEditor();
        bcolorEditor.setKey("BackColor")
        bcolorEditor.setWidth(SizeInfo.valueOfPX(100));
        bcolorEditor.setHeight(SizeInfo.valueOfPX(23));
        bcolorEditor.addClass("print-colorEditor")
        bcolorEditor.setOnValueChanged((e: MouseEvent) => {
            this.align_click("Display", "BackColor", bcolorEditor.getValue());

        })
        h5VFlexPanel.addComponent(bcolorEditor);
        //加粗

        var bold = new PrintButton('', 'url("' + EXCEL.PREFIX + '/css/img/bold.png") center no-repeat', "粗体", "Bold");
        bold.setOnClickListener((e: MouseEvent) => this.align_click("Display;Font", "Bold", String(!TypeUtil.toBoolean(bold.getValue()))));
        h5VFlexPanel.addComponent(bold);
        var italic = new PrintButton('', 'url("' + EXCEL.PREFIX + '/css/img/italic.png") center no-repeat', "斜体", "Italic");
        italic.setOnClickListener((e: MouseEvent) => this.align_click("Display;Font", "Italic", String(!TypeUtil.toBoolean(italic.getValue()))));
        h5VFlexPanel.addComponent(italic);
        var wrapText = new PrintButton('WrapText', '', "自动换行", "wrapText");
        // italic.setOnClickListener((e: MouseEvent) => this.align_click("Display;Font", "Italic",
        // String(!TypeUtil.toBoolean(italic.getValue()))));
        wrapText.setWidth(SizeInfo.valueOfPX(100))
        // h5VFlexPanel.addComponent(wrapText);

        var h5VFlexPanel1 = new PrintH5HFlexPanel(toolbar, "StylePanel");
        toolbar.addComponent(h5VFlexPanel1, 1, 2, 5, 1)
        h5VFlexPanel1.setStyle("position", "relative");
        h5VFlexPanel1.addClass("bpm-toolbar")

        var append_row = new PrintButton('', 'url("' + EXCEL.PREFIX + '/css/img/append_row.png") center no-repeat', "添加行", "append_row");
        append_row.setOnClickListener((e: MouseEvent) => this.doAddRowElementCmd(ExcelConstants.NODE_AddRow_After, this.viewContainer.getGraphicView()));
        h5VFlexPanel1.addComponent(append_row);


        var insert_row = new PrintButton('', 'url("' + EXCEL.PREFIX + '/css/img/insert_row.png") center no-repeat', "插入行", "insert_row");
        h5VFlexPanel1.addComponent(insert_row);
        insert_row.setOnClickListener((e: MouseEvent) => this.doAddRowElementCmd(ExcelConstants.Node_Add_Row, this.viewContainer.getGraphicView()));
        var delete_row = new PrintButton('', 'url("' + EXCEL.PREFIX + '/css/img/delete_row.png") center no-repeat', "删除行", "delete_row");
        h5VFlexPanel1.addComponent(delete_row);
        delete_row.setOnClickListener((e: MouseEvent) => this.doDeleteRowElementCmd(ExcelConstants.Node_Add_Row, this.viewContainer.getGraphicView()));


        var append_column = new PrintButton('', 'url("' + EXCEL.PREFIX + '/css/img/append_column.png") center no-repeat', "添加列", "append_column");
        h5VFlexPanel1.addComponent(append_column);
        append_column.setOnClickListener((e: MouseEvent) => this.doNewColumnElementCmd(ExcelConstants.NODE_AddColumn_After, this.viewContainer.getGraphicView()));
        var insert_column = new PrintButton('', 'url("' + EXCEL.PREFIX + '/css/img/insert_column.png") center no-repeat', "插入列", "insert_column");
        h5VFlexPanel1.addComponent(insert_column);
        insert_column.setOnClickListener((e: MouseEvent) => this.doNewColumnElementCmd(ExcelConstants.Node_Add_Column, this.viewContainer.getGraphicView()));
        var delete_column = new PrintButton('', 'url("' + EXCEL.PREFIX + '/css/img/delete_column.png") center no-repeat', "删除列", "delete_column");
        h5VFlexPanel1.addComponent(delete_column);
        delete_column.setOnClickListener((e: MouseEvent) => this.doDeleteColumnElementCmd(ExcelConstants.Node_Remove_Column, this.viewContainer.getGraphicView()));
        var merge_cell = new PrintButton('', 'url("' + EXCEL.PREFIX + '/css/img/merge_cell.png") center no-repeat', "合并", "merge_cell");
        merge_cell.setOnClickListener((e: MouseEvent) => this.mergeCell());
        h5VFlexPanel1.addComponent(merge_cell);
        var split_cell = new PrintButton('', 'url("' + EXCEL.PREFIX + '/css/img/split_cell.png") center no-repeat', "分割", "split_cell");
        split_cell.setOnClickListener((e: MouseEvent) => this.divisionCell());
        h5VFlexPanel1.addComponent(split_cell);
        var left_align = new PrintButton('', 'url("' + EXCEL.PREFIX + '/css/img/left_align.png") center no-repeat', "左对齐", "left_align");
        left_align.setOnClickListener((e: MouseEvent) => this.align_click("Display", "HAlign", "Left"));
        h5VFlexPanel1.addComponent(left_align);
        var center_align = new PrintButton('', 'url("' + EXCEL.PREFIX + '/css/img/center_align.png") center no-repeat', "水平居中", "center_align");
        center_align.setOnClickListener((e: MouseEvent) => this.align_click("Display", "HAlign", "Center"));
        h5VFlexPanel1.addComponent(center_align);
        var right_align = new PrintButton('', 'url("' + EXCEL.PREFIX + '/css/img/right_align.png") center no-repeat', "右对齐", "right_align");
        right_align.setOnClickListener((e: MouseEvent) => this.align_click("Display", "HAlign", "Right"));
        h5VFlexPanel1.addComponent(right_align);
        var top_align = new PrintButton('', 'url("' + EXCEL.PREFIX + '/css/img/top_align.png") center no-repeat', "顶对齐", "top_align");
        top_align.setOnClickListener((e: MouseEvent) => this.align_click("Display", "VAlign", "Top"));
        h5VFlexPanel1.addComponent(top_align);
        var vcenter_align = new PrintButton('', 'url("' + EXCEL.PREFIX + '/css/img/vcenter_align.png") center no-repeat', "顶居中", "vcenter_align");
        vcenter_align.setOnClickListener((e: MouseEvent) => this.align_click("Display", "VAlign", "Center"));
        h5VFlexPanel1.addComponent(vcenter_align);
        var bottom_align = new PrintButton('', 'url("' + EXCEL.PREFIX + '/css/img/bottom_align.png") center no-repeat', "底对齐", "bottom_align");
        bottom_align.setOnClickListener((e: MouseEvent) => this.align_click("Display", "VAlign", "Bottom"));
        h5VFlexPanel1.addComponent(bottom_align);
        var images1 = ['url("' + EXCEL.PREFIX + '/css/img/border_none.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/border_style1.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/border_style_dashed.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/border_style_double.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/border_style_Hair.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/border_style_medium.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/border_style_Thick.png") center no-repeat'
        ]

        var border_style = new PrintButtonBox("border_style", images1, SizeInfo.valueOfPX(70), SizeInfo.valueOfPX(200));
        border_style.setTitle("边框类型");
        border_style.setValue("1");
        border_style.setStyle("margin-top", "2px");
        border_style.setWidth(SizeInfo.valueOfPX(95))
        border_style.setHeight(SizeInfo.valueOfPX(26))
        border_style.buttonText.setStyle("background", 'url("' + EXCEL.PREFIX + '/css/img/border_style1.png") center no-repeat');
        border_style.buttonText.setStyle(" background-size", '100%');
        border_style.setOnValueChanged((e: MouseEvent) => {
            var value = border_style.buttonText.getValue();
            this.border_click("Display;Border", ["TopStyle", "BottomStyle", "LeftStyle", "RightStyle"], value);
            border_style.buttonText.setStyle("background", images1[Number(value)]);

        });
        border_style.buttonText.setOnClickListener((e: MouseEvent) => {
            var value = border_style.buttonText.getValue();
            this.border_click("Display;Border", ["TopStyle", "BottomStyle", "LeftStyle", "RightStyle"], value);
        });
        h5VFlexPanel1.addComponent(border_style);
        //颜色
        var colorLabel = new Label("边框颜色");
        colorLabel.setWidth(SizeInfo.valueOfPX(70));
        colorLabel.addClass("print-label")
        colorLabel.setKey("BorderColor")
        h5VFlexPanel1.addComponent(colorLabel);
        var colorEditor = new ExcelColorEditor();
        colorEditor.addClass("print-colorEditor");
        colorEditor.setWidth(SizeInfo.valueOfPX(100));
        colorEditor.setHeight(SizeInfo.valueOfPX(23));

        //颜色
        colorEditor.setOnValueChanged((e: MouseEvent) => {
            var border_style_value = border_style.buttonText.getValue() || "1";
            if (border_style_value == "-1") {//无线样式
                return;
            }
            this.border_color_click("Display;Border", ["TopColor", "BottomColor", "LeftColor", "RightColor"], colorEditor.getValue());

        })
        h5VFlexPanel1.addComponent(colorEditor);
        var images = [
            'url("' + EXCEL.PREFIX + '/css/img/cell_full_border.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/cell_no_border.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/cell_full_out_border.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/cell_left_out_border.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/cell_right_out_border.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/cell_top_out_border.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/cell_bottom_out_border.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/cell_left_border.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/cell_right_border.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/cell_top_border.png") center no-repeat',
            'url("' + EXCEL.PREFIX + '/css/img/cell_bottom_border.png") center no-repeat'
        ];

        var cell_full_border = new PrintButtonBox("cell_full_border", images, SizeInfo.valueOfPX(51), SizeInfo.valueOfPX(286));
        cell_full_border.setTitle("边框模式")
        cell_full_border.setKey("BorderStyle")
        cell_full_border.setWidth(SizeInfo.valueOfPX(50));
        cell_full_border.setHeight(SizeInfo.valueOfPX(26));
        border_style.setValue("1");
        cell_full_border.buttonText.setStyle("background", 'url("' + EXCEL.PREFIX + '/css/img/cell_no_border.png") center no-repeat');
        cell_full_border.buttonText.setStyle(" background-size", '100%');

        //设置边框模式
        cell_full_border.setOnValueChanged((e: MouseEvent) => {
            var border_style_value = border_style.buttonText.getValue() || "1";
            border_style_value = Number(border_style_value)
            var border_color_value = colorEditor.getValue() || "BLACK";
            var cell_full_border_value = cell_full_border.buttonText.getValue() || "1";
            var styleType = "Thin";
            if (border_style_value <= 0) {//无线样式
                return;
            } else if (border_style_value == 1) {
                styleType = "Thin"
            } else if (border_style_value == 2) {
                styleType = "Dashed"
            } else if (border_style_value == 3) {
                styleType = "Double"
            } else if (border_style_value == 4) {
                styleType = "Hair"
            } else if (border_style_value == 5) {
                styleType = "Medium"
            } else if (border_style_value == 6) {
                styleType = "Thick"
            }
            this.style_border_click("Display;Border", ["TopColor", "BottomColor", "LeftColor", "RightColor", "TopStyle", "BottomStyle", "LeftStyle", "RightStyle"], styleType, border_color_value, cell_full_border_value);
            cell_full_border.buttonText.setStyle("background", images[Number(cell_full_border_value)]);
        });
        cell_full_border.buttonText.setOnClickListener((e: MouseEvent) => {
            var border_style_value = border_style.buttonText.getValue() || "1";
            border_style_value = Number(border_style_value)
            var border_color_value = colorEditor.getValue() || "BLACK";
            var cell_full_border_value = cell_full_border.buttonText.getValue() || "1";
            var styleType = "Thin";
            if (border_style_value <= 0) {//无线样式
                return;
            } else if (border_style_value == 1) {
                styleType = "Thin"
            } else if (border_style_value == 2) {
                styleType = "Dashed"
            } else if (border_style_value == 3) {
                styleType = "Double"
            } else if (border_style_value == 4) {
                styleType = "Hair"
            } else if (border_style_value == 5) {
                styleType = "Medium"
            } else if (border_style_value == 6) {
                styleType = "Thick"
            }
            this.style_border_click("Display;Border", ["TopColor", "BottomColor", "LeftColor", "RightColor", "TopStyle", "BottomStyle", "LeftStyle", "RightStyle"], styleType, border_color_value, cell_full_border_value);
        })
        h5VFlexPanel1.addComponent(cell_full_border);

        var clear_cell = new PrintButton('', 'url("' + EXCEL.PREFIX + '/css/img/clear_field.png") center no-repeat', "清除字段", "clear_cell");
        clear_cell.setOnClickListener((e: MouseEvent) => this.doEliminateCellCmd(ExcelConstants.Node_Remove_Column, this.viewContainer.getGraphicView()));
        h5VFlexPanel1.addComponent(clear_cell);

        var h5VFlexPanel2 = new PrintH5HFlexPanel(toolbar, "ButtonTextPanel");
        toolbar.addComponent(h5VFlexPanel2, 1, 3, 5, 1);
        var button = new PrintButton("...", "", "点击输入公式", "showEvl");
        button.setWidth(SizeInfo.valueOfPX(40));
        h5VFlexPanel2.addComponent(button)
        var textEditor = new PrintTextEditor("text");
        textEditor.setWidth(SizeInfo.PERCENT100);
        textEditor.addEventListener("keyup", (e: KeyUpEvent) => {
            if (!e.ctrlKey && e.code != "ControlLeft" && e.code != "ControlRight") {
                if (e.code != "ArrowDown" && e.code != "ArrowUp" && e.code != "ArrowLeft" && e.code != "ArrowRight")
                    this.imageValue(textEditor.getValue(), e);
            }
        });
        /*     textEditor.setOnValueChanged(
                 (e: MouseEvent) =>this.imageValue("Cell","Definition",textEditor.getValue()) )*/
        h5VFlexPanel2.addComponent(textEditor)
        button.setOnClickListener((e: MouseEvent) => {
            let root = <TagNode>this.getXmlEntity().getRoot().getChildren()[1];
            var exp = "Macro_ShowFormulaDialog(\"" + "Definition" + "\", {" + textEditor.getValue() + "}, \"" + root.getAttributeValue("FormKey") + "\")"
            this.operationDispatcher.eval(exp);
        });

    }


    protected prepareToolbar(toolbar: Toolbar): void {
        var btnSave = new Button("保存");
        btnSave.setOnClickListener((e: MouseEvent) => {
            this.save();
        });
        toolbar.addItem(btnSave);

        var btnDelete = new Button("删除");
        btnDelete.setOnClickListener((e: MouseEvent) => {
            this.delete();
        });
        toolbar.addItem(btnDelete);
        this.installToolbar(toolbar, this.viewContainer);
    }

    save(): void {
        var exp = `SaveExcel()`;
        this.operationDispatcher.eval(exp);
    }


    getCmdQueue(): CmdQueue {
        return this.viewContainer.getGraphicView().getXmlEntity().getCmdQueue();
    }

    align_click(tagName: string, type: string, alignmentValue: string): void {
        this.getSelectionModel().getSingleSeletionItem();
        var iTagNodes = this.getSelectionModel().doCacheTagNodes();
        var selectSheetView = <SheetView>this.getGraphicView().getSelectSheetView();
        var cmd = new SetAlignmentCmd(tagName, this.getXmlEntity(), iTagNodes, alignmentValue, [""], type, selectSheetView);
        this.getCmdQueue().doCmd(cmd);
    }

    imageValue(alignmentValue: string, e: any): void {
        this.getSelectionModel().getSingleSeletionItem();
        var iTagNode = this.getGraphicView().getSelectExcelView();
        var selectSheetView = <SheetView>this.getGraphicView().getSelectSheetView();
        var childNode = <ExcelCellView>selectSheetView.getChildNodeByTagNode(iTagNode!.getTagNode());
        var cmd;

        if (!childNode) {
            cmd = new EnsureSetImageValueCmd(this.getXmlEntity(), selectSheetView, <ITagNode>iTagNode!.getTagNode(), alignmentValue, this.getGraphicView());
            this.getCmdQueue().doCmd(cmd);
        } else {
            childNode.setValue(alignmentValue);
            cmd = new SetImageValueCmd(this.getXmlEntity(), <ITagNode>iTagNode!.getTagNode(), alignmentValue, <SheetView>this.getGraphicView().getSelectSheetView());
            this.getCmdQueue().doCmd(cmd);
        }

    }

    divisionCell(): void {
        this.getSelectionModel().getSingleSeletionItem();
        var iTagNodes = this.getSelectionModel().doCacheTagNodes();
        var cmd = new DivisionCellCmd(this.getGraphicView(), this.getXmlEntity(), iTagNodes);
        this.getCmdQueue().doCmd(cmd);
    }

    mergeCell(): void {
        this.getSelectionModel().getSingleSeletionItem();
        var iTagNodes = this.getSelectionModel().doCacheTagNodes();
        var selectSheetView = <SheetView>this.getGraphicView().getSelectSheetView();
        var cmd = new MergeCellCmd(this.getXmlEntity(), iTagNodes, this, selectSheetView);
        this.getCmdQueue().doCmd(cmd);
    }

    border_click(tagName: string, type: string[], alignmentValue: string): void {
        this.getSelectionModel().getSingleSeletionItem();
        var iTagNodes = this.getSelectionModel().doCacheTagNodes();
        var cmd = new SetBorderCmd(<SheetView>this.getGraphicView().getSelectSheetView(), tagName, this.getXmlEntity(), iTagNodes, alignmentValue, type);
        this.getCmdQueue().doCmd(cmd);
    }

    border_color_click(tagName: string, type: string[], alignmentValue: string): void {
        this.getSelectionModel().getSingleSeletionItem();
        var iTagNodes = this.getSelectionModel().doCacheTagNodes();
        let graphicView = this.getGraphicView();
        var cmd = new SetBorderColorCmd(tagName, this.getXmlEntity(), iTagNodes, alignmentValue, type, graphicView);
        this.getCmdQueue().doCmd(cmd);
    }

    style_border_click(tagName: string, type: string[], style_border: string, border_color: string, border_style: string): void {
        this.getSelectionModel().getSingleSeletionItem();
        var iTagNodes = this.getSelectionModel().doCacheTagNodes();
        var cmd = new SetStyleBorderCmd(this.getGraphicView(), tagName, this.getXmlEntity(), iTagNodes, style_border, border_color, border_style, [[]], type);
        this.getCmdQueue().doCmd(cmd);
    }

    delete(): void {
        var exp = `DeleteBpm()`;
        this.operationDispatcher.eval(exp);
    }

    deleteElement(): void {
        throw new Error("Method not implemented.");
    }

//
    private DEMO_XML: string = `<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<Workbook Caption="www" FormKey="DataObjectForm" Key="www">
    <Sheet Name="Sheet1">
        <Rows>
            <Row RowIndex="1" Type="Head">
                <Cell CellIndex="6" SourceType="Const" MergedRowSpan="30"/>
            </Row>
            <Row RowIndex="2">
                <Cell CellIndex="1" Definition="DVERID" TableKey="ED_DataObjectFormHead"/>
            </Row>
            <Row RowIndex="3">
                <Cell CellIndex="4" Definition="InList(value, cn);" SourceType="Const"/>
            </Row>
            <Row RowIndex="4" Type="Group" TableKey="ED_DataObjectField">
                <Cell CellIndex="2" SourceType="Const" MergedColumnSpan="6"/>
            </Row>
            <Row RowIndex="5" Type="Group">
                <Cell CellIndex="1" Definition="对象标识" SourceType="Const"/>
                <Cell CellIndex="2" Definition="OID" TableKey="ED_DataObjectFormHead"/>
            </Row>
            <Row RowIndex="6" Type="Group"/>
            <Row RowIndex="9">
                <Cell CellIndex="2" Definition="Sum()" SourceType="Formula"/>
            </Row>
            <Row RowIndex="11">
                <Cell CellIndex="4" Definition="ToDecimal(value)" SourceType="Const"/>
            </Row>
            <Row RowIndex="13" Type="Detail" TableKey="ED_DataObjectField"/>
        </Rows>
        <Columns>
            <Column ColumnIndex="7" Width="98"/>
        </Columns>
    </Sheet>
</Workbook>
`;

    protected createPropertyIO(): IPropertyIO {
        return new ExcelPropertyIO(this.getXmlEntity(), this.getGraphicView());
    }
}