import JComponent from "../../../../common/component/JComponent";
import DomUtil from "../../../../common/dom/DomUtil";
import SpanElement from "../../../../common/dom/element/SpanElement";
import SizeInfo from "../../../../common/struct/SizeInfo";
import ITagNode from "../../../../common/xml/node/ITagNode";
import BaseConstants from "../../../base/BaseConstants";
import IDataMigrationElementView from "./IDataMigrationElementView";
import DataMigrationTableLayout from "../DataMigrationTableLayout";
import {FieldView} from "../FieldView";
import Span from "../../../../common/component/control/Span";
import InputElement from "../../../../common/dom/element/InputElement";
import ArrayList from "../../../../common/struct/ArrayList";
import DataMigrationConstants from "../../base/DataMigrationConstants";
import DataMigrationGraphicView from "../DataMigrationGraphicView";
import TextEditor from "../../../../common/component/control/TextEditor";
import Menu from "../../../../common/component/menu/Menu";
import DATAMIGRATION from "../../base/DATAMIGRATION";
import DataMigrationUtil from "../../base/DataMigrationUtil";
import {CommonConstant} from "../../../datamap/base/CommonConstant";

export default class SourceTableView extends JComponent<DataMigrationTableLayout> implements IDataMigrationElementView {
    get isSource(): boolean {
        return this._isSource;
    }

    private tagNode: ITagNode;

    private tableElement: DataMigrationTableLayout;

    private addicon: Span | undefined;
    private addItemButton: Span | undefined;
    private addItemInput: TextEditor | undefined;

    private inputButton: InputElement | undefined;
    private menu: Menu = new Menu();

    private tableName: string | undefined;
    private fieldItems: string = ""
    private isFirst: boolean = false;
    private _isSource: boolean = true;

    constructor(tagNode: ITagNode, isFirst: boolean, map: Map<string, any>, dataMigrationGraphicView: DataMigrationGraphicView) {
        super(new DataMigrationTableLayout(0, 0));
        this.tagNode = tagNode;
        this.tableElement = this.getDomElement();
        if (tagNode.getTagName() == DataMigrationConstants.NODE_SourceTable) {
            this.tableElement.init(DATAMIGRATION.D_ROW_HEIGHT, tagNode.getParent()!.getAttributeValueInt(BaseConstants.ATTR_Width, 0));
        } else {
            this.tableElement.init(DATAMIGRATION.D_ROW_HEIGHT, tagNode.getAttributeValueInt(BaseConstants.ATTR_Width, 0));
        }
        this.tableElement.addClass('layout');
        if (isFirst) {
            this.isFirst = true;
            this.buildFirstTable(map, dataMigrationGraphicView);
        } else {
            this.buildTable(map, dataMigrationGraphicView);
        }

    }


    getFieldItems(): string {
        return this.fieldItems;
    }

    getMenu(): Menu {
        return this.menu;
    }


    setFieldItems(fieldItems: string): void {
        this.fieldItems = fieldItems;
    }

    findChildNode(tagNode: ITagNode): IDataMigrationElementView | null {
        throw new Error("Method not implemented.");
    }

    updateView(): void {
        //更新选中状态
        this.getTagNode().isSelected() ? this.addClass('selected') : this.removeClass('selected');
    }

    /* findChildNode(tagNode: ITagNode): IPrintElementView | null {
         for (var row=0; row<=this.tableElement.getLastRowIndex(); row++) {
             for (var col=0; col<=this.tableElement.getLastColumnIndex(); col++) {
                 var cell = this.tableElement.getCellAt(row, col);
                 var cellView = <CellView> cell.getContent();
                 if (cellView && cellView.getTagNode() == tagNode) {
                     return cellView;
                 }
             }
         }
         return null;
     }*/

    isEmbed(): boolean {
        return false;
    }

    getTagNode(): ITagNode {
        return this.tagNode;
    }

    getAddItemButton(): Span | undefined {
        return this.addItemButton;
    }

    getAddItemInput(): TextEditor | undefined {
        return this.addItemInput;
    }

    getInputButton(): InputElement | undefined {
        return this.inputButton;
    }

    buildTable(map: Map<string, any>, dataMigrationGraphicView: DataMigrationGraphicView) {
        var tagRow = this.tagNode;
        var firstTitle = this.tableElement.addField("source");
        let itemTd = this.tableElement.addSpan();
        this.addicon = itemTd.getIcon();
        this.inputButton = itemTd.getInputButton();
        this.addItemButton = itemTd.getAddItemButton();
        this.addItemInput = itemTd.getAddItemInput();
        var firstView = new FieldView(this.tagNode);
        firstTitle.addChild(firstView)
        let filed = map.get(this.tagNode.getAttributeValue(DataMigrationConstants.Attr_Key));
        firstView.updateView("", dataMigrationGraphicView, filed?.DataType, "");
        var mapNode = this.tagNode.getParent()!.getParent()!;
        let srcDataObjectKey = mapNode.getAttributeValue("SrcDataObjectKey");
        let tableKey = this.tagNode.getAttributeValue(DataMigrationConstants.Attr_Key);
        this.tableName = srcDataObjectKey + "|" + tableKey;
        this.addicon.getDomElement().setAttr("tableName", this.tableName);
        this.inputButton.setAttr("tableName", this.tableName);
        this.addItemButton.getDomElement().setAttr("tableName", this.tableName);
        firstView.setText("(表" + map.get(tableKey)?.index + ")   " + tableKey
            + " " + map.get(tableKey)?.Caption);
        firstView.setStyle('font-size', '14px');
        firstView.setStyle('font-weight', 'bold');
        firstTitle.addClass("tablehead");
        var tagCells = tagRow.getChildren();
        let list = new ArrayList();
        for (var colindex = 0; colindex < tagCells.length; colindex++) {
            var tagField = <ITagNode>tagCells[colindex];
            let showText = DataMigrationUtil.getSourceFieldShowText(tagField);
            if (!list.contain(showText)) {
                var field = this.tableElement.addField("source");
                var cellView = new FieldView(tagField);
                field.addChild(cellView);
                let type = tagField.getAttributeValue(CommonConstant.NODE_Type);
                cellView.updateView(map.get(showText)?.Caption, dataMigrationGraphicView, map.get(showText)?.DataType, type);
                list.add(showText)
            }
        }
    }

    buildFirstTable(map: Map<string, any>, dataMigrationGraphicView: DataMigrationGraphicView) {
        let firstTitle = this.tableElement.addField("source");
        var firstView = new FieldView(this.tagNode);

        firstTitle.addClass("tablehead");
        firstTitle.addChild(firstView)
        let iTagNode = this.tagNode.getParent()!;
        let attributeValue = iTagNode.getAttributeValue("SrcDataObjectKey");
        this.tableName = attributeValue;
        firstView.buildFirstView(map.get(attributeValue)?.Caption);
        let itemTd = this.tableElement.addSpan();
        this.addicon = itemTd.getIcon();
        this.inputButton = itemTd.getInputButton();
        this.addItemInput = itemTd.getAddItemInput();
        this.addItemButton = itemTd.getAddItemButton();
        this.addicon.getDomElement().setAttr("tableName", attributeValue);
        this.inputButton.setAttr("tableName", attributeValue);
        this.addItemButton?.getDomElement().setAttr("tableName", attributeValue);

    }


    createCellSpan(tagCell: ITagNode): SpanElement {
        var span = new SpanElement(tagCell.getAttributeValue(BaseConstants.ATTR_Caption));
        return span;
    }

    getWidth(): SizeInfo {
        return SizeInfo.valueOfPX(this.tableElement.getWidth()!);
    }

    getAddIcon(): Span {
        return this.addicon!;
    }

    getIsFirst(): boolean {
        return this.isFirst;
    }

    getTableName(): string {
        return this.tableName!;
    }

    getHeight(): SizeInfo {
        return SizeInfo.valueOfPX(this.tableElement.getHeight()!);
    }

    containPoint(x: number, y: number): boolean {
        var offset = DomUtil.offsetParent(this.getEl());
        var top = offset.offsetTop;
        var left = offset.offsetLeft;
        var width = this.getDomElement().getHtmlClientWidth();
        var height = this.getDomElement().getHtmlClientHeight();
        return x >= left && x <= (left + width)
            && y >= top && y <= (top + height);
    }

    locCell(x: number, y: number): FieldView | null {
        var cellLocation = this.tableElement.hitCell(x, y);
        if (cellLocation) {
            var cell = this.tableElement.getCell(cellLocation);
            return <FieldView>cell.getContent();
        } else if (cellLocation == 0) {
            var cell = this.tableElement.getCell(0);
            return <FieldView>cell.getContent();
        }
        return null;
    }


}