import AbstractDomElement from "../../../common/dom/AbstractDomElement";
import SizeInfo from "../../../common/struct/SizeInfo";
import TextEditor from "../../../common/component/control/TextEditor";
import Span from "../../../common/component/control/Span";
import DATAMIGRATION from "../base/DATAMIGRATION";
import InputElement from "../../../common/dom/element/InputElement";

export default class DataMigrationTableLayout extends AbstractDomElement {
    private tBody!: TBody;
    private height: number | undefined;
    private width: number | undefined;
    private fieldlist: ItemTd | undefined;

    constructor(height: number, width: number) {
        super();
        this.init(height, width);
    }

    init(height: number, width: number) {
        this.clearChildren();
        this.tBody = new TBody(height, width);
        this.addChild(this.tBody);
        this.height = height;
        this.width = width;
    }

    protected createEl(tag: string): HTMLElement {
        return document.createElement("table");
    }


    getWidth() {
        return this.width;
    }

    getHeight() {
        return this.height;
    }

    getFieldList() {
        return this.fieldlist;
    }

    getCell(cellLocation: number): Field {
        return <Field>this.tBody.getRow(cellLocation).getChildAt(0);
    }

    addField(name: string): Field {
        var row = new Row()
        row.setAttr("sourcetype", name);
        var field = new Field(null);
        row.addField(field)
        this.tBody.addChild(row);
        return field;
    }

    addSpan(): ItemTd {
        var row = new Row()
        var field = new ItemTd(null);
        this.fieldlist = field;
        row.addSpan(field)
        this.tBody.addChild(row);
        return field;
    }

    resetRowsTop(): void {
        this.tBody.resetRowsTop();
    }

    hitCell(x: number, y: number): number | null {
        this.resetRowsTop();
        var hitRowIndex = -1;
        for (var rowIndex = 0; rowIndex < this.tBody.getRowCount(); rowIndex++) {
            var row = this.tBody.getRow(rowIndex);
            if (y > row.getTop() && y <= row.getTop() + row.getHeight()) {
                hitRowIndex = rowIndex;
                break;
            }
        }
        if (hitRowIndex == -1) return null;
        return hitRowIndex;
    }
}


class TBody extends AbstractDomElement {

    private height: number;
    private width: number;


    constructor(height: number, width: number) {
        super();
        this.height = height;
        this.width = width
    }


    protected createEl(tag: string): HTMLElement {
        return document.createElement("tbody");
    }

    /**
     * 返回行数
     * @returns
     */
    getRowCount(): number {
        return this.getChildCount(); // 第一行不算
    }

    /**
     * 获取行
     * @param index
     * @returns
     */
    getRow(index: number): Row {
        return <Row>this.getChildAt(index); // 第一行不算
    }

    resetRowsTop() {
        var top = 0;
        for (var rowIndex = 0; rowIndex < this.getRowCount(); rowIndex++) {
            var row = this.getRow(rowIndex);
            row.setTop(top);
            top += row.getHeight();
        }
    }


    getLastRowIndex(): number {
        return this.getRowCount() - 1;
    }
}

class Row extends AbstractDomElement {
    private top: number = 0;

    constructor() {
        super();
        //this.height = height;
        this.setStyleHeight(SizeInfo.valueOfPX(DATAMIGRATION.D_ROW_HEIGHT));

    }

    protected createEl(tag: string): HTMLElement {
        return document.createElement("tr");
    }

    setTop(top: number) {
        this.top = top;
    }

    getTop() {
        return this.top;
    }


    getHeight(): number {
        return this.getHtmlClientHeight(); // 此处不用配置中的行height，是因为erp中有多个控件放在一个grid cell中的用法，会将row高度撑大
    }

    addField(cell: Field) {
        this.addChild(cell);
    }

    addSpan(item: ItemTd) {
        this.addChild(item);
    }

    getField(col: number): Field {
        return <Field>this.getChildAt(col);
    }

    setFieldValue(col: number, value: any): void {
        var cell = this.getField(col);
        cell.setText(value);
    }

    setFieldElement(col: number, element: AbstractDomElement): Field {
        var cell = this.getField(col);
        cell.setContent(element);
        return cell;
    }
}

class ItemTd extends AbstractDomElement {

    private marked: boolean = false;
    private span: Span;
    private inputButton: InputElement;
    private addItemButton: Span;
    private addItemInput: TextEditor;

    //private textEditor: Span;

    constructor(el: HTMLElement | null) {
        super(el);
        let span1 = new Span("请输入");
        this.addItemInput = new  TextEditor();
        this.addItemInput.setStyle("display", "none");
        this.addClass("fieldArea");
        this.setStyle("border-width", "thin");
        span1.addClass("addItemButton");
        span1.setStyle("color", "#999");
        span1.setStyle("width", "100%");
        this.addItemButton = span1;
        let span3 = new Span("");
        this.span = span3;
        span3.setStyle("background", 'url("' + DATAMIGRATION.PREFIX + '/css/img/selectField.png")  center no-repeat');
        span3.setStyle("cursor", 'pointer');
        span3.addClass("selectButton");
        //
        let input = new InputElement();
        input.setAttr("type", "button")
        input.setAttr("name", "button")
        input.setAttr("value", "...")
        input.addClass("inputButton")
        this.inputButton = input;
        this.appendChild(span1);
        this.appendChild(span3);
        this.appendChild(input);
        this.appendChild(this.addItemInput);
    }

    protected createEl(tag: string): HTMLElement {
        return document.createElement("td");
    }

    appendChild(any: any) {
        this.getEl().appendChild(any.getEl());
    }

    setContent(element: AbstractDomElement): void {
        this.addChild(element);
    }

    getContent(): AbstractDomElement | null {
        if (this.getChildCount() == 0) return null;
        return this.getChildAt(0);
    }

    getIcon(): Span {
        return this.span;
    }

    getInputButton(): InputElement {
        return this.inputButton;
    }

    getAddItemButton(): Span {
        return this.addItemButton;
    }
    getAddItemInput(): TextEditor {
        return this.addItemInput;
    }


}

class Field extends AbstractDomElement {

    private marked: boolean = false;

    //  private textEditor: TextEditor;

    constructor(el: HTMLElement | null) {
        super(el);
        //this.textEditor = new TextEditor();
        // this.textEditor.setStyle("display", "none");
        this.addClass("fieldArea")
        //   this.appendChild(this.textEditor);
    }

    protected createEl(tag: string): HTMLElement {
        return document.createElement("td");
    }

    appendChild(any: any) {
        this.getEl().appendChild(any.getEl());
    }

    setContent(element: AbstractDomElement): void {
        this.addChild(element);
    }

    getContent(): AbstractDomElement | null {
        if (this.getChildCount() == 0) return null;
        return this.getChildAt(0);
    }

    /*
        setValue(value: string): void {
            this.getContent()?.setText(value);
            this.textEditor.setValue(value);

        }

        getTextEditor(): TextEditor {
            return this.textEditor;
        }
    */


}